
/*
  $Id: lists.h,v 1.7 2005/12/02 14:33:47 ldv Exp $
  Copyright (C) 2002, 2003, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The list manipulations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#ifndef __LISTS_H__
#define __LISTS_H__

#include <sys/types.h>

#define DECLARE_LISTS( arg ) \
extern const char **list_##arg; \
extern size_t size_##arg; \
extern void add_##arg (const char *)

DECLARE_LISTS(search_paths);
DECLARE_LISTS(prune_path);
DECLARE_LISTS(prune_fs);

extern long *list_prune_fstype;
extern size_t fstype_list_size;

extern void convert_fs_paths(void);

#endif /* __LISTS_H__ */
