
/*
  $Id: methods.h,v 1.5 2005/12/02 14:21:30 ldv Exp $
  Copyright (C) 2002, 2003, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The locate methods declarations.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#ifndef __METHODS_H__
#define __METHODS_H__

#include <stdio.h>

typedef void *OPEN_FPTR(const char *, int);
typedef void CLOSE_FPTR(void *);
typedef int MATCH_FPTR(void *, const char *, int);

typedef struct
{
	OPEN_FPTR *open;
	CLOSE_FPTR *close;
	MATCH_FPTR *match;
}
match_context;

extern void *substr_open(const char *pattern, int icase);
extern int substr_match(void *handle, const char *sample, int icase);

extern void *glob_open(const char *pattern, int icase);
extern int glob_match(void *handle, const char *sample, int icase);

extern void *regex_open(const char *pattern, int icase);
extern void regex_close(void *handle);
extern int regex_match(void *handle, const char *sample, int icase);

extern unsigned match(match_context * ctx, const char *pattern, FILE * fp,
		      const char *dbfile, int icase, int echeck);

#endif /* __METHODS_H__ */
