
/*
  $Id: nextelem.c,v 1.4 2005/12/02 14:21:30 ldv Exp $
  Copyright (C) 1992, 2002 Free Software Foundation, Inc.
  Copyright (C) 2005  Dmitry V. Levin <ldv@altlinux.org>

  Return the next element of a path.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA

  Written by David MacKenzie <djm@gnu.ai.mit.edu>,
  inspired by John P. Rouillard <rouilj@cs.umb.edu>.
  Modified by Dmitry V. Levin <ldv@altlinux.org>.
*/

#include <string.h>
#include <stdlib.h>

#include "nextelem.h"
#include "xmalloc.h"

/* Return the next element of a colon-separated path.
   A null entry in the path is equivalent to "." (the current directory).

   If NEW_PATH is non-NULL, set the path and return NULL.
   If NEW_PATH is NULL, return the next item in the string, or
   return NULL if there are no more elements.  */

const char *
next_element(const char *new_path)
{
	static char *path;	/* Freshly allocated copy of NEW_PATH.  */
	static char *end;	/* Start of next element to return.  */
	static int final_colon;	/* If zero, path didn't end with a colon.  */
	char   *start;		/* Start of path element to return.  */

	if (new_path)
	{
		free(path);
		end = path = xstrdup(new_path);
		final_colon = 0;
		return 0;
	}

	if (*end == '\0')
	{
		if (final_colon)
		{
			final_colon = 0;
			return ".";
		}
		return 0;
	}

	start = end;
	final_colon = 1;	/* Maybe there will be one.  */

	end = strchr(start, ':');
	if (end == start)
	{
		/* An empty path element.  */
		*end++ = '\0';
		return ".";
	} else if (!end)
	{
		/* The last path element.  */
		end = strchr(start, '\0');
		final_colon = 0;
	} else
		*end++ = '\0';

	return start;
}
