
/*
  $Id: regex.c,v 1.6 2005/12/02 14:33:47 ldv Exp $
  Copyright (C) 2002, 2004, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The regex method for locate.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <stdio.h>
#include <errno.h>
#include <error.h>
#include <string.h>
#include <stdlib.h>
#include <regex.h>

#include "methods.h"
#include "xmalloc.h"

__attribute__ ((noreturn))
     static void reg_fatal(int rc, regex_t * preg)
{
	size_t  len = regerror(rc, preg, 0, 0UL);
	char   *errbuf = alloca(len);

	regerror(rc, preg, errbuf, len);
	error(EXIT_FAILURE, 0, "regcomp: %s", errbuf);
	exit(EXIT_FAILURE);
}

void   *
regex_open(const char *pattern, int icase)
{
	int     rc;
	regex_t *preg = xmalloc(sizeof(*preg));

	memset(preg, 0, sizeof(*preg));
	rc = regcomp(preg, pattern,
		     (icase ? REG_ICASE : 0) | REG_EXTENDED | REG_NOSUB);
	if (rc)
		reg_fatal(rc, preg);

	return preg;
}

void
regex_close(void *handle)
{
	regex_t *preg = (regex_t *) handle;

	regfree(preg);
	free(preg);
}

int
regex_match(void *handle, const char *sample, __attribute__ ((unused))
	    int icase)
{
	regex_t *preg = (regex_t *) handle;
	int     rc = regexec(preg, sample, 0UL, 0, 0);

	if (!rc)
		return 1;
	else if (REG_NOMATCH != rc)
		reg_fatal(rc, preg);

	return 0;
}
