# $Id: slocate.spec,v 1.10 2005/12/02 14:34:55 ldv Exp $

Name: slocate
Version: 0.2.8
Release: alt1
Serial: 1

Summary: Finds files on a system via central file name database
License: GPL
Group: File tools

Source: %name-%version.tar.bz2

PreReq: shadow-utils

# Automatically added by buildreq on Tue Oct 08 2002
BuildRequires: libcap-devel

%description
This is a security-enhanced version of locate.  Just like locate, %name
searches through a central database (which is usually updated nightly)
for files which match a given pattern.  Locate allows you to quickly
find files anywhere on your system.

%prep
%setup -q

%build
%make_build CFLAGS="%optflags"

%install
make install
install -pD -m644 /dev/null %buildroot%_localstatedir/locate/locatedb

%pre
/usr/sbin/groupadd -r -f %name
/usr/sbin/useradd -r -g %name -d /dev/null -s /dev/null -n %name >/dev/null 2>&1 ||:

%files
%attr(2711,root,%name) %_bindir/%name
%_bindir/locate
%_sbindir/*
%config %_sysconfdir/cron.daily/*
%config(noreplace) %_sysconfdir/*.conf
%_mandir/man?/*
%attr(710,root,%name) %dir %_localstatedir/locate
%attr(640,root,%name) %verify(not md5 mtime size) %ghost %_localstatedir/locate/locatedb

%changelog
* Fri Dec 02 2005 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.8-alt1
- Enabled most of non-default compiler warning options
  and fixed all uncovered issues.
- In mklocatedb, implemented temporary file removal
  in case of fatal error.
- Updated prunefs and prunepath lists (#5792).

* Sun Sep 05 2004 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.7-alt1
- locate: eliminated cast from pointer to integer.

* Sat Jan 17 2004 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.6-alt1
- locate: implemented --no-existing option.

* Sun Aug 17 2003 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.5-alt1
- Enhanced prunefs support.

* Sat Aug 16 2003 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.4-alt1
- Enhanced prunefs support.
- %%pre script policy enforcement.

* Sun Dec 15 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.3-alt1
- Build with LFS enabled by default.

* Tue Oct 08 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.2-alt1
- Added to default prunefs list:
  cardfs cefs davfs ftpfs localfs sshfs.

* Mon May 13 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.2.1-alt1
- Relocated locate to slocate, added symlink.

* Tue May 07 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.2-alt1
- Fixed false "corrupted database" error reporting.
- Reorganized locate matching code (ready for new methods).
- Fixed "check_existence" logic: existence check enabled by default
  only for privileged mode.

* Fri Apr 19 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.1.2-alt1
- Enhanced database corruption diagnostics.

* Wed Apr 17 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.1.1-alt1
- Honor --ignore-case also in plain lookup.

* Sun Apr 14 2002 Dmitry V. Levin <ldv@altlinux.org> 1:0.1-alt1
- Initial revision.
