
/*
  $Id: substr.c,v 1.6 2005/12/02 14:21:30 ldv Exp $
  Copyright (C) 2002, 2004, 2005  Dmitry V. Levin <ldv@altlinux.org>

  The substr method for locate.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*/

#include <string.h>
#include "methods.h"

void   *
substr_open(const char *pattern, __attribute__ ((unused))
	    int icase)
{
	return (void *) pattern;
}

int
substr_match(void *handle, const char *sample, int icase)
{
	const char *pattern = (const char *) handle;

	return (icase ? strcasestr : strstr) (sample, pattern) ? 1 : 0;
}
