//==========================================================================
//
//      iso9660fs.h
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================

#ifndef CYGONCE_REDBOOT_ISO9660FS_H
#define CYGONCE_REDBOOT_ISO9660FS_H
/* volume descriptor types */
#define ISO_VD_PRIMARY 1
#define ISO_VD_SUPPLEMENTARY 2
#define ISO_VD_END 255

#define ISO_STANDARD_ID "CD001"

#define ISODCL(from, to) (to - from + 1)
struct iso_primary_descriptor {										/* TOC ( ) */
	unsigned char type						[ISODCL (  1,   1)]; 	/* volume descriptor type.0 = boot disk, 1 = base disk, 2 = advanced; */
	unsigned char id						[ISODCL (  2,   6)];	/* standart identifier "CD001" */
	unsigned char version					[ISODCL (  7,   7)]; 	/* volume decriptor version */
	unsigned char unused1					[ISODCL (  8,   8)];	/* unused */
	unsigned char system_id					[ISODCL (  9,  40)]; 	/* system identifier (ascii) */
	unsigned char volume_id					[ISODCL ( 41,  72)]; 	/* volume identifier (ascii) */
	unsigned char unused2					[ISODCL ( 73,  80)];	/* unused */
	unsigned char volume_space_size			[ISODCL ( 81,  88)]; 	/* number of logical block in volume */
	unsigned char unused3					[ISODCL ( 89, 120)];	/* unused */
	unsigned char volume_set_size			[ISODCL (121, 124)]; 	/* 723 */
	unsigned char volume_sequence_number	[ISODCL (125, 128)]; 	/* 723 */
	unsigned char logical_block_size		[ISODCL (129, 132)]; 	/*    (512,1024,2048) */
	unsigned char path_table_size			[ISODCL (133, 140)]; 	/* length in bytes of path table */
	unsigned char type_l_path_table			[ISODCL (141, 144)]; 	/* Logical Block Number of first Block allocated to the Type L Path Table, Type L meaning multiple byte numerical values
                                            							are recorded with least significant byte first. This value is also recorded with least significant byte first. */
	unsigned char opt_type_l_path_table		[ISODCL (145, 148)]; 	/* 0 if Optional Path Table was not recorded, otherwise, Logical Block Number of first Block allocated to the Optional Type L Path Table. */
	unsigned char type_m_path_table			[ISODCL (149, 152)]; 	/* Logical Block Number of first Block allocated to the Type M Path Table, Type M meaning multiple byte numerical values
																		are recorded with most significant byte first. This value is also recorded with most significant byte first. */
	unsigned char opt_type_m_path_table		[ISODCL (153, 156)]; 	/* 0 if Optional Path Table was not recorded, otherwise, Logical Block Number of first Block allocated to the Type M Path Table. */
	unsigned char root_directory_record		[ISODCL (157, 190)]; 	/* This is the actual directory record for the top of the directory structure.. */
	unsigned char volume_set_id				[ISODCL (191, 318)]; 	/* dchars */
	unsigned char publisher_id				[ISODCL (319, 446)]; 	/* achars */
	unsigned char preparer_id				[ISODCL (447, 574)]; 	/* achars */
	unsigned char application_id			[ISODCL (575, 702)]; 	/* achars */
	unsigned char copyright_file_id			[ISODCL (703, 739)]; 	/* 7.5 dchars */
	unsigned char abstract_file_id			[ISODCL (740, 776)]; 	/* 7.5 dchars */
	unsigned char bibliographic_file_id		[ISODCL (777, 813)]; 	/* 7.5 dchars */
	unsigned char creation_date				[ISODCL (814, 830)]; 	/* 8.4.26.1 */
	unsigned char modification_date			[ISODCL (831, 847)]; 	/* 8.4.26.1 */
	unsigned char expiration_date			[ISODCL (848, 864)]; 	/* 8.4.26.1 */
	unsigned char effective_date			[ISODCL (865, 881)]; 	/* 8.4.26.1 */
	unsigned char file_structure_version	[ISODCL (882, 882)]; 	/* 711 */
	unsigned char unused4					[ISODCL (883, 883)];
	unsigned char application_data			[ISODCL (884, 1395)];
	unsigned char unused5					[ISODCL (1396, 2048)];
};

/* Almost the same as the primary descriptor but two fields are specified */
struct iso_supplementary_descriptor {
	unsigned char type						[ISODCL (  1,   1)]; 	/*  */
	unsigned char id						[ISODCL (  2,   6)];
	unsigned char version					[ISODCL (  7,   7)]; 	/* 711 */
	unsigned char flags						[ISODCL (  8,   8)]; 	/* 853 */
	unsigned char system_id					[ISODCL (  9,  40)]; 	/* achars */
	unsigned char volume_id					[ISODCL ( 41,  72)]; 	/* dchars */
	unsigned char unused2					[ISODCL ( 73,  80)];
	unsigned char volume_space_size			[ISODCL ( 81,  88)]; 	/* 733 */
	unsigned char escape					[ISODCL ( 89, 120)]; 	/* 856 */
	unsigned char volume_set_size			[ISODCL (121, 124)]; 	/* 723 */
	unsigned char volume_sequence_number	[ISODCL (125, 128)]; 	/* 723 */
	unsigned char logical_block_size		[ISODCL (129, 132)]; 	/* 723 */
	unsigned char path_table_size			[ISODCL (133, 140)]; 	/* 733 */
	unsigned char type_l_path_table			[ISODCL (141, 144)]; 	/* 731 */
	unsigned char opt_type_l_path_table		[ISODCL (145, 148)]; 	/* 731 */
	unsigned char type_m_path_table			[ISODCL (149, 152)]; 	/* 732 */
	unsigned char opt_type_m_path_table		[ISODCL (153, 156)];	/* 732 */
	unsigned char root_directory_record		[ISODCL (157, 190)]; 	/* 9.1 */
	unsigned char volume_set_id				[ISODCL (191, 318)];	/* dchars */
	unsigned char publisher_id				[ISODCL (319, 446)];	/* achars */
	unsigned char preparer_id				[ISODCL (447, 574)];	/* achars */
	unsigned char application_id			[ISODCL (575, 702)];	/* achars */
	unsigned char copyright_file_id			[ISODCL (703, 739)];	/* 7.5 dchars */
	unsigned char abstract_file_id			[ISODCL (740, 776)];	/* 7.5 dchars */
	unsigned char bibliographic_file_id		[ISODCL (777, 813)];	/* 7.5 dchars */
	unsigned char creation_date				[ISODCL (814, 830)];	/* 8.4.26.1 */
	unsigned char modification_date			[ISODCL (831, 847)];	/* 8.4.26.1 */
	unsigned char expiration_date			[ISODCL (848, 864)];	/* 8.4.26.1 */
	unsigned char effective_date			[ISODCL (865, 881)];	/* 8.4.26.1 */
	unsigned char file_structure_version	[ISODCL (882, 882)];	/* 711 */
	unsigned char unused4					[ISODCL (883, 883)];
	unsigned char application_data			[ISODCL (884, 1395)];
	unsigned char unused5					[ISODCL (1396, 2048)];
};

/* high sierra is identical to iso, except that the date is only 6 bytes, and
   there is an extra reserved byte after the flags */

struct iso_directory_record {
	unsigned char length					[ISODCL (1, 1)]; 		/* Length of directory Record */
	unsigned char ext_attr_length			[ISODCL (2, 2)]; 		/* 711 */
	unsigned char extent					[ISODCL (3, 10)]; 		/* This is the Logical Block Number of the first Logical Block allocated to the file. */
	unsigned char size						[ISODCL (11, 18)]; 		/* Length of the file section in bytes */
	unsigned char date						[ISODCL (19, 25)]; 		/* This is recorded in the same format as the Volume Creation Date and Time */
	unsigned char flags						[ISODCL (26, 26)];		/* One Byte, each bit of which is a Flag:
																	Bit
																		0 File is Hidden if this bit is 1*/
#define	ISO9660_DIR_FLAG					0x02					/*	1 Entry is a Directory if this bit is 1															*/
																	/*	2 Entry is an Associated file is this bit is 1
																		3 Information is structured according to the extended attribute record if this bit is 1	
																		4 Owner, group and permissions are specified in the extended attribute record if this bit is 1
																		5 Reserved (0)
																		6 Reserved (0)
																		7 File has more than one directory record if this bit is 1 */
	unsigned char file_unit_size			[ISODCL (27, 27)]; 		/* This field is only valid if the file is recorded in interleave mode. Otherwise this field is (00) */
	unsigned char interleave				[ISODCL (28, 28)]; 		/* This field is only valid if the file is recorded in interleave mode. Otherwise this field is (00) */
	unsigned char volume_sequence_number	[ISODCL (29, 32)]; 		/* The ordinal number of the volume in the Volume Set on which the file described by the directory record is recorded. */
	unsigned char name_len					[ISODCL (33, 33)]; 		/* Length of File Identifier */
	unsigned char name						[1];
} __attribute__((packed));

extern fs_funs_t redboot_iso9660fs_funs;
struct iso_directory_record * iso9660fs_mount(partition_t *part, unsigned int *buf);
#endif  // CYGONCE_REDBOOT_ISO9660FS_H
