//==========================================================================
//
//      usb.h
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================
#ifndef _USB_H_INCLUDED
#define _USB_H_INCLUDED

#define	ENOSR		63	/* Out of streams resources */
#define	ECOMM		70	/* Communication error on send */
#define	EPROTO		71	/* Protocol error */
#define	EOVERFLOW	79	/* Value too large for defined data type */
#define	EILSEQ		88	/* Illegal byte sequence */
#define	EREMOTEIO	140	/* Remote I/O error */

struct usb_ctrlrequest {
	unsigned char bRequestType;
	unsigned char bRequest;
	unsigned short wValue;
	unsigned short wIndex;
	unsigned short wLength;
} __attribute__ ((packed));

/* Everything but the endpoint maximums are aribtrary */
#define USB_MAXCONFIG			8
#define USB_ALTSETTINGALLOC     4
#define USB_MAXALTSETTING		128  /* Hard limit */
#define USB_MAXINTERFACES		32
#define USB_MAXENDPOINTS		32
#define USB_MAXDEV				16

/* All standard descriptors have these 2 fields in common */
struct usb_descriptor_header {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
} __attribute__ ((packed));

/* Device descriptor */
struct usb_device_descriptor {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
	unsigned short bcdUSB;
	unsigned char  bDeviceClass;
	unsigned char  bDeviceSubClass;
	unsigned char  bDeviceProtocol;
	unsigned char  bMaxPacketSize0;
	unsigned short idVendor;
	unsigned short idProduct;
	unsigned short bcdDevice;
	unsigned char  iManufacturer;
	unsigned char  iProduct;
	unsigned char  iSerialNumber;
	unsigned char  bNumConfigurations;
} __attribute__ ((packed));

/* Endpoint descriptor */
struct usb_endpoint_descriptor {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
	unsigned char  bEndpointAddress;
	unsigned char  bmAttributes;
#define USB_ENDPOINT_XFERTYPE_MASK	0x03	/* in bmAttributes */
#define USB_ENDPOINT_XFER_CONTROL	0
#define USB_ENDPOINT_XFER_ISOC		1
#define USB_ENDPOINT_XFER_BULK		2
	unsigned short wMaxPacketSize;
	unsigned char  bInterval;
	unsigned char  bRefresh;
	unsigned char  bSynchAddress;
};

/* Interface descriptor */
struct usb_interface_descriptor {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
	unsigned char  bInterfaceNumber;
	unsigned char  bAlternateSetting;
	unsigned char  bNumEndpoints;
	unsigned char  bInterfaceClass;
	unsigned char  bInterfaceSubClass;
	unsigned char  bInterfaceProtocol;
	unsigned char  iInterface;
};

/* Configuration descriptor information.. */
struct usb_config_descriptor {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
	unsigned short wTotalLength;
	unsigned char  bNumInterfaces;
	unsigned char  bConfigurationValue;
	unsigned char  iConfiguration;
	unsigned char  bmAttributes;
	unsigned char  MaxPower;
};

/* String descriptor */
struct usb_string_descriptor {
	unsigned char  bLength;
	unsigned char  bDescriptorType;
	unsigned short wData[1];
} __attribute__ ((packed));

struct usb_device {
	struct ohci_hc *hc;
	unsigned char	devnum;						/* Address on USB bus */
	unsigned char 	speed;
	unsigned char   toggle[2];					/* one bit for each endpoint ([0] = IN, [1] = OUT) */
	int have_langid;							/* whether string_langid is valid yet */
	int string_langid;							/* language ID for strings */
	unsigned int epmaxpacketin[16];				/* INput endpoint specific maximums */
	unsigned int epmaxpacketout[16];			/* OUTput endpoint specific maximums */
	unsigned int tag;
	unsigned int sector_size;
	unsigned int total_sectors;
	struct usb_device_descriptor descriptor;	/* Descriptor */
	unsigned char storage_interface_no;
	unsigned char mass_storage_endpoint_in;		/* endpoint addr */
	unsigned char mass_storage_endpoint_out;	/* endpoint addr */
	unsigned char lun;
	unsigned char type;
	};

struct urb
{	struct usb_device *dev;
	unsigned int pipe;				/* (in) pipe information */
	int status;						/* (return) non-ISO status */
	unsigned int transfer_flags;	/* (in) URB_SHORT_NOT_OK | ...*/
#define URB_SHORT_NOT_OK	0x0001	/* report short reads as errors */
#define URB_ZERO_PACKET		0x0040	/* Finish bulk OUT with short packet */
	void *transfer_buffer;			/* (in) associated data buffer */
	unsigned int transfer_dma;		/* (in) dma addr for transfer_buffer */
	int transfer_buffer_length;		/* (in) data buffer length */
	int actual_length;				/* (return) actual transfer length */
	struct usb_ctrlrequest *setup_packet;	/* (in) setup packet (control only) */
	unsigned int setup_dma;			/* (in) dma addr for setup_packet */
};

#define PIPE_INTERRUPT			1
#define PIPE_CONTROL			2
#define PIPE_BULK				3
#define usb_maxpacket(dev, endpoint, out)	(out ? (dev)->epmaxpacketout[endpoint] : (dev)->epmaxpacketin [endpoint] )
#define usb_pipeout(pipe)		((((pipe) >> 7) & 1) ^ 1)
#define usb_pipein(pipe)		(((pipe) >> 7) & 1)
#define usb_pipedevice(pipe)	(((pipe) >> 8) & 0x7f)
#define usb_pipe_endpdev(pipe)	(((pipe) >> 8) & 0x7ff)
#define usb_pipeendpoint(pipe)	(((pipe) >> 15) & 0xf)
#define usb_pipedata(pipe)		(((pipe) >> 19) & 1)
#define usb_pipeslow(pipe)		(((pipe) >> 26) & 1)
#define usb_pipetype(pipe)		(((pipe) >> 30) & 3)
#define usb_pipecontrol(pipe)	(usb_pipetype((pipe)) == PIPE_CONTROL)
#define usb_pipebulk(pipe)		(usb_pipetype((pipe)) == PIPE_BULK)

#define usb_gettoggle(dev, is_out)   (dev)->toggle[is_out]
#define	usb_dotoggle(dev, is_out)    (dev)->toggle[is_out]^= 1
#define	usb_settoggle(dev, is_out)   (dev)->toggle[is_out]=  1
#define	usb_cleartoggle(dev, is_out) (dev)->toggle[is_out]=  0 

/* Endpoint halt control/status */
#define usb_endpoint_out(ep_dir)			(((ep_dir >> 7) & 1) ^ 1)

static inline unsigned int to_pipe(struct usb_device *dev, unsigned int endpoint)
{return (dev->devnum << 8) | (endpoint << 15);}
/* Create various pipes... */
#define usb_sndctrlpipe(dev,endpoint)	((PIPE_CONTROL << 30) 	| to_pipe(dev,endpoint))
#define usb_rcvctrlpipe(dev,endpoint)	((PIPE_CONTROL << 30) 	| to_pipe(dev,endpoint) | USB_DIR_IN)
#define usb_sndbulkpipe(dev,endpoint)	((PIPE_BULK << 30) 		| to_pipe(dev,endpoint))
#define usb_rcvbulkpipe(dev,endpoint)	((PIPE_BULK << 30) 		| to_pipe(dev,endpoint) | USB_DIR_IN)
#define usb_snddefctrl(dev)				((PIPE_CONTROL << 30) 	| to_pipe(dev,      0))
#define usb_rcvdefctrl(dev)				((PIPE_CONTROL << 30) 	| to_pipe(dev,      0)  | USB_DIR_IN)

/* Descriptor types */
#define USB_DT_DEVICE				0x01
#define USB_DT_CONFIG				0x02
#define USB_DT_STRING				0x03
#define USB_DT_INTERFACE			0x04
#define USB_DT_ENDPOINT				0x05

/* Descriptor sizes per descriptor type */
#define USB_DT_DEVICE_SIZE			18
#define USB_DT_CONFIG_SIZE			9
#define USB_DT_INTERFACE_SIZE		9
#define USB_DT_ENDPOINT_SIZE		7
#define USB_DT_HUB_NONVAR_SIZE		7
#define USB_DT_HID_SIZE				9

/* CONTROL REQUEST SUPPORT */

/* USB directions
 * This bit flag is used in endpoint descriptors' bEndpointAddress field. It's also one of three fields in control requests bRequestType. */
#define USB_DIR_OUT					0			/* to device */
#define USB_DIR_IN					0x80		/* to host */

/* USB recipients, the third of three bRequestType fields */
#define USB_RECIP_MASK				0x1f
#define USB_RECIP_DEVICE			0x00
#define USB_RECIP_INTERFACE			0x01
#define USB_RECIP_ENDPOINT			0x02
#define USB_RECIP_OTHER				0x03

/* Standard requests, for the bRequest field of a SETUP packet.
 * These are qualified by the bRequestType field, so that for example TYPE_CLASS or TYPE_VENDOR specific feature flags could be retrieved by a GET_STATUS request. */
#define USB_REQ_GET_STATUS			0x00
#define USB_REQ_CLEAR_FEATURE		0x01
#define USB_REQ_SET_FEATURE			0x03
#define USB_REQ_SET_ADDRESS			0x05
#define USB_REQ_GET_DESCRIPTOR		0x06
#define USB_REQ_SET_DESCRIPTOR		0x07
#define USB_REQ_GET_CONFIGURATION	0x08
#define USB_REQ_SET_CONFIGURATION	0x09
#define USB_REQ_GET_INTERFACE		0x0A
#define USB_REQ_SET_INTERFACE		0x0B
#define USB_REQ_SYNCH_FRAME			0x0C

/* Device and/or Interface Class codes as found in bDeviceClass or bInterfaceClass and defined by www.usb.org documents */
#define USB_CLASS_PER_INTERFACE		0	/* for DeviceClass */
#define USB_CLASS_AUDIO				1
#define USB_CLASS_COMM				2
#define USB_CLASS_HID				3
#define USB_CLASS_PHYSICAL			5
#define USB_CLASS_STILL_IMAGE		6
#define USB_CLASS_PRINTER			7
#define USB_CLASS_MASS_STORAGE		8
#define USB_CLASS_HUB				9
#define USB_CLASS_CDC_DATA			0x0a
#define USB_CLASS_CSCID				0x0b	/* chip+ smart card */
#define USB_CLASS_CONTENT_SEC		0x0d	/* content security */
#define USB_CLASS_VIDEO				0x0e
#define USB_CLASS_WIRELESS_CONTROLLER	0xe0
#define USB_CLASS_APP_SPEC			0xfe
#define USB_CLASS_VENDOR_SPEC		0xff

int usb_new_device(struct usb_device *dev, int devnum);
int usb_control_msg(struct usb_device *dev, unsigned int pipe, unsigned char request, unsigned char requesttype, unsigned short value, unsigned short index, void *buf, unsigned short buf_size);
int usb_bulk_msg(struct usb_device *dev, unsigned int pipe, void *data, int len, unsigned int *actual_length);
#endif	/* _USB_H_INCLUDED */
