//==========================================================================
//
//      usb_ohci.h
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================
#ifndef _USB_OHCI_H_INCLUDED
#define _USB_OHCI_H_INCLUDED
#include <fs/usb.h>
#include <errno.h>

#define USB_BUFS_SIZE 		 0x2000U
#define USB_PCI_MEM_MAP_SIZE 0x10000U //CYGMEM_SECTION_pci_window_SIZE
#define USB_MAX_OHCI			4
#define USB_MAX_OHCI_ED			16
#define USB_MAX_OHCI_TD			5

/* BYTE SWAP macros */
#if (CYG_BYTEORDER == CYG_MSBFIRST)
#define UINT16_SWAP(x) (((x<<8)&0xff00)|((x>>8)&0x00ff))
#define UINT32_SWAP(x) (((x<<24)&0xff000000 ) | ((x<<8)&0x00ff0000) | ((x >>8)&0x0000ff00) | ((x>>24)&0x000000ff))
# define cpu_to_le32(x)  UINT32_SWAP(x)
# define le32_to_cpu(x)  UINT32_SWAP(x)
# define cpu_to_le16(x)  UINT16_SWAP(x)
# define le16_to_cpu(x)  UINT16_SWAP(x)
# define cpu_to_le32p(x) UINT32_SWAP(*(x))
# define le32_to_cpup(x) UINT32_SWAP(*(x))
# define cpu_to_le16p(x) UINT16_SWAP(*(x))
# define le16_to_cpup(x) UINT16_SWAP(*(x))
#else
 
/*# define cpu_to_le32(x)  (x)
# define le32_to_cpu(x)  (x)
# define cpu_to_le16(x)  (x)
# define le16_to_cpu(x)  (x)

# define cpu_to_le32p(x) (*(x))
# define le32_to_cpup(x) (*(x))
# define cpu_to_le16p(x) (*(x))
# define le16_to_cpup(x) (*(x))*/
#endif
struct ed {
	/* first fields are hardware-specified */
	unsigned int	hwINFO;      /* endpoint config bitmap */
	/* info bits defined by hcd */
#define ED_DEQUEUE	(1 << 27)
#define ED_SKIP		(1 << 14)
#define ED_LOWSPEED	(1 << 13)
#define ED_OUT		(0x01 << 11)
#define ED_IN		(0x02 << 11)
	unsigned int	hwTailP;	/* tail of TD list 			*/
	unsigned int	hwHeadP;	/* head of TD list (hc r/w) */
#define ED_C		(0x02)		/* toggle carry 			*/
#define ED_H		(0x01)		/* halted 					*/
	unsigned int	hwNextED;	/* next ED in list 			*/

	/* rest are purely for the driver's use 				*/
	unsigned int	ed_dma;		/* addr of ED 				*/
	unsigned int	td_pending;	
	/* create --> IDLE --> OPER --> ... --> IDLE --> destroy usually:  OPER --> UNLINK --> (IDLE | OPER) --> ...	 */
	unsigned int	pipe; 		/* PIPE_{BULK,...} 			*/
	struct usb_device *dev;
} __attribute__ ((aligned(16)));

#define ED_MASK	((unsigned int)~0x0f)		/* strip hw status in low addr bits */

#define OHCI_LAST_TD	0x01
/* OHCI Transfer Descriptor (TD) ... one per transfer segment See OHCI spec, sections 4.3.1 (general = control/bulk/interrupt) and 4.3.2 (iso) */
struct td {
	/* first fields are hardware-specified */
	unsigned int	hwINFO;						/* transfer info bitmask */
	/* hwINFO bits for both general and iso tds: */
#define TD_CC       0xf0000000			/* condition code */
#define TD_CC_GET(td_p) ((td_p >>28) & 0x0f)
//#define TD_CC_SET(td_p, cc) (td_p) = ((td_p) & 0x0fffffff) | (((cc) & 0x0f) << 28)
#define TD_DI       0x00E00000			/* frames before interrupt */
#define TD_DI_SET(X) (((X) & 0x07)<< 21)
	/* these two bits are available for definition/use by HCDs in both  general and iso tds ... others are available for only one type */
#define TD_DONE     0x00020000			/* retired to donelist */
#define TD_ISO      0x00010000			/* copy of ED_ISO 	*/
	/* hwINFO bits for general tds: */
#define TD_EC       0x0C000000			/* error count 		*/
#define TD_T        0x03000000			/* data toggle state*/
#define TD_T_DATA0  0x02000000			/* DATA0 			*/
#define TD_T_DATA1  0x03000000			/* DATA1 			*/
#define TD_T_TOGGLE 0x00000000			/* uses ED_C 		*/
#define TD_DP       0x00180000			/* direction/pid 	*/
#define TD_DP_SETUP 0x00000000			/* SETUP pid 		*/
#define TD_DP_IN    0x00100000			/* IN pid 			*/
#define TD_DP_OUT   0x00080000			/* OUT pid 			*/
							/* 0x00180000 rsvd */
#define TD_R        0x00040000			/* round: short packets OK? */
  	unsigned int  	hwCBP;			/* Current Buffer Pointer (or 0) */
  	unsigned int  	hwNextTD;			/* Next TD Pointer */
  	unsigned int  	hwBE;				/* Memory Buffer End Pointer */
 /* rest are purely for the driver's use */
  	unsigned int  	index;
  	struct ed      	*ed;
	unsigned int   	td_dma;			/* addr of this TD */
	unsigned int   	data_dma;		/* addr of data it points to */
} __attribute__ ((aligned(32)));	/* c/b/i need 16; only iso needs 32 */

#define TD_MASK	((unsigned int)~0x1f)		/* strip hw status in low addr bits */

/* Hardware transfer status codes -- CC from td->hwINFO or td->hwPSW */
#define TD_CC_NOERROR      0x00
#define TD_CC_CRC          0x01
#define TD_CC_BITSTUFFING  0x02
#define TD_CC_DATATOGGLEM  0x03
#define TD_CC_STALL        0x04
#define TD_DEVNOTRESP      0x05
#define TD_PIDCHECKFAIL    0x06
#define TD_UNEXPECTEDPID   0x07
#define TD_DATAOVERRUN     0x08
#define TD_DATAUNDERRUN    0x09
    /* 0x0A, 0x0B reserved for hardware */
#define TD_BUFFEROVERRUN   0x0C
#define TD_BUFFERUNDERRUN  0x0D
    /* 0x0E, 0x0F reserved for HCD */
#define TD_NOTACCESSED     0x0F


/* map OHCI TD status codes (CC) to errno values */ 
static const int cc_to_error [16] = { 
	/* No  Error  */               0,
	/* CRC Error  */               -EILSEQ,
	/* Bit Stuff  */               -EPROTO,
	/* Data Togg  */               -EILSEQ,
	/* Stall      */               -EPIPE,
	/* DevNotResp */               -ETIMEDOUT,
	/* PIDCheck   */               -EPROTO,
	/* UnExpPID   */               -EPROTO,
	/* DataOver   */               -EOVERFLOW,
	/* DataUnder  */               -EREMOTEIO,
	/* (for hw)   */               -EIO,
	/* (for hw)   */               -EIO,
	/* BufferOver */               -ECOMM,
	/* BuffUnder  */               -ENOSR,
	/* (for HCD)  */               -EALREADY,
	/* (for HCD)  */               -EALREADY 
};


/*
 * The HCCA (Host Controller Communications Area) is a 256 byte structure defined section 4.4.1 of the OHCI spec. 
 * The HC is told the base address of it.  It must be 256-byte aligned. */
struct ohci_hcca {
#define NUM_INTS 32
	unsigned int	int_table [NUM_INTS];		/* periodic schedule */
	/*  OHCI defines unsigned short frame_no, followed by unsigned short zero pad. 
	 * Since some processors can't do 16 bit bus accesses, portable access must be a 32 bits wide. */
	unsigned int	frame_no;					/* current frame number */
	unsigned int	done_head;					/* info returned for an interrupt */
	unsigned char	reserved_for_hc [116];
	unsigned char	what [4];					/* spec only identifies 252 bytes :) */
} __attribute__ ((aligned(256)));

/* This is the structure of the OHCI controller's memory mapped I/O region.
 * You must use readl() and writel() (in <asm/io.h>) to access these fields!!
 * Layout is in section 7 (and appendix B) of the spec. */
struct ohci_regs {
	/* control and status registers (section 7.1) */
	unsigned int	revision;
	unsigned int	control;
	unsigned int	cmdstatus;
	unsigned int	intrstatus;
	unsigned int	intrenable;
	unsigned int	intrdisable;

	/* memory pointers (section 7.2) */
	unsigned int	hcca;
	unsigned int	ed_periodcurrent;
	unsigned int	ed_controlhead;
	unsigned int	ed_controlcurrent;
	unsigned int	ed_bulkhead;
	unsigned int	ed_bulkcurrent;
	unsigned int	donehead;

	/* frame counters (section 7.3) */
	unsigned int	fminterval;
	unsigned int	fmremaining;
	unsigned int	fmnumber;
	unsigned int	periodicstart;
	unsigned int	lsthresh;

	/* Root hub ports (section 7.4) */
	struct	ohci_roothub_regs {
		unsigned int	a;
		unsigned int	b;
		unsigned int	status;
#define MAX_ROOT_PORTS	15	/* maximum OHCI root hub ports (RH_A_NDP) */
		unsigned int	portstatus [MAX_ROOT_PORTS];
	} roothub;

	/* and optional "legacy support" registers (appendix B) at 0x0100 */

} __attribute__ ((aligned(32)));


/* OHCI CONTROL AND STATUS REGISTER MASKS */

/*
 * HcControl (control) register masks
 */
#define OHCI_CTRL_CBSR	(3 << 0)	/* control/bulk service ratio */
#define OHCI_CTRL_PLE	(1 << 2)	/* periodic list enable */
#define OHCI_CTRL_IE	(1 << 3)	/* isochronous enable */
#define OHCI_CTRL_CLE	(1 << 4)	/* control list enable */
#define OHCI_CTRL_BLE	(1 << 5)	/* bulk list enable */
#define OHCI_CTRL_HCFS	(3 << 6)	/* host controller functional state */
#define OHCI_CTRL_IR	(1 << 8)	/* interrupt routing */
#define OHCI_CTRL_RWC	(1 << 9)	/* remote wakeup connected */
#define OHCI_CTRL_RWE	(1 << 10)	/* remote wakeup enable */

/* pre-shifted values for HCFS */
#	define OHCI_USB_RESET	(0 << 6)
#	define OHCI_USB_RESUME	(1 << 6)
#	define OHCI_USB_OPER	(2 << 6)
#	define OHCI_USB_SUSPEND	(3 << 6)

/*
 * HcCommandStatus (cmdstatus) register masks
 */
#define OHCI_HCR	(1 << 0)	/* host controller reset */
#define OHCI_CLF  	(1 << 1)	/* control list filled */
#define OHCI_BLF  	(1 << 2)	/* bulk list filled */
#define OHCI_OCR  	(1 << 3)	/* ownership change request */
#define OHCI_SOC  	(3 << 16)	/* scheduling overrun count */

/*
 * masks used with interrupt registers:
 * HcInterruptStatus (intrstatus)
 * HcInterruptEnable (intrenable)
 * HcInterruptDisable (intrdisable)
 */
#define OHCI_INTR_SO	(1 << 0)	/* scheduling overrun */
#define OHCI_INTR_WDH	(1 << 1)	/* writeback of done_head */
#define OHCI_INTR_SF	(1 << 2)	/* start frame */
#define OHCI_INTR_RD	(1 << 3)	/* resume detect */
#define OHCI_INTR_UE	(1 << 4)	/* unrecoverable error */
#define OHCI_INTR_FNO	(1 << 5)	/* frame number overflow */
#define OHCI_INTR_RHSC	(1 << 6)	/* root hub status change */
#define OHCI_INTR_OC	(1 << 30)	/* ownership change */
#define OHCI_INTR_MIE	(1 << 31)	/* master interrupt enable */


/* OHCI ROOT HUB REGISTER MASKS */
 
/* roothub.portstatus [i] bits */
#define RH_PS_CCS            0x00000001   		/* current connect status 		*/
#define RH_PS_PES            0x00000002   		/* port enable status			*/
#define RH_PS_PSS            0x00000004   		/* port suspend status 			*/
#define RH_PS_POCI           0x00000008   		/* port over current indicator 	*/
#define RH_PS_PRS            0x00000010  		/* port reset status 			*/
#define RH_PS_PPS            0x00000100   		/* port power status 			*/
#define RH_PS_LSDA           0x00000200    		/* low speed device attached 	*/
#define RH_PS_CSC            0x00010000 		/* connect status change 		*/
#define RH_PS_PESC           0x00020000   		/* port enable status change 	*/
#define RH_PS_PSSC           0x00040000    		/* port suspend status change 	*/
#define RH_PS_OCIC           0x00080000    		/* over current indicator change*/
#define RH_PS_PRSC           0x00100000   		/* port reset status change 	*/

/* roothub.status bits */
#define RH_HS_LPS	    	 0x00000001			/* local power status */
#define RH_HS_OCI	     	 0x00000002			/* over current indicator */
#define RH_HS_DRWE	    	 0x00008000			/* device remote wakeup enable */
#define RH_HS_LPSC	    	 0x00010000			/* local power status change */
#define RH_HS_OCIC	    	 0x00020000			/* over current indicator change */
#define RH_HS_CRWE	    	 0x80000000			/* clear remote wakeup enable */

/* roothub.b masks */
#define RH_B_DR				 0x0000ffff			/* device removable flags */
#define RH_B_PPCM			 0xffff0000			/* port power control mask */

/* roothub.a masks */
#define	RH_A_NDP			 (0xff << 0)		/* number of downstream ports */
#define	RH_A_PSM			 (1 << 8)			/* power switching mode */
#define	RH_A_NPS			 (1 << 9)			/* no power switching */
#define	RH_A_DT				 (1 << 10)			/* device type (mbz) */
#define	RH_A_OCPM			 (1 << 11)			/* over current protection mode */
#define	RH_A_NOCP			 (1 << 12)			/* no over current protection */
#define	RH_A_POTPGT			 (0xff << 24)		/* power on to power good time */

/* This is the full ohci controller description
 * Note how the "proper" USB information is just a subset of what the full implementation needs. (Linus) */
struct ohci_hc {
	/* I/O memory used to communicate with the HC (dma-consistent) */
	unsigned int index, enabled, devid;
	struct ohci_regs *regs;
	/* main memory used to communicate with the HC (dma-consistent).
	 * hcd adds to schedule for a live hc any time, but removals finish only at the start of the next frame. */
	struct ohci_hcca *hcca;
	struct td		 *td_pool[USB_MAX_OHCI_TD];
	struct ed		 *ed;
	struct urb		 *urb;
	unsigned int	 td_pending;
	/* driver state	 */
	int				 num_ports;
};
int ohci_do_urb (struct urb *urb);
int usb_init_find_ohci( void );
#define ohci_sync(ohci)  ohci_readl(&ohci->regs->control)
#endif

