//==========================================================================
//
//      usb_storage.h
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================
#ifndef _USB_STORAGE_H_INCLUDED
#define _USB_STORAGE_H_INCLUDED

/* command block wrapper */
struct bulk_cb_wrap {
	unsigned int	Signature;		/* contains 'USBC' */
	unsigned int	Tag;			/* unique per command id */
	unsigned int	DataTransferLength;	/* size of data */
	unsigned char	Flags;			/* direction in bit 0 */
	unsigned char	Lun;			/* LUN normally 0 */
	unsigned char	Length;			/* of of the CDB */
	unsigned char	CDB[16];		/* max command */
}__attribute__ ((packed));

#define US_BULK_CB_WRAP_LEN	31
#define US_BULK_CB_SIGN		0x43425355	/*spells out USBC */
#define US_BULK_FLAG_IN		1
#define US_BULK_FLAG_OUT	0

/* command status wrapper */
struct bulk_cs_wrap {
	unsigned int	Signature;		/* should = 'USBS' */
	unsigned int	Tag;			/* same as original command */
	unsigned int	Residue;		/* amount not transferred */
	unsigned char	Status;			/* see below */
	unsigned char	Filler[18];
}__attribute__ ((packed));

#define US_BULK_CS_WRAP_LEN	13
#define US_BULK_CS_SIGN		0x53425355	/* spells out 'USBS' */
#define US_BULK_STAT_OK		0
#define US_BULK_STAT_FAIL	1
#define US_BULK_STAT_PHASE	2

#define USB_STOR_XFER_GOOD		0		/* good transfer                 	*/
#define USB_STOR_XFER_SHORT		1		/* transferred less than expected 	*/
#define USB_STOR_XFER_STALLED	2		/* endpoint stalled              	*/
#define USB_STOR_XFER_LONG		3		/* device tried to send too much 	*/
#define USB_STOR_XFER_ERROR		4		/* transfer died in the middle   	*/

/* Transport return codes */
#define USB_STOR_TRANSPORT_GOOD	   0   /* Transport good, command good	   */
#define USB_STOR_TRANSPORT_FAILED  1   /* Transport good, command failed   */
#define USB_STOR_TRANSPORT_NO_SENSE 2  /* Command failed, no auto-sense    */
#define USB_STOR_TRANSPORT_ERROR   3   /* Transport bad (i.e. device dead) */

/* bulk-only class specific requests */
#define US_BULK_RESET_REQUEST	0xff
#define US_BULK_GET_MAX_LUN		0xfe

struct scsi_cmnd {
	struct usb_device *dev;
	unsigned int  request_bufflen;		/* Actual request size 			*/
	void         *request_buffer;		/* Actual requested buffer 		*/
	unsigned char cmd_len;
	unsigned char data_direction;
#define MAX_COMMAND_SIZE	16
	unsigned char cmd[MAX_COMMAND_SIZE];
};

struct usb_storage_priv {
    struct usb_device *dev;
    unsigned int  flags;
};

int usb_storage_probe(struct usb_device *dev);
#endif
