#include <redboot.h>
#include <errno.h>
#include <fs/usb.h>
#include <fs/usb_ohci.h>
#include <fs/usb_storage.h>
#include <cyg/io/pci.h>
#undef USB_DEBUG
 static struct urb urb_0;
 extern unsigned int *usb_buf_0, *usb_buf_1;
const char *_EEXCHANGE={"- device interface error."};
/*-------------------------------------------------------------------*/
int usb_control_msg(struct usb_device *dev, unsigned int pipe, unsigned char request, unsigned char requesttype, unsigned short value, unsigned short index, void *buf, unsigned short buf_size)
{struct usb_ctrlrequest *dr; 
 int ret;
#ifdef USB_DEBUG
 diag_printf("%s> bRequestType=0x%02x; bRequest=0x%02x; wValue=0x%04x wIndex=0x%04x wLength=0x%04x\n", __FUNCTION__, requesttype, request, value, index, buf_size);
#endif
 dr= (struct usb_ctrlrequest *)usb_buf_0;
 dr->bRequestType= requesttype;
 dr->bRequest=     request;
 dr->wValue=       cpu_to_le16p(&value);
 dr->wIndex=       cpu_to_le16p(&index);
 dr->wLength=      cpu_to_le16p(&buf_size);
 memset(&urb_0, 0 , sizeof(struct urb));
 urb_0.dev=  dev;
 urb_0.pipe= pipe;
 urb_0.setup_packet= dr;
 urb_0.transfer_buffer= buf;
 urb_0.transfer_dma= CYGARC_PCI_DMA_ADDRESS(buf);
 urb_0.transfer_buffer_length= buf_size;
 urb_0.setup_dma= CYGARC_PCI_DMA_ADDRESS(dr);
 urb_0.status = -EINPROGRESS;
 if((ret = ohci_do_urb(&urb_0))==ENOERR)
	{return urb_0.actual_length;}
 diag_printf("%s> %s [%d] errcode= 0x%08x.\n", __FUNCTION__, _EEXCHANGE, __LINE__, urb_0.status);
 return ret;
}
/*=====================================================================================================*/
int usb_bulk_msg(struct usb_device *dev, unsigned int pipe, void *data, int len, unsigned int *actual_length)
{int ret;
 const char *func= {__FUNCTION__};
#ifdef USB_DEBUG
 diag_printf("%s> pipe=0x%02x; data=0x%p; len=0x%04x\n", func, pipe, data, len);
#endif
 memset(&urb_0, 0, sizeof(struct urb));
 urb_0.dev = dev;
 urb_0.pipe = pipe;
 urb_0.transfer_buffer = data;
 urb_0.transfer_dma= CYGARC_PCI_DMA_ADDRESS(data);
 urb_0.transfer_buffer_length = len;
 urb_0.status = -EINPROGRESS;
 if((ret = ohci_do_urb(&urb_0)) == ENOERR)
	{*actual_length= urb_0.actual_length; 
#ifdef USB_DEBUG
	 diag_printf("%s> urb complete status=0x%08x.\n", func, urb_0.status);
#endif
	 if(*actual_length != len)
		{diag_printf("%s> exchange error: 0x%x/0x%x bytes xfer.\n", func, *actual_length, len);
		 return -ECOMM;
		}
	 return ENOERR;
	}
 diag_printf("%s> %s errcode= %d.\n", __FUNCTION__, _EEXCHANGE, urb_0.status);
 return ret;
}
/*=====================================================================================================*/
static int usb_set_address(struct usb_device *dev, int devnum)
{unsigned int pipe;
 pipe= PIPE_CONTROL << 30;
#ifdef USB_DEBUG
 diag_printf("%s> [%d] addr= %d.\n", __FUNCTION__, __LINE__, devnum);
#endif
 return usb_control_msg(dev, pipe, USB_REQ_SET_ADDRESS,	0, devnum, 0, NULL, 0);
}
/*=====================================================================================================*/
static int usb_get_descriptor(struct usb_device *dev, unsigned char type, unsigned char index, void *buf, int size)
{int r/*, i = 5*/;
 unsigned int pipe;
 pipe= usb_rcvctrlpipe(dev, 0);
// for (i=5; i; i--) 
	{memset(buf,0,size);	// Make sure we parse really received data
	 r = usb_control_msg(dev, pipe, USB_REQ_GET_DESCRIPTOR, USB_DIR_IN,	(type << 8) + index, 0, buf, size);
	 if (r > 0 || r == -EPIPE)
		{//		 break;	/* retry if the returned length was 0; flaky device */
		 return r;
		}
	}
 return r;
}
#ifdef USB_DEBUG
#include "usb_debug.c"
#endif
/*=====================================================================================================*/
static int usb_get_device_descriptor(struct usb_device *dev, void *buf, int size)
{int err;
 err = usb_get_descriptor(dev, USB_DT_DEVICE, 0, usb_buf_1, size);
 if (err < 8) 
	{
//#ifdef USB_DEBUG
 	 if (err < 0)
		diag_printf("USB device not responding, giving up (error=%d)", err);
	 else
		diag_printf("USB device descriptor short read (expected %d, got %d)", 8, err);
//#endif
	 return 0;
	}
#ifdef USB_DEBUG
 dump_dev_descriptor(&dev->descriptor);
#endif
 memcpy(&dev->descriptor, buf, sizeof(struct usb_device_descriptor));
 dev->epmaxpacketin [0] = dev->descriptor.bMaxPacketSize0;
 dev->epmaxpacketout[0] = dev->descriptor.bMaxPacketSize0;
 return 1;
}
/*=====================================================================================================*/
int usb_set_configuration(struct usb_device *dev, int configuration)
{return usb_control_msg(dev, usb_sndctrlpipe(dev, 0), USB_REQ_SET_CONFIGURATION, 0, configuration, 0, usb_buf_1, 0);}
/*=====================================================================================================*/
static int usb_get_string(struct usb_device *dev, unsigned short langid, unsigned char index, void *buf, int size)
{int i;
 int result;
 unsigned int pipe;
 pipe= usb_rcvctrlpipe(dev, 0);
 for (i = 0; i < 3; ++i) 
	{/* retry on length 0 or stall; some devices are flakey */
	 result = usb_control_msg(dev, pipe, USB_REQ_GET_DESCRIPTOR, USB_DIR_IN, (USB_DT_STRING << 8) + index, langid, buf, size);
	 if (!(result == 0 || result == -EPIPE))
		break;
	}
 return result;
}
/*=====================================================================================================*/
static int usb_string_sub(struct usb_device *dev, unsigned int langid,unsigned int index, unsigned char *buf)
{int rc;
 /* Try to read the string descriptor by asking for the maximum possible number of bytes */
 rc = usb_get_string(dev, langid, index, buf, 255);
 /* If that failed try to read the descriptor length, then ask for just that many bytes */
 if (rc < 2) 
	{rc = usb_get_string(dev, langid, index, buf, 2);
	 if (rc == 2)
		rc = usb_get_string(dev, langid, index, buf, buf[0]);
	}
 if (rc >= 2) 
	{if (buf[0] < rc)
		rc = buf[0];
	 rc = rc - (rc & 1); /* force a multiple of two */
	}
 if (rc < 2)
	rc = (rc < 0)? rc : -EINVAL;
 return rc;
}
/*=====================================================================================================*/
/*	returns string length (> 0) or error (< 0) */
static int usb_string(struct usb_device *dev, int index, char *buf, size_t size)
{int r;
 unsigned int u, idx;
 unsigned char *str;
 str= (unsigned char *)usb_buf_1;
 if (size <= 0 || !buf || !index)
	return -EINVAL;
 buf[0] = 0;
 /* get langid for strings if it's not yet known */
 if (!dev->have_langid) 
	{if( (r = usb_string_sub(dev, 0, 0, str)) < 0)
		{diag_printf ("str descriptor read error: %d.\n",	r); return r;}
	 if(r < 4)																/* if(r >=0) r == strlen(usb_sting) */
		{diag_printf ("error: short str descriptor.\n"); return -EINVAL;} 
	 dev->have_langid = -1;
	 dev->string_langid = str[2] | (str[3]<< 8);
	/* always use the first langid listed */
#ifdef USB_DEBUG
	 diag_printf ("default language= 0x%04x\n", dev->string_langid);
#endif
	}
 r = usb_string_sub(dev, dev->string_langid, index, str);
 if(r < 0)
	{return r;}
 size--;																	/* leave room for trailing NULL char in output buffer */
 for(idx = 0, u = 2; u < r; u += 2) 
	{if (idx >= size)
		break;
	 if (str[u+1])														/* high byte */
		buf[idx++] = '?';  													/* non ISO-8859-1 character */
	 else
		buf[idx++] = str[u];
	}
 buf[idx] = 0;
 r = idx;
 if(str[1] != USB_DT_STRING)
	diag_printf("wrong descriptor type %02x for str %d (\"%s\")\n", str[1], index, buf);
#ifdef USB_DEBUG
 diag_printf("%s> [%s] r=%d \n", __FUNCTION__, buf, r);
#endif
 return r;
}
/*=====================================================================================================*/
/* By the time we get here, the device has gotten a new device ID and is in the default state. We need to identify the thing and get the ball rolling..
 * Returns 0 for success, != 0 for error. */
int usb_new_device(struct usb_device *dev, int devnum)
{int err, is_mass_storage=0;
 /* USB v1.1 5.5.3 */
 /* We read the first 8 bytes from the device descriptor to get to  the bMaxPacketSize0 field. Then we set the maximum packet size  for the control pipe, and retrieve the rest */
 dev->epmaxpacketin [0] = 0x40;
 dev->epmaxpacketout[0] = 0x40;
 if(!usb_get_device_descriptor(dev, usb_buf_1, 0x40))				/*     */
	{diag_printf("\t%s device descriptor read error.\n", _EEXCHANGE);return -1;}
 CYGACC_CALL_IF_DELAY_US (1000);
 if((err = usb_set_address(dev, devnum)) < 0)						/*      */
 if (err < 0) 
	{diag_printf("\t%s device not accept addr, errcode=%d.\n",_EEXCHANGE, err);
	 return -1;
	}
 dev->devnum= devnum;
 CYGACC_CALL_IF_DELAY_US (100000);
 if(!usb_get_device_descriptor(dev, usb_buf_1, 0x40))				/*     */
	{return -1;}
 {struct usb_config_descriptor *c_d;									/*  */
  struct usb_interface_descriptor *i_d;
  struct usb_endpoint_descriptor e_d;
  struct usb_descriptor_header *h_d;
  int v, i;
  c_d= (struct usb_config_descriptor *)usb_buf_1;
  if ((err= usb_get_descriptor(dev, USB_DT_CONFIG, 0, usb_buf_1, USB_DT_CONFIG_SIZE)) < 0) 
	{diag_printf("\t%s\n", _EEXCHANGE);return -1;}
  if (err < USB_DT_CONFIG_SIZE) 
	{diag_printf("\t%s\n", _EEXCHANGE);return -EINVAL;}
  v=c_d->wTotalLength= le16_to_cpu(c_d->wTotalLength);
#ifdef USB_DEBUG
  dump_conf_descriptor(c_d);
#endif
  if ((err= usb_get_descriptor(dev, USB_DT_CONFIG, 0, usb_buf_1, c_d->wTotalLength)) < 0) 
	{diag_printf("\t%s\n", _EEXCHANGE);return -1;}
  if (err < v) 
		{diag_printf("%s\n", _EEXCHANGE);return -EINVAL;}
  for(i=USB_DT_CONFIG_SIZE; i < v;  i+=h_d->bLength)
	{h_d= (struct usb_descriptor_header *) (((unsigned int)usb_buf_1) + i);
	 switch(h_d->bDescriptorType)
		{case USB_DT_INTERFACE: i_d= (struct usb_interface_descriptor *)h_d;
#ifdef USB_DEBUG
								dump_intf_descriptor((struct usb_interface_descriptor *)h_d); 
#endif
								if(i_d->bInterfaceClass != USB_CLASS_MASS_STORAGE)
									{continue;}
								is_mass_storage=1;
								continue;
		 case USB_DT_ENDPOINT:  if(!is_mass_storage)
									continue;
								memcpy(&e_d, h_d, USB_DT_ENDPOINT_SIZE);
								if((e_d.bmAttributes & USB_ENDPOINT_XFERTYPE_MASK)!= USB_ENDPOINT_XFER_BULK)
									{
#ifdef USB_DEBUG
									 diag_printf( "endp_desc: non bulk function (e_d.bmAttributes=0x%02x) - ignored.\n", e_d.bmAttributes);
#endif
									 continue;
									}
								e_d.wMaxPacketSize= le16_to_cpu(e_d.wMaxPacketSize);
#ifdef USB_DEBUG
								dump_endp_descriptor(&e_d);
#endif
								if(e_d.bEndpointAddress & USB_DIR_IN)	/* in endpoint */
									{dev->mass_storage_endpoint_in= e_d.bEndpointAddress & 0x7f;
									 dev->epmaxpacketin[dev->mass_storage_endpoint_in]= e_d.wMaxPacketSize;
									 continue;
									}
								dev->mass_storage_endpoint_out= e_d.bEndpointAddress;
								dev->epmaxpacketout[dev->mass_storage_endpoint_out]= e_d.wMaxPacketSize;
								continue;
		 default:				diag_printf( "\terror: unsupported bDescriptorType=0x%02x\n", h_d->bDescriptorType);
								continue;
		}
 	}
 }
 /* we set the default configuration here */
 if((err = usb_set_configuration(dev, 1)) < 0)
	{diag_printf("\t%s [%d] errcode %d.\n", _EEXCHANGE, __LINE__, err); return -1;}
 {char s[256];
  if(!dev->descriptor.iManufacturer)dev->descriptor.iManufacturer=1;
  if((err=usb_string(dev, dev->descriptor.iManufacturer, s, 256)) < 0)
	{diag_printf("\t%s [%d] errcode %d.\n", _EEXCHANGE, __LINE__, err);return -1;}
  diag_printf("\t- [%s", s);
  if((err=usb_string(dev, dev->descriptor.iProduct, s, 256)) < 0)
	{diag_printf("\t%s [%d] errcode %d.\n", _EEXCHANGE, __LINE__, err);return -1;}
  diag_printf("/ %s]\n", s);
 if(!(dev->mass_storage_endpoint_in && dev->mass_storage_endpoint_out) || !is_mass_storage)
	{diag_printf("\t- no usb flash disk/cdrom device - ignored.\n"); return ENOERR;}	
 }
 return usb_storage_probe(dev);
}
/*=====================================================================================================*/
/* Start an OHCI controller, set the BUS operational, disable interrupts, connect the virtual root hub */
static void usb_init(void)
{usb_init_find_ohci();
 return;
}

RedBoot_init(usb_init, RedBoot_INIT_LAST);
