//==========================================================================
//
//      usb_debug.c
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================
#ifdef USB_DEBUG
/*=====================================================================================================*/
static void dump_dev_descriptor(struct usb_device_descriptor *descriptor)
{ diag_printf("dev_descriptor:\n");
 diag_printf("\tbLength=           0x%04x\n", descriptor->bLength);
 diag_printf("\tbDescriptorType=   0x%04x\n", descriptor->bDescriptorType);
 diag_printf("\tbcdUSB=            0x%04x\n", descriptor->bcdUSB);
 diag_printf("\tbDeviceClass=      0x%04x\n", descriptor->bDeviceClass);
 diag_printf("\tbDeviceSubClass=   0x%04x\n", descriptor->bDeviceSubClass);
 diag_printf("\tbDeviceProtocol=   0x%04x\n", descriptor->bDeviceProtocol);
 diag_printf("\tbMaxPacketSize0=   0x%04x\n", descriptor->bMaxPacketSize0);
 diag_printf("\tidVendor=          0x%04x\n", descriptor->idVendor);
 diag_printf("\tidProduct=         0x%04x\n", descriptor->idProduct);
 diag_printf("\tbcdDevice=         0x%04x\n", descriptor->bcdDevice);
 diag_printf("\tiManufacturer=     0x%04x\n", descriptor->iManufacturer);
 diag_printf("\tiProduct=          0x%04x\n", descriptor->iProduct);
 diag_printf("\tiSerialNumber=     0x%04x\n", descriptor->iSerialNumber);
 diag_printf("\tbNumConfigurations=0x%04x\n", descriptor->bNumConfigurations);
 return;
}
/*=====================================================================================================*/
static void dump_conf_descriptor(struct usb_config_descriptor *descriptor)
{char *c_name[8]={"bLength=","bDescriptorType=", "wTotalLength=", "bNumInterfaces=", "bConfigurationValue=","iConfiguration=","bmAttributes=", "MaxPower="};
 diag_printf("conf_desc:\n");
 diag_printf("\t%-20s 0x%04x\n", c_name[0], descriptor->bLength);
 diag_printf("\t%-20s 0x%04x\n", c_name[1], descriptor->bDescriptorType);
 diag_printf("\t%-20s 0x%04x\n", c_name[2], descriptor->wTotalLength);
 diag_printf("\t%-20s 0x%04x\n", c_name[3], descriptor->bNumInterfaces);
 diag_printf("\t%-20s 0x%04x\n", c_name[4], descriptor->bConfigurationValue);
 diag_printf("\t%-20s 0x%04x\n", c_name[5], descriptor->iConfiguration);
 diag_printf("\t%-20s 0x%04x\n", c_name[6], descriptor->bmAttributes);
 diag_printf("\t%-20s 0x%04x\n", c_name[7], descriptor->MaxPower);
 return;
}
/*=====================================================================================================*/
static void dump_intf_descriptor(struct usb_interface_descriptor *descriptor)
{char *i_name[USB_DT_INTERFACE_SIZE]={"bLength=","bDescriptorType=", "bInterfaceNumber=", "bAlternateSetting=", "bNumEndpoints=", "bInterfaceClass=", "bInterfaceSubClass=","bInterfaceProtocol=", "iInterface="};
 unsigned char *p;
 int i;
 p= (unsigned char *)descriptor;
 diag_printf("intf_desc:\n");
 for(i=0; i < USB_DT_INTERFACE_SIZE; i++, p++)
 	{diag_printf("\t%-20s 0x%04x\n", i_name[i], *p);}
 return;
}
/*=====================================================================================================*/
static void dump_endp_descriptor(struct usb_endpoint_descriptor *descriptor)
{char *ep_name[8]={"bLength=","bDescriptorType=", "bEndpointAddress=", "bmAttributes=", "wMaxPacketSize=", "bInterval=","bRefresh=","bSynchAddress="};
 diag_printf("endp_desc:\n");
 diag_printf("\t%-20s 0x%04x\n", ep_name[0], descriptor->bLength);
 diag_printf("\t%-20s 0x%04x\n", ep_name[1], descriptor->bDescriptorType);
 diag_printf("\t%-20s 0x%04x\n", ep_name[2], descriptor->bEndpointAddress);
 diag_printf("\t%-20s 0x%04x\n", ep_name[3], descriptor->bmAttributes);
 diag_printf("\t%-20s 0x%04x\n", ep_name[4], descriptor->wMaxPacketSize);
 diag_printf("\t%-20s 0x%04x\n", ep_name[5], descriptor->bInterval);
 diag_printf("\t%-20s 0x%04x\n", ep_name[6], descriptor->bRefresh);
 diag_printf("\t%-20s 0x%04x\n", ep_name[7], descriptor->bSynchAddress);
}
#endif
