//==========================================================================
//
//      usb_storage.c
//
//      Second extended filesystem defines.
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    STC Elins
// Contributors: STC Elins
// Date:         2007-11-29
// Purpose:      
// Description:  
//              
// This code is part of RedBoot (tm).
//
//####DESCRIPTIONEND####
//
//==========================================================================
#include <redboot.h>
#include <errno.h>
#include <fs/disk.h>
#include <fs/ide.h>
#include <fs/usb.h>
#include <fs/usb_ohci.h>
#include <fs/usb_storage.h>
#include <fs/scsi.h>
#undef USB_STORAGE_DEBUG
 extern unsigned int *usb_buf_0, *usb_buf_1, *usb_buf_2; 
static struct usb_storage_priv usb_storage_privs[USB_MAXDEV];
/*=====================================================================================================*/
int usb_stor_bulk_do_xfer(struct scsi_cmnd *scsi_cmd, unsigned int pipe)
{struct bulk_cb_wrap *bcb = (struct bulk_cb_wrap *) usb_buf_0;
 struct bulk_cs_wrap *bcs = (struct bulk_cs_wrap *) usb_buf_2;
 struct usb_device   *dev = scsi_cmd->dev;
 unsigned int transfer_length, max_tacion_len, cswlen, cbwlen, endpoint;
 int is_out, r;

 usb_dotoggle(dev, 1);
 memset(bcb, 0, 256/*sizeof(struct bulk_cb_wrap)*/);
 memset(bcs, 0, sizeof(struct bulk_cs_wrap));
 /* set up the command wrapper */
 bcb->Signature = cpu_to_le32(US_BULK_CB_SIGN);
 bcb->DataTransferLength = cpu_to_le32(scsi_cmd->request_bufflen);
 if (scsi_cmd->request_bufflen)											/* ?????????????????? */
 	bcb->Flags = scsi_cmd->data_direction;
 if(scsi_cmd->cmd[0])													/* ?????????????????? */
 	bcb->Tag = dev->tag;
 bcb->Lun = scsi_cmd->dev->lun;
 bcb->Length = scsi_cmd->cmd_len;
 memcpy(bcb->CDB, scsi_cmd->cmd, scsi_cmd->cmd_len);					/* copy the scsi command */
#ifdef USB_STORAGE_DEBUG
 diag_printf("bulk Command S 0x%x T 0x%x L 0x%x F 0x%x Trg 0x%x LUN 0x%x CL 0x%x bcb=0x%p\n", le32_to_cpu(bcb->Signature), bcb->Tag,
			scsi_cmd->request_bufflen, bcb->Flags, (bcb->Lun >> 4), (bcb->Lun & 0x0F), bcb->Length, bcb->CDB);
#endif
 if((r= usb_bulk_msg(dev, pipe, bcb, US_BULK_CB_WRAP_LEN, &cbwlen))!=ENOERR)
	{return r;}
 /* DATA STAGE */
 /* send/receive data payload, if there is any */
 /* Some USB-IDE converter chips need a 100us delay between the command phase and the data phase.  
  * Some devices need a little more than that, probably because of clock rate inaccuracies. */
 if (scsi_cmd->request_bufflen) 
	{endpoint= dev->mass_storage_endpoint_out;
	 pipe= usb_sndbulkpipe(dev, endpoint);
	 max_tacion_len= usb_maxpacket(dev, endpoint, 1);
	 is_out=1;
	 if(scsi_cmd->data_direction == USB_DIR_IN)
		{endpoint= dev->mass_storage_endpoint_in;
		 pipe= usb_rcvbulkpipe(dev, endpoint);
		 max_tacion_len= usb_maxpacket (dev, endpoint, 0);
		 is_out=0;
		}
	 usb_dotoggle(dev, is_out);
 	 if((r = usb_bulk_msg(dev, pipe, scsi_cmd->request_buffer,scsi_cmd->request_bufflen, &transfer_length))!=ENOERR)
		{if((r = usb_bulk_msg(dev, pipe, scsi_cmd->request_buffer,scsi_cmd->request_bufflen, &transfer_length))!=ENOERR)
			{return r;}
		}
	  if(transfer_length > max_tacion_len)
		{if(!((transfer_length / max_tacion_len) & 0x01))
			{usb_dotoggle(dev, is_out);}
		}
	 /* If the device tried to send back more data than the amount requested, the spec requires us to transfer the CSW anyway.  
      * Since there's no point retrying the the command, we'll return fake sense data indicating Illegal Request, Invalid Field in CDB. */
	}
 /* See flow chart on pg 15 of the Bulk Only Transport spec for an explanation of how this code works. */
 /* get CSW for device status */
// diag_printf("Attempting to get CSW...\n");
 pipe= usb_rcvbulkpipe(dev, dev->mass_storage_endpoint_in);
 /* Some broken devices add unnecessary zero-length packets to the end of their data transfers.  Such packets show up as 0-length CSWs.  
  * If we encounter such a thing, try to read the CSW again. */
 usb_dotoggle(dev, 0);
 if((r = usb_bulk_msg(dev, pipe, bcs, US_BULK_CS_WRAP_LEN, &cswlen))!=ENOERR)
	{return -USB_STOR_TRANSPORT_ERROR;}
 /* check bulk status */
 r= le32_to_cpu(bcs->Residue);
#ifdef USB_STORAGE_DEBUG
 diag_printf("Bulk Status S 0x%x T 0x%x R %u Stat 0x%x\n", le32_to_cpu(bcs->Signature), bcs->Tag, r, bcs->Status);
#endif
 if(r)
 	{diag_printf("Bulk error(Residue=%d)\n", r); return USB_STOR_TRANSPORT_ERROR;}
// if ((bcs->Tag != dev->tag) || (bcs->Status > US_BULK_STAT_PHASE))
//	{diag_printf("Bulk logical error\n"); return USB_STOR_TRANSPORT_ERROR;}
 /* Some broken devices report odd signatures, so we do not check them* for validity against the spec. 
  * We store the first one we see, and check subsequent transfers for validity against this signature. */
 if (bcs->Signature != cpu_to_le32(US_BULK_CS_SIGN)) 
	{diag_printf("Signature mismatch: got 0x%08x, expecting 0x%08x\n",  le32_to_cpu(bcs->Signature), US_BULK_CS_SIGN);
	 return -USB_STOR_TRANSPORT_ERROR;
	}
 /* try to compute the actual residue, based on how much data was really transferred and what the device tells us */
 /* based on the status code, we report good or bad */
 switch (bcs->Status) 
	{case US_BULK_STAT_OK:		return USB_STOR_TRANSPORT_GOOD;		/* command good -- note that data could be short */
	 case US_BULK_STAT_FAIL:	return USB_STOR_TRANSPORT_FAILED;	/* command failed */
	 case US_BULK_STAT_PHASE:	return USB_STOR_TRANSPORT_ERROR;	/* phase error -- note that a transport reset will be invoked by the invoke_transport() function */
	}
 /* we should never get here, but if we do, we're in trouble */
 return USB_STOR_TRANSPORT_ERROR;
}
/*=====================================================================================================*/
int usb_storage_inquiry(struct usb_device *dev)
{unsigned int pipe;
 unsigned char *buf;
 struct scsi_cmnd scsi_cmd;
 int r;
 buf= (unsigned char *)usb_buf_1;
 memset(&scsi_cmd, 0, sizeof(struct scsi_cmnd));
 scsi_cmd.dev=            dev;
 scsi_cmd.request_bufflen=scsi_cmd.cmd[4]=0x24;
 scsi_cmd.request_buffer= usb_buf_1;
 scsi_cmd.cmd_len=        0x06U;
 scsi_cmd.data_direction= USB_DIR_IN;			/* INQUIRY cmd replay from usb_device */
 dev->tag++;
 scsi_cmd.cmd[0]=         INQUIRY; 
 pipe= usb_sndbulkpipe(dev, dev->mass_storage_endpoint_out);
 if((r= usb_stor_bulk_do_xfer(&scsi_cmd, pipe)) != USB_STOR_TRANSPORT_GOOD)
	{return r;}
 r= (*((unsigned char *)usb_buf_1)) & 0x1f;
#ifdef USB_STORAGE_DEBUG
 diag_printf("%s> usb device type= 0x%02x\n", __FUNCTION__, r);
#endif
 switch (r)
	{case 0x00:		/* Direct access block device (e.g., magnetic disk) */
	 case 0x0e:		/* Simplified direct-access device (e.g., magnetic disk) */
					dev->type= DISK_USB_HD;	break;
	 case 0x04:		/* Write-once device (e.g., some optical disks) */
	 case 0x05:		/* cd/dvd rom */
	 case 0x07:		/* Optical memory device (e.g., some optical disks) */
					dev->type= DISK_USB_CDROM;	break;
	 default:		return -1;
	}
 return ENOERR;
}
/*=====================================================================================================*/
static int usb_storage_request_sense(struct usb_device *dev)
{unsigned int pipe, r;
 struct scsi_cmnd scsi_cmd;
 memset(&scsi_cmd, 0, sizeof(struct scsi_cmnd));
 scsi_cmd.dev= dev;
 scsi_cmd.request_bufflen= 18;					 /* Fill in REQUEST SENSE packet command block */
 scsi_cmd.request_buffer= usb_buf_1;
 scsi_cmd.cmd_len=         0x06;
 scsi_cmd.data_direction= USB_DIR_IN;			
 dev->tag++;
 scsi_cmd.cmd[0]= REQUEST_SENSE;
 scsi_cmd.cmd[4] = 18;  // allocation length
 pipe= usb_sndbulkpipe(dev, dev->mass_storage_endpoint_out);
 r=usb_stor_bulk_do_xfer(&scsi_cmd, pipe);
 CYGACC_CALL_IF_DELAY_US(1000000);
 return r;
}
/*=====================================================================================================*/
int usb_storage_test_unit_ready(struct usb_device *dev)
{unsigned int pipe;
 int i, r;
 struct scsi_cmnd scsi_cmd;
 for(i=0; i < 5; i++)
	{memset(&scsi_cmd, 0, sizeof(struct scsi_cmnd));
	 scsi_cmd.dev=            dev;
	 scsi_cmd.request_bufflen=scsi_cmd.cmd[4]=0x00;
	 scsi_cmd.request_buffer= usb_buf_1;
	 scsi_cmd.cmd_len=        0x06U;
	 scsi_cmd.data_direction= USB_DIR_OUT;			
	 dev->tag++;
	 scsi_cmd.cmd[0]=         TEST_UNIT_READY; 
	 pipe= usb_sndbulkpipe(dev, dev->mass_storage_endpoint_out);
	 r= usb_stor_bulk_do_xfer(&scsi_cmd, pipe);
	 if(r== USB_STOR_TRANSPORT_FAILED)
		{usb_storage_request_sense(dev); continue;}
	 if(r != ENOERR)
		{break;}
	 return r;
	}
 diag_printf("%s> error: device not ready [csw_status=0x%02x]\n",  __FUNCTION__, r);
 return r;
}
/*=====================================================================================================*/
int usb_storage_read_capacity(struct usb_device *dev)
{unsigned int pipe, *capacity, r;
 struct scsi_cmnd scsi_cmd;
 capacity= (unsigned int *)usb_buf_1;
 memset(&scsi_cmd, 0, sizeof(struct scsi_cmnd));
 scsi_cmd.dev= dev;
 scsi_cmd.request_bufflen= 0x08;
 scsi_cmd.request_buffer= usb_buf_1;
 scsi_cmd.cmd_len=         0x0a;
 scsi_cmd.data_direction= USB_DIR_IN;			/* INQUIRY cmd replay from usb_device */
 dev->tag++;
 scsi_cmd.cmd[0]=  READ_CAPACITY; 
 pipe= usb_sndbulkpipe(dev, dev->mass_storage_endpoint_out);
 if ((r=usb_stor_bulk_do_xfer(&scsi_cmd, pipe))!=ENOERR)
	{return r;} 
#ifdef USB_STORAGE_DEBUG
 diag_printf("%s> total_sectors= 0x%08x\n",  __FUNCTION__, *capacity);
#endif
 dev->total_sectors= *capacity++;
#ifdef USB_STORAGE_DEBUG
 diag_printf("%s> logical block length= 0x%08x\n",  __FUNCTION__, *capacity);
#endif
 dev->sector_size= *capacity;
 return r;
}
/*=====================================================================================================*/
int usb_storage_read10(struct disk *d, unsigned int start_sector, unsigned int *buf, unsigned char nsectors)
{unsigned int pipe, nbytes, r;
 struct scsi_cmnd scsi_cmd;
 struct usb_storage_priv *p;
 struct usb_device *dev;
 p = (struct usb_storage_priv *)(d->private);
 dev= p->dev;
 if(!dev->sector_size)
	{return 0;}
 if(dev->type == DISK_USB_CDROM)
	{start_sector/=SECTORS_PER_CDROM_SECTOR;
	 nsectors/=SECTORS_PER_CDROM_SECTOR;
	}
 nbytes= dev->sector_size * nsectors;
#ifdef USB_STORAGE_DEBUG
 diag_printf("%s> start_sector=0x%04x; nsectors=0x%x\n", __FUNCTION__, start_sector, nsectors);
#endif
 memset(&scsi_cmd, 0, sizeof(struct scsi_cmnd));
 scsi_cmd.dev= dev;
 scsi_cmd.request_bufflen=nbytes;
 scsi_cmd.request_buffer= usb_buf_1;
 scsi_cmd.cmd_len=        0x0a;
 scsi_cmd.data_direction= USB_DIR_IN;
 dev->tag++;
 scsi_cmd.cmd[0]=  READ_10; 
 scsi_cmd.cmd[2] = (start_sector >> 24) & 0xff;
 scsi_cmd.cmd[3] = (start_sector >> 16) & 0xff;
 scsi_cmd.cmd[4] = (start_sector >>  8) & 0xff;
 scsi_cmd.cmd[5] = (start_sector >>  0) & 0xff;
 scsi_cmd.cmd[7] = (nsectors >> 8) & 0xff;
 scsi_cmd.cmd[8] =  nsectors & 0xff;
 pipe= usb_sndbulkpipe(dev, dev->mass_storage_endpoint_out);
 if ((r=usb_stor_bulk_do_xfer(&scsi_cmd, pipe))!=ENOERR)
	{return 0;} 
 memcpy(buf, usb_buf_1, nbytes);
// usb_dump_data((unsigned char *)usb_buf_1, nbytes);
 return 1;
}
static disk_funs_t ide_funs = { usb_storage_read10 };
/*=====================================================================================================*/
int usb_storage_probe(struct usb_device *dev)
{int r;
 disk_t disk;
 struct usb_storage_priv *priv;
 priv= &usb_storage_privs[dev->devnum];
 usb_settoggle(dev, 1);
 usb_settoggle(dev, 0);
 if((r=usb_storage_inquiry(dev))!= ENOERR)
	{return r;}
 if((r=usb_storage_test_unit_ready(dev))!= ENOERR)
	{return r;}
 if((r=usb_storage_read_capacity(dev))!= ENOERR)
	{return r;}
 priv->dev = dev;
 priv->flags = 0;
 disk.funs = &ide_funs;
 disk.private = priv;
 disk.kind = dev->type;  // until proven otherwise
 if (!disk_register(&disk))
 	{diag_printf("usb disk %d - register error.\n", dev->devnum); return -1;}
 return ENOERR;
}
/*=====================================================================================================*/
