#!/bin/sh -e


remount_root_rw()
{
    mntpt=$1;
    if [ -d $mntpt ]; then
        mkdir -p /tmp/root$mntpt
        mount -n -tunionfs -o dirs=/tmp/root$mntpt=rw:$mntpt=ro /tmp/root$mntpt $mntpt
    fi
}

mount -n -t proc proc /proc
mount -n -t sysfs sysfs /sys
mount -n -t tmpfs tmpfs /tmp
mount -n -t tmpfs tmpfs /mnt
remount_root_rw /var
remount_root_rw /etc

service udevd start ||:
service hotplug start ||:

# create resolv.conf
>/etc/resolv.conf
[ -z "$DOMAINNAME" ] || echo "search $DOMAINNAME" >>/etc/resolv.conf
[ -z "$DNS_SERVER" ] || echo "nameserver $DNS_SERVER" >>/etc/resolv.conf
[ -z "$DNS_SERVER2" ] || echo "nameserver $DNS_SERVER2" >>/etc/resolv.conf
update_chrooted all

sleep 2s
#run additional shell for debug
TERM=linux /bin/bash </dev/tty2 &>/dev/tty2 &
BG_SHELL_PID=$!

UI_TYPE=x11
case "$UI_TYPE" in
    framebuffer)
	UI_PROGRAM=/usr/sbin/install2-framebuffer-qt
	;;
    console)
	UI_PROGRAM=/usr/sbin/install2-console-ndk
	;;
    x11)
	UI_PROGRAM="xinit /usr/sbin/install2-x11-qt -- :9 vt7 -xf86config /tmp/xconfig -logfile /tmp/X11.log"
	x11createconfig -f >/tmp/xconfig ||:
	;;
    *)
	UI_PROGRAM="xinit /usr/sbin/install2-x11-qt -- :9 vt7 -xf86config /tmp/xconfig -logfile /tmp/X11.log"
	x11createconfig -f >/tmp/xconfig ||:
	;;
esac
for i in vesa fbdev;do
    ( eval $UI_PROGRAM 2>&1 || touch /tmp/xinit_error ) | tee /tmp/install2.log
    [ ! -f /tmp/xinit_error ] && break
    for y in `/usr/bin/xconf -d /tmp/xconfig`;do echo "xdriver:$i"|xconf -D "$y" /tmp/xconfig /tmp/xconfig;done
    [ "$1" == "fbdev" ] || rm -f /tmp/xinit_error
done
[ -e /tmp/xinit_error -o ! -e /tmp/install2_success ] && /bin/bash

# kill background shell
[ -n "$BG_SHELL_PID" ] && kill -SIGABRT $BG_SHELL_PID

echo -n "Waiting for unfinished jobs... "
sync
wait
sleep 3
echo done.

[ -f /tmp/install2.log ] && cp /tmp/install2.log /mnt/destination/root/
[ -f /tmp/xconfig ] && cp /tmp/xconfig /mnt/destination/tmp/
#chroot /mnt/destination /usr/sbin/usermod -p "" root || /bin/bash

if [ "$METHOD" == "disk" -o "$METHOD" == "nfs" ]
then
    case "$METHOD" in
	nfs)	
	    DISTRDIR="/mnt/distribution"
	    ;;
	disk)
	    DISTRDIR="/mnt/distribution"
	    ;;
	*)
	    DISTRDIR="/media/distribution"
    esac
    mkdir -p /mnt/destination/$DISTRDIR || /bin/bash
    mount -n -o remount,ro /mnt/destination || /bin/bash
    mount -n --move /image /mnt/destination/$DISTRDIR 2>/dev/null ||:
else
    mount -n -o remount,ro /mnt/destination || /bin/bash
fi

service udevd stop
killall -9 minilogd
umount -n /var || /bin/bash
umount -n /etc || /bin/bash
umount -n /tmp || /bin/bash
umount -n /sys || /bin/bash
umount -n /proc/bus/usb 2>/dev/null ||:
umount -n /proc || /bin/bash

cd /mnt/destination || /bin/bash
pivot_root . ./tmp
exec /sbin/chroot . /bin/sh -c " \
mount --move /tmp/image /var; \
umount -n /tmp/mnt; \
umount -n /tmp; \
losetup -d /dev/loop0; \
umount -n /var; \
exec /sbin/init 7" < dev/console > dev/console 2>&1
