Name: dev86
Version: 0.16.16
Release: alt1

Packager: Dmitry V. Levin <ldv@altlinux.org>

Summary: A real mode 80x86 assembler and linker
License: GPL
Group: Development/Other
Url: http://www.cix.co.uk/~mayday

Source: %name-%version.tar.bz2

Patch1: %name-0.16.16-rh-alt-owl-kinclude.patch
Patch2: %name-0.16.16-alt-optflags.patch
Patch3: %name-0.16.16-overflow.patch

ExclusiveArch: %ix86 x86_64
Provides: bin86
Obsoletes: bin86

%package devel
Summary: Development files for %name
Group: Development/Other
Requires: %name = %version-%release

%description
The %name package provides an assembler and linker for real mode 80x86
instructions. You'll need to have this package installed in order to
build programs that run in real mode, including LILO and the kernel's
bootstrapping code, from their sources.

You should install %name if you intend to build programs that run in real
mode from their source code.

%description devel
The %name package provides an assembler and linker for real mode 80x86
instructions. You'll need to have this package installed in order to
build programs that run in real mode, including LILO and the kernel's
bootstrapping code, from their sources.

The %name-devel package provides C headers need to use bcc, the C
compiler for real mode x86.

You should install %name if you intend to build programs that run in real
mode from their source code.

Note that you don't need %name-devel package in order to build
a kernel.

%prep
%setup -q
%patch1 -p1
%patch2 -p1
%patch3 -p1

find -type f -print0 |
	xargs -r0 %__grep -FZl /usr/lib/liberror.txt -- |
	xargs -r0 %__subst 's,/usr/lib/liberror\.txt,/usr/lib/bcc/liberror.txt,g' --

mkdir -p lib/bcc
ln -s ../../include lib/bcc/include

%build
make GCCFLAG="$RPM_OPT_FLAGS" <<!EOF!
5
quit
!EOF!

for f in `find -mindepth 2 -type f -name README\*`; do
	d="${f%/*}"
	cp -p "$f" "${f##*/}.${d##*/}"
done

%install
%make_install DIST=$RPM_BUILD_ROOT MANDIR=%_mandir install

for f in nm86 size86; do
	ln -sf objdump86 "$RPM_BUILD_ROOT%_bindir/$f"
done

find $RPM_BUILD_ROOT%_prefix/lib/bcc -type d |
	fgrep -v /include |
	sed -e "s|$RPM_BUILD_ROOT|%dir |g" >files.list

find $RPM_BUILD_ROOT%_prefix/lib/bcc \! -type d |
	fgrep -v /include |
	sed -e "s|$RPM_BUILD_ROOT||g" |
	fgrep -v 86/lib | fgrep -v \.a >>files.list

%files -f files.list
%_bindir/*
%_mandir/man?/*
%doc README* MAGIC Contributors bin86

%files devel
%dir %_prefix/lib/bcc
%dir %_prefix/lib/bcc/i386
%_prefix/lib/bcc/i386/lib*.a
%_prefix/lib/bcc/lib*.a
%_prefix/lib/bcc/include

%changelog
* Fri Sep 03 2004 Anton D. Kachalov <mouse@altlinux.org> 0.16.16-alt1
- 0.16.16

* Wed Apr 28 2004 Stanislav Ievlev <inger@altlinux.org> 0.16.3-alt3
- rebuild with glibc2.3

* Fri Nov 15 2002 Stanislav Ievlev <inger@altlinux.ru> 0.16.3-alt2
- rebuild

* Wed Jun 05 2002 Dmitry V. Levin <ldv@altlinux.org> 0.16.3-alt1
- 0.16.3, updated patches.
- Relocated /usr/lib/liberror.txt to /usr/lib/bcc/liberror.txt
- Additional convention enforcement on patch file names.

* Thu Jun 14 2001 Dmitry V. Levin <ldv@altlinux.ru> 0.15.5-alt1
- 0.15.5
- Updated patches (rh).

* Wed Nov 22 2000 Dmitry V. Levin <ldv@fandra.org> 0.15.4-ipl1mdk
- 0.15.4

* Mon Aug 18 2000 Dmitry V. Levin <ldv@fandra.org> 0.15.1-ipl1mdk
- 0.15.1

* Wed Aug 16 2000 Dmitry V. Levin <ldv@fandra.org> 0.15.0-ipl3mdk
- split out -devel package (needed only for elks developers).
- BM.

* Wed Jul 19 2000 Dmitry V. Levin <ldv@fandra.org> 0.15.0-ipl1mdk
- RE and Fandra adaptions.

* Wed Jun 14 2000 Chmouel Boudjnah <chmouel@mandrakesoft.com> 0.15.0-1mdk
- First mandrake version from rh package.
