Name: xorg-x11
Version: 6.8.2
Release: alt2.RC3

%define src_version %version
%define mesa_version 6.2.1
%define _cppcmd  /usr/bin/cpp

%define kmodule_name drm

%define x11cc "gcc"
%define x11cxx "g++"

%define renderver 0.8
%define xrenderver 0.8.4
%define xftver	2.1.3

Summary: Part of the X.Org implementation of the X Window System
License: X/MIT and other
Group: System/X11
Packager: XOrg Maintainer Team <xorg@packages.altlinux.org>

# FIXME
AutoReq: yes, noshell, nofiles
%define _findreq_method noperl
%set_strip_method none
%set_verify_elf_method textrel=relaxed

PreReq: %name-libs = %version-%release, %name-utils = %version-%release 
Requires: %name-xapps = %version-%release, %name-xauth = %version-%release
Requires: %name-xfs = %version-%release, %name-type1-fonts = %version
Requires: %name-drv-v4l, %name-drv-input, %name-drv-glint, %name-drv-savage, %name-drv-tdfx
Requires: %name-drv-ati, %name-drv-nvidia, %name-drv-i128, %name-drv-sis, %name-drv-apm
Requires: %name-drv-chips, %name-drv-cyrix, %name-drv-i8xx
Requires: %name-drv-rendition, %name-drv-s3virge, %name-drv-ark
Requires: %name-drv-cirrus, %name-drv-mga, %name-drv-neomagic
Requires: %name-drv-s3, %name-drv-siliconmotion, %name-drv-tga, %name-drv-trident
Requires: %name-drv-tseng

%ifnarch x86_64
Requires: %name-drv-i740, %name-drv-newport, %name-drv-imstt, %name-drv-via
Requires: %name-drv-nsc, %name-drv-vmware
%endif

Conflicts: xfree86_xkb_xml
Obsoletes: XFree86
Provides: XFree86 = 4.4

BuildRequires: flex fontconfig-devel freetype2-devel gcc-c++ groff-base
BuildRequires: libexpat-devel libncurses-devel libpam-devel libpng-devel
BuildRequires: libstdc++-devel libtinfo-devel libutempter-devel zlib-devel
BuildRequires: kernel-headers-drm-std26-up

Source0: %name-%src_version.tar.bz2

Source3: xserver.pamd
Source4: xdm.pamd
Source5: xfs.init
Source7: xfs.sysconfig
Source8: xdm.init
Source12: startx

Source101: icons-%name.tar.bz2
Source103: x-cursor-theme-Bluecurve-0.73.tar.bz2

# build fix patches
Patch12: %name-6.7.0-broken-includes.patch
Patch13: %name-6.7.0-sharedx11reqs-dllibrary.patch
Patch14: XFree86-4.3.0-missing-libraries.patch
Patch16: %name-alt-move-pc-files.patch

Patch3001: XFree86-4.0.1-nohardware.patch
Patch3002: XFree86-4.1.0-agpgart-load.patch
Patch3004: XFree86-4.0-xdm-servonly.patch

Patch8001: XFree86-4.2.0-pci-hplso.diff
Patch8002: XFree86-4.2.0-primpci-hplso.diff
Patch8003: XFree86-4.2.0-ps2-hplso.diff
Patch9006: XFree86-4.2.99.2-xkb-ar.patch
Patch9013: xorg-Imake-make-icondir-configurable.patch

Patch20002: XFree86-4.2.0-sessreg-highuid.patch
Patch20004: %name-alt-fontfile-defaults.patch

# ALT Linux Team i18n & emacs key patches
Patch30000: %name-alt-iso10646cyr-75dpi-fonts.patch.bz2
Patch30003: XFree86-4.2.0-fontenc.patch
Patch30004: %name-6.8.1.99-alt-i18n-paratype-cp154.patch
Patch39014: %name-6.8.1.901-alt-i18n-paratype-cp154.patch
Patch30005: %name-6.8.1-alt-i18n-cp866.patch

# ALT Linux Team patches
Patch50001: %name-alt-hwbanner.patch
Patch50002: %name-alt-apps-conf.patch
Patch50003: %name-alt-imake.patch
Patch50004: %name-6.8.1-alt-genius-KB19eNB.patch
Patch50005: %name-alt-xdm-chooser.patch
Patch50006: %name-6.8.1.99-alt-r300-i2c-disable.patch
Patch50007: %name-6.8.1-alt-autoconfig-fbdev-disable.patch
Patch50008: %name-6.8.1.99-alt-xorgcfg-font.patch
Patch50009: %name-6.8.0-alt-neomagic.patch
Patch50010: %name-6.8.2-alt-parser_fontlib.patch
Patch50011: %name-6.8.1.99-alt-drm-add-r300.patch

# RedHat patches
Patch90000: XFree86-4.2.99.2-redhat-custom-modelines.patch
Patch90011: XFree86-4.3.0-makefile-fastbuild.patch
Patch90023: XFree86-4.3.0-xbiff-file-heirarchy-standard.patch
Patch90025: XFree86-4.3.0-XRes-IncludeSharedObjectInNormalLib.patch
Patch90028: XFree86-4.3.0-redhat-xcursorgen-do-not-build-included-cursors.patch
Patch90030: xorg-redhat-die-ugly-pattern-die-die-die.patch
Patch90031: xorg-redhat-embeddedbitmap.patch
Patch90033: %name-6.7.0-libxf86config-monitor-freq-fix.patch
Patch90039: %name-6.8.0-Xserver-increase-max-pci-devices.patch


%description
If you want to install the X Window System (TM) on
your machine, you'll need to install X.Org.

The X Window System provides the base technology
for developing graphical user interfaces. Simply stated,
X draws the elements of the GUI on the user's screen and
builds methods for sending user interactions back to the
application. X also supports remote application deployment-running an
application on another computer while viewing the input/output
on your machine.  X is a powerful environment which supports
many different applications, such as games, programming tools,
graphics programs, text editors, etc.  X.Org is the version of
X which runs on Linux, as well as other platforms.

This package contains the basic fonts, programs and documentation
for an X workstation.  However, this package doesn't provide the
program which you will need to drive your video hardware.  To
control your video card, you'll need the particular X server
package which corresponds to your computer's video card.

In addition to installing this package, you will need to install
the X.Org package which corresponds to your video card, the
Xconfigurator package and the xorg-x11-libs package. You may also
need to install one of the X.Org fonts packages.

And finally, if you are going to develop applications that run as
X clients, you will also need to install xorg-x11-devel.

%package distr
Summary: X.Org
Group: System/X11
Requires: %name
Requires: %name-100dpi-fonts, %name-100dpi-fonts-unicode, %name-75dpi-fonts
Requires: %name-75dpi-fonts-unicode, %name-bitmaps, %name-devel, %name-sdk
Requires: %name-devel-static, %name-doc, %name-drv-apm, %name-drv-ark, %name-drv-ati
Requires: %name-drv-chips, %name-drv-cirrus, %name-drv-cyrix, %name-drv-glint
Requires: %name-drv-i128, %name-drv-i8xx
Requires: %name-drv-input, %name-drv-mga, %name-drv-neomagic
Requires: %name-drv-nvidia, %name-drv-rendition, %name-drv-s3
Requires: %name-drv-s3virge, %name-drv-savage, %name-drv-siliconmotion, %name-drv-sis
Requires: %name-drv-tdfx, %name-drv-tga, %name-drv-trident, %name-drv-tseng
Requires: %name-drv-v4l, %name-font-utils
Requires: %name-libs, %name-locales, %name-mesaGL, %name-misc-fonts, %name-rstart
Requires: %name-server, %name-server-common, %name-speedo-fonts, %name-ttf-fonts
Requires: %name-type1-fonts, %name-utils, %name-xapps, %name-xauth, %name-xdm
Requires: %name-Xdmx, %name-xfs, %name-Xnest, %name-Xprt, %name-Xvfb, twm

%ifnarch x86_64
Requires: %name-drv-i740, %name-drv-newport, %name-drv-imstt, %name-drv-via
Requires: %name-drv-nsc, %name-drv-vmware
%endif

%description distr
X.Org

%package server-common
Summary: The X server common files
Group: System/X11
Requires: %name-xauth = %version-%release, %name-misc-fonts = %version
Requires: util-linux, coreutils, xinitrc >= 2.4.4, app-defaults >= 0.2.6

%description server-common
xorg-x11-server-common is common files for X.Org.

%package server
Summary: The X server from release of X.Org
Group: System/X11
Obsoletes: xserver-wrapper, XFree86-server
PreReq: coreutils, xorg-server-control
Requires: %name-server-common = %version-%release
Provides: XFree86-server = 4.4

%description server
xorg-x11-server is the new generation of X server from X.Org.

%package locales
Summary: This package contains set of X.Org locales
Group: System/Internationalization
Obsoletes: XFree86-locales
Provides: XFree86-locales = 4.4

%description locales
This package contains set of X.Org locales.

%package bitmaps
Summary: This package contains set of X.Org bitmaps
Group: System/X11
Obsoletes: XFree86-bitmaps
Provides: XFree86-bitmaps = 4.4

%description bitmaps
This package contains set of X.Org bitmaps.

%package xauth
Summary: X authority file utility
Group: System/X11
Requires: %name-libs = %version-%release
Obsoletes: XFree86-xauth
Provides: XFree86-xauth = 4.4

%description xauth
The xauth program is used to edit and display the authorization information
used in connecting to the X server.

%package xdm
Summary: X Display Manager
Group: System/X11
Requires: %name-libs = %version-%release
Obsoletes: XFree86-xdm
Provides: XFree86-xdm = 4.4

%description xdm
Xdm  manages a collection of X displays, which may be on the local host
or remote servers.  The design of xdm was guided by the needs of X ter-
minals  as well as The Open Group standard XDMCP, the X Display Manager
Control Protocol.  Xdm provides services similar to those  provided  by
init, getty and login on character terminals: prompting for login name
and password, authenticating the user, and running a "session".

%package font-utils
Summary: Font utilities required for installing fonts
Group: System/X11
Requires: %name-libs = %version-%release

%description font-utils
Includes mkfontdir, and other font related utilities which are required when
installing font packages.

%package misc-fonts
Summary: Misc fonts required by the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: %name-base-fonts

%description misc-fonts
This package provides the misc fonts that are required by the X Window System.

%package type1-fonts
Summary: Type1 fonts required by the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: %name-base-fonts

%description type1-fonts
This package provides the type1 fonts that are required by the X Window System.

%package 75dpi-fonts
Summary: A set of 75 dpi resolution fonts for the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: XFree86-75dpi-fonts
Provides: XFree86-75dpi-fonts = 4.4

%description 75dpi-fonts
xorg-x11-75dpi-fonts contains the 75 dpi fonts used
on most X Window Systems. If you're going to use the
X Window System, you should install this package, unless
you have a monitor which can support 100 dpi resolution.
In that case, you may prefer the 100dpi fonts available in
the xorg-x11-100dpi-fonts package.

You may also need to install other X.Org font packages.

To install the X Window System, you will need to install
the xorg-x11 package, the xorg-x11 package corresponding to 
your video card, the Xconfigurator package and the
xorg-x11-libs package.

Finally, if you are going to develop applications that run
as X clients, you will also need to install the
xorg-x11-devel package.

%package 75dpi-fonts-unicode
Summary: A set of 75 dpi resolution unicode fonts for the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: XFree86-75dpi-fonts-unicode
Provides: XFree86-75dpi-fonts-unicode = 4.4

%description 75dpi-fonts-unicode
See 75dpi-fonts

%package 100dpi-fonts-unicode
Summary: A set of 100 dpi resolution unicode fonts for the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: XFree86-100dpi-fonts-unicode
Provides: XFree86-100dpi-fonts-unicode = 4.4

%description 100dpi-fonts-unicode
See 100dpi-fonts

%package 100dpi-fonts
Summary: X Window System 100dpi fonts
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils
Obsoletes: XFree86-100dpi-fonts
Provides: XFree86-100dpi-fonts = 4.4

%description 100dpi-fonts
If you're going to use the X Window System and you have a
high resolution monitor capable of 100 dpi, you should install
xorg-x11-100dpi-fonts. This package contains a set of
100 dpi fonts used on most Linux systems.

If you are installing the X Window System, you will also
need to install the xorg-x11 package, the xorg-x11
package corresponding to your video card, the
Xconfigurator package and the xorg-x11-libs package.
If you need to display certain fonts, you may also need
to install other xorg-x11 fonts packages.

And finally, if you are going to develop applications that
run as X clients, you will also need to install the
xorg-x11-devel package.

%package ttf-fonts
Summary: TrueType fonts provided by the X Window System
Group: System/Fonts/True type
PreReq: chkfontpath, freetype, %name-font-utils
Conflicts: vera-fonts-ttf

%description ttf-fonts
A collection of truetype fonts which are part of the core X Window System
distribution.

%package speedo-fonts
Summary: TrueType fonts provided by the X Window System
Group: System/Fonts/X11 bitmap
PreReq: chkfontpath, %name-font-utils

%description speedo-fonts
A collection of Speedo fonts which are part of the core X Window System
distribution.

%package libs
Summary: Shared libraries needed by the X Window System version 11 release 6
Group: System/Libraries
PreReq: grep
Requires: freetype >= 1.3, %name-locales = %version-%release
Provides: xpm = 3.4k-%release, libXft = 2.1.2-%release, XFree86-libs = 4.4
Obsoletes: xpm, libXft, XFree86-libs

%description libs
This package contains the shared libraries that most X programs
need to run properly. These shared libraries are in a separate package in
order to reduce the disk space needed to run X applications on a machine
without an X server (i.e, over a network).

%package mesaGL
Summary: OpenGL 1.3 compatible 3D graphics library for X Window server
Group: System/Libraries
Requires: %name-libs = %version-%release
Provides: Mesa = %mesa_version-%release, libGLU = %mesa_version-%release
Provides: libGLwrapper = %mesa_version-%release, glx = %mesa_version-%release
Obsoletes: Mesa, libGLwrapper, libGLU, glx

%description mesaGL
Mesa is an OpenGL 1.3 compatible 3D graphics library.

%package utils
Summary: Utilities for the X Window System version 11 release 6
Group: System/X11
Requires: %name-libs = %version-%release, %name-font-utils = %version-%release
Requires: %name-xauth = %version-%release, xterm, cpp
Obsoletes: XFree86-utils
Provides: XFree86-utils = 4.4

%description utils
Some useful utilities for the X Window System version 11 release 6.

Install xorg-x11-utils if you are going to work with X.Org.

%package rstart
Summary: A sample implementation of a Remote Start client for the X Window System
Group: System/X11
Requires: %name-server = %version-%release, %name-font-utils = %version-%release

%description rstart
Rstart  is  a simple implementation of a Remote Start client as defined
in "A Flexible Remote Execution Protocol Based on ssh".  It uses ssh as
its underlying remote execution mechanism.

%package devel
Summary: Include files, development libraries and manual pages for xorg-x11
Group: Development/C
Obsoletes: Mesa-devel, libXft-devel, XFree86-devel, libGLU-devel, xpm-devel
Provides: Mesa-devel = %mesa_version-%release, libXft-devel = 2.1.2-%release, libGLU-devel = %mesa_version-%release
Provides: XFree86-devel = 4.4, xpm-devel = 3.4k-%release
Requires: %name-libs = %version-%release, %name-mesaGL = %version-%release, %name-font-utils = %version-%release
Requires: %name-bitmaps = %version-%release, glibc-devel, cpp

%description devel
This package includes the libraries, header files and documentation
you'll need to develop programs which run in X clients. xorg-x11 includes
the base Xlib library as well as the Xt and Xaw widget sets.

For guidance on programming with these libraries, O'Reilly & Associates
produces a series on X programming which you might find useful.

Install this package if you are going to develop programs which
will run as X clients.

%package sdk
Summary: SDK for X server driver module development
Group: Development/C

%description sdk
The SDK package provides the developmental files which are necessary for
developing X server driver modules, and for compiling driver modules
outside of the standard X11 source code tree.  Developers writing video
drivers, input drivers, or other X modules should install this package.

%package devel-static
Summary: X11R6 development static libraries
Group: System/Libraries
Provides: XFree86-devel-static = 4.4
Obsoletes: XFree86-static-libs, XFree86-devel-static
Requires: xorg-x11-devel = %version-%release

%description devel-static
This package contains X.Org static libraries needed to
build statically linked programs.

%package doc
Summary: Documentation on various X11 programming interfaces
Group: System/X11
Conflicts: %name-libs < %version-%release 
Conflicts: %name-libs > %version-%release
Provides: XFree86-doc = 4.4
Obsoletes: XFree86-doc

%description doc
xorg-x11-doc provides a great deal of extensive PostScript documentation
on the various X APIs, libraries, and other interfaces.  If you need
low level X documentation, you will find it here.  Topics include the
X protocol, the ICCCM window manager standard, ICE session management,
the font server API, etc.

%package Xvfb
Summary: A virtual framebuffer X Windows System server for X.Org
Group: System/X11
Requires: %name-server-common = %version-%release
Provides: XFree86-Xvfb = 4.4
Obsoletes: XFree86-Xvfb

%description Xvfb
Xvfb (X Virtual Frame Buffer) is an X Windows System server
that is capable of running on machines with no display hardware and no
physical input devices.  Xvfb emulates a dumb framebuffer using virtual
memory.  Xvfb doesn't open any devices, but behaves otherwise as an X
display.  Xvfb is normally used for testing servers.  Using Xvfb, the mfb
or cfb code for any depth can be exercised without using real hardware
that supports the desired depths.  Xvfb has also been used to test X
clients against unusual depths and screen configurations, to do batch
processing with Xvfb as a background rendering engine, to do load testing,
to help with porting an X server to a new platform, and to provide an
unobtrusive way of running applications which really don't need an X
server but insist on having one.

If you need to test your X server or your X clients, you may want to
install Xvfb for that purpose.

%package Xnest
Summary: A nested X.Org server
Group: System/X11
Requires: %name-server-common = %version-%release
Provides: XFree86-Xnest = 4.4
Obsoletes: XFree86-Xnest

%description Xnest
Xnest is an X Window System server which runs in an X window.
Xnest is a 'nested' window server, actually a client of the
real X server, which manages windows and graphics requests
for Xnest, while Xnest manages the windows and graphics
requests for its own clients.

You will need to install Xnest if you require an X server which
will run as a client of your real X server (perhaps for
testing purposes).

%package Xprt
Summary: The X print service
Group: System/X11
Requires: %name-server-common = %version-%release

%description Xprt
Xprint is a very flexible, extensible, scaleable,  client/server  print
system  based on ISO 10175 (and some other specs) and the X11 rendering
protocol.  Using Xprint  an  application  can  search,  query  and  use
devices like printers, FAX machines or create documents in formats like
PDF.  In particular, an application can seek a printer, query supported
attributes  (like paper size, trays, fonts etc.), configure the printer
device to match its needs and print on it like on any  other  X  device
reusing parts of the code which is used for the video card Xserver.

%package Xdmx
Summary: Multi-head X server
Group: System/X11
Requires: %name-server = %version-%release

%description Xdmx
Xdmx  is  a proxy X server that uses one or more other X servers as its
display devices.  It provides multi-head X functionality  for  displays
that  might  be  located  on  different  machines.  Xdmx functions as a
front-end X server that acts as a proxy to a set of back-end X servers.
All  of  the  visible  rendering  is  passed to the back-end X servers.
Clients connect to the Xdmx front-end, and  everything  appears  as  it
would  in  a  regular multi-head configuration.  If Xinerama is enabled
(e.g., with +xinerama on the command line), the clients  see  a  single
large screen.
      
Xdmx communicates to the back-end X servers using the standard X11 pro-
tocol, and standard and/or commonly available X server extensions.

%package drv-v4l
Summary: video4linux driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release
Obsoletes: %name-v4l-drv

%description drv-v4l
v4l  is  an  Xorg  driver  for video4linux cards.  It provides a Xvideo
extention port for video overlay.  Just add the driver  to  the  module
list  within  the  module section of your xorg.conf file if you want to
use it.  There are no config options.

%package drv-input
Summary: input drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-input
input drivers for X Window System

%package drv-glint
Summary: GLINT/Permedia video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release
Obsoletes: XFree86-glide-module, %name-glide-module

%description drv-glint
glint  is  an Xorg driver for 3Dlabs & Texas Instruments GLINT/Permedia
based video cards. The driver is rather fully accelerated, and provides
support  for  the  following  framebuffer  depths:  8, 15 (may give bad
results with FBDev support), 16, 24 (32 bpp  recommended,  24  bpp  has
problems), 30, and an 8+24 overlay mode.

%package drv-tdfx
Summary: 3Dfx video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release
Obsoletes: XFree86-glide-module, %name-glide-module

%description drv-tdfx
tdfx is an Xorg driver for 3Dfx video cards.

%package drv-savage
Summary: S3 Savage video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-savage
savage  is  an  Xorg  driver for the S3 Savage family video accelerator
chips.  2D, 3D, and Xv acceleration is supported on  all  chips  except
the  Savage2000  (2D only).  Dualhead operation is supported on MX, IX,
and SuperSavage chips.

%package drv-ati
Summary: ATI video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release
Obsoletes: XFree86-ati-gatos, fglrx_glx <= 3.14.1
Provides: fglrx_glx = 3.14.1

%description drv-ati
ati is an Xorg drivers for ATI video cards.

%package drv-nvidia
Summary: NVIDIA video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-nvidia
nvidia is an Xorg driver for NVIDIA video cards. The driver supports 2D
acceleration and provides support for the following framebuffer depths:
8,  15, 16 (except Riva128) and 24.  All visual types are supported for
depth 8, TrueColor and DirectColor visuals are supported for the  other
depths  with the exception of the Riva128 which only supports TrueColor
in the higher depths.

%package drv-i128
Summary: Number 9 I128 video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-i128
i128  is  an  Xorg driver for Number 9 I128 video cards.  The driver is
accelerated and provides support for all versions of the I128 chip fam-
ily,  including the SGI flatpanel configuration.  Multi-head configura-
tions are supported.

%package drv-sis
Summary: SiS video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-sis
sis  is  an  Xorg  driver for SiS (Silicon Integrated Systems) video
chips. The driver is accelerated, and provides support for  colordepths
of 8, 16 and 24 bpp.  XVideo, Render and other extensions are supported
as well.

%package drv-apm
Summary: Alliance ProMotion video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-apm
apm is an Xorg driver for Alliance ProMotion video cards. The driver is
accelerated  for  supported  hardware/depth  combination.  It  supports
framebuffer  depths of 8, 15, 16, 24 and 32 bits. For 6420, 6422, AT24,
AT3D and AT25, all depths are fully accelerated except 24 bpp for which
only screen to screen copy and rectangle filling is accelerated.

%package drv-chips
Summary: Chips and Technologies video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-chips
chips  is  an  Xorg driver for Chips and Technologies video processors.
The majority of the Chips and Technologies chipsets  are  supported  by
this  driver.  In  general  the  limitation on the capabilities of this
driver are determined by the chipset on which it is run.  Where  possi-
ble,  this driver provides full acceleration and supports the following
depths: 1, 4, 8, 15, 16, 24 and on the latest chipsets an 8+16  overlay
mode.  All  visual  types  are  supported for depth 1, 4 and 8 and both
TrueColor and DirectColor visuals are supported where possible.  Multi-
head configurations are supported on PCI or AGP buses.

%package drv-cyrix
Summary: Cyrix video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-cyrix
cyrix  is  an  Xorg  driver  for  the Cyrix MediaGX (now Natsemi Geode)
series of processors when using the built in video.

%ifnarch x86_64
%package drv-i740
Summary: Intel i740 video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-i740
i740 is an Xorg driver for Intel i740 video cards.
%endif

%package drv-i8xx
Summary: Intel 8xx integrated graphics chipsets drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-i8xx
i810  is  an  Xorg  driver for Intel integrated graphics chipsets.  The
driver supports depths 8, 15, 16 and 24.  All  visual  types  are  sup-
ported  in  depth  8.  For the i810/i815 other depths support the True-
Color and DirectColor visuals.  For the 830M and later, only the  True-
Color  visual  is supported for depths greater than 8.  The driver sup-
ports hardware accelerated 3D via the Direct  Rendering  Infrastructure
(DRI),  but only in depth 16 for the i810/i815 and depths 16 and 24 for
the 830M and later.

i810 supports the i810, i810-DC100, i810e,  i815,  830M,  845G,  852GM,
855GM, 865G and 915G chipsets.

%ifnarch x86_64
%package drv-newport
Summary: Newport video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-newport
newport  is  an  Xorg  driver  for the SGI Indy's and Indigo2's newport
video cards.
%endif

%package drv-rendition
Summary: Rendition video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-rendition
rendition  is  an  Xorg  driver for Rendition/Micron based video cards.
The driver supports following framebuffer depths: 8, 15  (Verite  V1000
only),  16  and  24. Acceleration and multi-head configurations are not
supported yet, but are work in progress.

%package drv-s3virge
Summary: S3 ViRGE video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-s3virge
s3virge  is  an  Xorg  driver  for S3 based video cards.  The driver is
fully accelerated, and provides support for the  following  framebuffer
depths: 8, 15, 16, and 24.  All visual types are supported for depth 8,
and TrueColor visuals are supported for the other depths.  XVideo hard-
ware up scaling is supported in depth 16 and 24 on the DX, GX, GX2, MX,
MX+, and Trio3D/2X.  Doublescan modes are supported and tested in depth
8 and 16 on DX, but disable XVideo.  Doublescan modes on other chipsets
are untested.

%package drv-ark
Summary: ARK Logic video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-ark
ark is an Xorg drivers for ARK Logic video cards.

%ifnarch x86_64
%package drv-imstt
Summary: Integrated Micro Solutions Twin Turbo 128 video driver for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-imstt
imstt  is  an Xorg driver for Integrated Micro Solutions Twin Turbo 128
video chips.
%endif
       
%package drv-cirrus
Summary: Cirrus Logic video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-cirrus
cirrus  is  an Xorg driver for Cirrus Logic video chips.

%package drv-mga
Summary: Matrox video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-mga
mga  is  an  Xorg  driver  for Matrox video cards.  The driver is fully
accelerated, and provides support for the following framebuffer depths:
8,  15,  16,  24,  and an 8+24 overlay mode.  All visual types are sup-
ported for depth 8, and both TrueColor and DirectColor visuals are sup-
ported  for  the  other  depths except 8+24 mode which supports Pseudo-
Color, GrayScale and TrueColor.   Multi-card  configurations  are  sup-
ported.   XVideo  is  supported  on G200 and newer systems, with either
TexturedVideo or video overlay.  The second head of dual-head cards  is
supported  for  the G450 and G550.  Support for the second head on G400
cards requires a binary-only "mga_hal" module that  is  available  from
Matrox  <http://www.matrox.com>, and may be on the CD supplied with the
card.  That module also provides various other enhancements, and may be
necessary  to  use  the  DVI  (digital)  output  on the G550 (and other
cards).

%ifnarch x86_64
%package drv-via
Summary: VIA video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-via
via is an Xorg driver for VIA video chipsets.
%endif

The via driver supports the VIA CLE266 (CLE3122, CLE3022) chipset video
and the VIA KM400/K8M800 VT3204/5/7204/5 video, including 2D  accelera-
tion  and  the Xv video overlay extensions. Flat panel, TV and VGA out-
puts are supported.

%package drv-neomagic
Summary: Neomagic video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release
Obsoletes: %name-neomagic-drv

%description drv-neomagic
neomagic  is an Xorg driver for the Neomagic graphics chipsets found in
many laptop computers.

%ifnarch x86_64
%package drv-nsc
Summary: Nsc video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-nsc
nsc  is an Xorg driver for National Semiconductors GEODE processor fam-
ily.  It uses the DURANGO kit provided by National Semiconductor.   The
driver  is  accelerated,  and provides support for the following frame-
buffer depths: 8, 16 and 24.
%endif

%package drv-s3
Summary: S3 video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-s3
s3 is an Xorg driver for S3 video chipsets.

%package drv-siliconmotion
Summary: Silicon Motion video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-siliconmotion
siliconmotion  is  an Xorg driver for Silicon Motion based video cards.
The driver is fully accelerated, and provides support for the following
framebuffer  depths: 8, 16, and 24.  All visual types are supported for
depth 8, and TrueColor visuals are supported for the other depths.

%package drv-tga
Summary: DEC TGA video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-tga
tga is an Xorg driver for DEC TGA video chipsets.

%package drv-trident
Summary: Trident video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-trident
trident  is  an  Xorg  driver  for  Trident video cards.  The driver is
accelerated, and provides support for the following framebuffer depths:
1,  4, 8, 15, 16, and 24. Multi-head configurations are supported.  The
XvImage extension is supported on TGUI96xx and greater cards.

%package drv-tseng
Summary: Tseng Labs video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-tseng
tseng  is  an  Xorg  driver  for Tseng Labs video cards.

%ifnarch x86_64
%package drv-vmware
Summary: VMware SVGA video drivers for X Window System
Group: System/X11
PreReq: %name-server = %version-%release

%description drv-vmware
vmware is an Xorg driver for VMware virtual video cards.
%endif

%package xfs
Group: System/Servers
Summary: Font server for X.Org
PreReq: shadow-utils
Requires(post): %post_service
Requires(preun): %preun_service
Requires: %name-libs = %version-%release
Requires: %name-server-common = %version-%release
Obsoletes: xtt, XFree86-xfs
Provides: XFree86-xfs = 4.4

%description xfs
This is a font server for X.Org.  You can serve fonts to other X servers
remotely with this package, and the remote system will be able to use all
fonts installed on the font server, even if they are not installed on the
remote computer.

%package xapps
Group: System/X11
Summary: Graphical application for Xorg
Requires: %name-utils = %version-%release

%description xapps
Graphical application for Xorg.

%package -n twm
Group: System/X11
Summary: Tab Window Manager for the X Window System
Requires: %name-server = %version

%description -n twm
Twm is a window manager for the X Window System. It provides titlebars,
shaped windows, several forms of icon management, user-defined macro
functions, click-to-type and pointer-driven keyboard focus, and
user-specified key and pointer button bindings.

%package -n kernel-source-%kmodule_name-%src_version
Summary: Linux %kmodule_name modules sources
License: GPL
Group: Development/Kernel

%description -n kernel-source-%kmodule_name-%src_version
%kmodule_name modules sources for Linux kernel

%package -n kernel-doc-%kmodule_name-%src_version
Summary: Linux %kmodule_name modules documentation
Group: Development/Kernel

%description -n kernel-doc-%kmodule_name-%src_version
%kmodule_name modules documentation for Linux kernel


%prep
%setup -q -c

find -type d -name CVS | xargs rm -fr

%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch16 -p0

%patch3002 -p1
%patch3004 -p1

%patch9013 -p0

%patch20002 -p0
%patch20004 -p0

# ALT patches
%patch30000 -p0
%patch30003 -p1
# 6.8.1.99
#%patch30004 -p0
# 6.8.1.902
%patch39014 -p0
#
%patch30005 -p0
%patch50001 -p0
%patch50002 -p0
%patch50003 -p0
%patch50004 -p0
%patch50005 -p0
# 6.8.1.99
#%patch50006 -p0
#
%patch50007 -p0
%patch50008 -p0
%patch50009 -p0
%patch50010 -p0
# 6.8.1.99
#%patch50011 -p0
#

# Red Hat patches
%patch90000 -p0
%patch90011 -p0
%patch90023 -p0
%patch90025 -p0
%patch90028 -p0
%patch90030 -p0
%patch90031 -p0
%patch90033 -p0
%patch90039 -p0

pushd xc/extras
	%__cp -r drm kernel-source-%kmodule_name-%src_version
	%__tar -cjf %_builddir/kernel-source-%kmodule_name-%src_version.tar.bz2 kernel-source-%kmodule_name-%src_version
popd

cat > xc/config/cf/host.def << EOF
#define XFree86CustomVersion	"ALT Linux build: %{version}-%{release}"
/* Experimental custom messages */
#define XFree86RedHatCustom	YES

#define BuilderString		"Build Host: %(hostname)\n"

#define BootstrapCFlags		$RPM_OPT_FLAGS -pipe

#define DefaultGcc2i386Opt	$RPM_OPT_FLAGS -fno-strength-reduce GccAliasingArgs -pipe
#define DefaultGcc2x86_64Opt	$RPM_OPT_FLAGS -fno-strength-reduce GccAliasingArgs -pipe
#define DefaultGcc2AxpOpt	$RPM_OPT_FLAGS -Wa,-m21164a GccAliasingArgs -pipe
#define DefaultGcc2PpcOpt	$RPM_OPT_FLAGS GccAliasingArgs -pipe

#define LinkGLToUsrInclude	NO
#define LinkGLToUsrLib		NO

#define BuildGLwLibrary		YES
#define ForceNormalLib		YES

/* Disable joystick support because it is totally broken in XFree86 4.x, at
 * least up to and including 4.1.0.  Use native OS joystick support instead.
 */
#define JoystickSupport		NO

#define UseDeprecatedKeyboardDriver	YES

#define HasAgpGart		YES

#define HasDevRandom		YES
#define HasPam			YES
#define HasPamMisc		YES
#define HasZlib			YES

/* This is YES in xfree86.cf for all architectures but x86, and we need it
 * on x86 or else KDE/GNOME shared libs and others that link to them will
 * not be too happy.
 * Update: This is needed on x86_64 also as the xfree86.cf file settings get
 * ignored.  I've assumed they all get ignored and made it all-arch instead.
 */
#define StaticNeedsPicForShared	YES
#define LargePICTable		YES

#define HasLinuxInput		YES

#define BuildXterm		NO

#define XpRasterDDX		YES
#define BuildGISWxprintglue	NO
#define BuildGISWxprint		NO

#define HasGlide3		YES
#define Glide3LibName		glide3
#define Glide3IncDir		%{_includedir}/glide3

#define HasSharedLibraries	YES
#define SharedLibXxf86dga	YES
#define SharedLibXv		YES
#define SharedOldX		YES
#define SharedLibFont		YES
#define SharedLibFontEnc	YES
#define SharedLibXxf86vm	YES
#define SharedLibXxf86rush	YES
#define SharedLibXxf86misc	YES
#define SharedLibXvMC		YES
#define SharedLibXss		YES
#define SharedLibXinerama	YES
#define SharedLibXfontcache	YES
#define SharedLibXdmcp		YES
#define SharedLibXau		YES
#define SharedLibXRes		YES
#define SharedLibFS		YES
#define SharedLibGLw		YES
#define SharedLibDmx		YES

#define SharedXfontReqs		stubs/libfntstubs.a -L%_libdir -lfreetype -lm
#define SharedXevieReqs		-L../../exports/lib -lXext -lX11
#define SharedXfixesReqs	-L../../exports/lib -lX11
#define SharedXcompositeReqs	-L../../exports/lib -lX11
#define SharedXdamageReqs	-L../../exports/lib -lX11
/* #define SharedxkbuiReqs		-L%_libdir -lm */

/* Expat is only needed by fontconfig */
#define HasExpat		YES

#define UseFontconfig		YES
#define HasFontconfig		YES
#define UseFreetype2		YES
#define HasFreetype2		YES
#define FSUseSyslog		YES

#define BuildFonts		YES
#define BuildFontCache		YES
#define BuildSpeedo		YES
#define BuildType1		YES
#define BuildCID		YES
#define BuildFreeType		YES

#define BuildCIDFonts		NO
#define BuildType1Fonts		YES
#define BuildSpeedoFonts	YES
#define BuildCyrillicFonts	YES
#define BuildCP154Fonts		YES
#define BuildBethMarduthoFonts	YES
#define BuildISO8859_1Fonts	YES
#define BuildISO8859_2Fonts	YES
#define BuildISO8859_3Fonts	NO
#define BuildISO8859_4Fonts	NO
#define BuildISO8859_5Fonts	BuildCyrillicFonts
#define BuildISO8859_6Fonts	NO
#define BuildISO8859_7Fonts	YES
#define BuildISO8859_8Fonts	YES
#define BuildISO8859_9Fonts	YES
#define BuildISO8859_10Fonts	NO
#define BuildISO8859_11Fonts	NO
#define BuildISO8859_12Fonts	NO
#define BuildISO8859_13Fonts	NO
#define BuildISO8859_14Fonts	YES
#define BuildISO8859_15Fonts	YES
#define BuildISO8859_16Fonts	NO

#define BuildXF86MiscExt	YES
#define BuildHtmlManPages	NO
#define BuildScanpci		NO
#define BuildIPv6		NO
#define BuildDmx		YES
#define BuildPlugin		NO
#define BuildComposite		YES

#define UseXserverWrapper	YES
#define UseUtempter		YES
#define UseInternalMalloc	NO
#define UseMatroxHal		NO

#define BuildXF86DRI		YES
#define BuildDevelDRIDrivers	YES
#define BuildXvExt		YES

#define BuildDPMS		YES

#define UseConfDirForXkb		NO
#define UseConfDirForAppDefaults	NO

#define InstallXdmConfig	NO
#define InstallFSConfig		NO

#undef  DefaultUserPath
#define DefaultUserPath		/usr/local/bin:/bin:/usr/bin
#undef  DefaultSystemPath
#define DefaultSystemPath	/usr/local/sbin:/sbin:/usr/sbin:/bin:/usr/bin

#define DefaultCursorTheme	Bluecurve

#define AdmDir			/var/log
#define LbxproxyDir		/etc/X11/lbxproxy
#define ProxyManagerDir		/etc/X11/proxymngr
#define ServerConfigDir		/etc/X11/xserver
#define XdmDir			/etc/X11/xdm
#define XConfigDir		/etc/X11
#define XinitDir		/etc/X11/xinit
#define EtcX11Directory		/etc/X11
#define XAppLoadDir		/etc/X11/app-defaults
#define XPrintDir		/etc/X11/xprint

#define XFree86Devel		YES

#define XOrgNameString		ALTLinux X.Org Maintainer Team
#define XOrgWebSupportAddress	https://bugzilla.altlinux.org
#define BuilderEMailAddr	"xorg@packages.altlinux.org"

#define DriverManDir		\$(MANSOURCEPATH)4
#define DriverManSuffix		4x /* use just one tab or cpp will die */
#define MiscManDir		\$(MANSOURCEPATH)7
#define MiscManSuffix		7x /* use just one tab or cpp will die */

EOF


%build
%remove_optflags %optflags_notraceback

%make_build World -C xc \
	FAST=1 \
	DEFAULTFONTPATH="%_x11fontsdir/misc:unscaled" \
	MAKE="make"

# rezip these - they are in the old compress format
find xc/doc/hardcopy -name \*.PS.Z | xargs %__gzip -df
find xc/doc/hardcopy -name \*.PS | xargs %__gzip -f

find xc/doc/hardcopy -name \*.ps | xargs %__rm -f
%__rm -f xc/doc/hardcopy/XKB/*.PS.gz

%__cp xc/RELNOTES xc/doc/hardcopy/RELNOTES.txt
%__rm -rf xc/doc/hardcopy/BDF/*
groff -Tascii -ms xc/doc/specs/BDF/bdf.ms > xc/doc/hardcopy/BDF/bdf.txt
groff -Tascii -ms xc/doc/specs/CTEXT/ctext.tbl.ms > xc/doc/hardcopy/CTEXT/ctext.tbl.txt
%__rm -rf xc/doc/hardcopy/FSProtocol/*
groff -Tascii -ms xc/doc/specs/FSProtocol/protocol.ms > xc/doc/hardcopy/FSProtocol/protocol.txt
%__rm -rf xc/doc/hardcopy/ICCCM/*
groff -Tascii -ms xc/doc/specs/ICCCM/icccm.ms > xc/doc/hardcopy/ICCCM/icccm.txt
%__rm -rf xc/doc/hardcopy/ICE/*
groff -Tascii -ms xc/doc/specs/ICE/ICElib.ms > xc/doc/hardcopy/ICE/ICElib.txt
groff -Tascii -ms xc/doc/specs/ICE/ice.ms > xc/doc/hardcopy/ICE/ice.txt
%__cp xc/doc/specs/PM/PM_spec xc/doc/hardcopy/ICE
%__rm -rf xc/doc/hardcopy/SM/*
groff -Tascii -ms xc/doc/specs/SM/SMlib.ms > xc/doc/hardcopy/SM/SMlib.txt
%__rm -rf xc/doc/hardcopy/XDMCP/*
groff -Tascii -ms xc/doc/specs/XDMCP/xdmcp.ms > xc/doc/hardcopy/XDMCP/xdmcp.txt
%__rm -rf xc/doc/hardcopy/XIM/*
groff -Tascii -ms xc/doc/specs/XIM/xim.ms > xc/doc/hardcopy/XIM/xim.txt
%__rm -rf xc/doc/hardcopy/XLFD/*
groff -Tascii -ms xc/doc/specs/XLFD/xlfd.tbl.ms > xc/doc/hardcopy/XLFD/xlfd.tbl.txt

%install
%__mkdir_p %buildroot%_sysconfdir/pam.d
%__install -m 644 %SOURCE3 %buildroot%_sysconfdir/pam.d/xserver
%__install -m 644 %SOURCE4 %buildroot%_sysconfdir/pam.d/xdm
%__mkdir_p %buildroot%_sysconfdir/security/console.apps
touch %buildroot%_sysconfdir/security/console.apps/xserver

%make DESTDIR=%buildroot install install.man install.sdk -C xc
%__mkdir_p %buildroot%_sysconfdir/X11

find xc/doc/hardcopy -name \*akefile | xargs %__rm -f

# we don't want the libz.a from X.Org -- it's broken
%__rm -f %buildroot%_x11libdir/libz.a

# setup the default X server
%__rm -f %buildroot%_x11bindir/X
chmod 700 %buildroot%_x11bindir/Xorg
%__ln_s Xorg %buildroot%_x11bindir/X

# explicitly create X authdir
%__mkdir_p %buildroot%_sysconfdir/X11/xdm/authdir
chmod 0700 %buildroot%_sysconfdir/X11/xdm/authdir

# we install our own config file for the xfs package
%__mkdir_p %buildroot%_sysconfdir/X11/fs
%__install -pD -m755 %SOURCE5 %buildroot%_sysconfdir/rc.d/init.d/xfs
%__install -pD -m600 %SOURCE7 %buildroot%_sysconfdir/sysconfig/xfs

# we get xinit from a separate package
%__rm -rf %buildroot%_x11datadir/X11/xinit
%__ln_s -f ../../../../etc/X11/xinit %buildroot%_x11datadir/X11/xinit

# this gets the wrong permissions by default -- I don't know or care why
chmod 755 %buildroot%_x11datadir/X11/xkb/geometry/sgi

# this certainly doesn't need to be setuid
chmod 755 %buildroot%_x11bindir/dga

# Move unicode fonts to another directory
for f in 75dpi 100dpi; do
    %__mkdir_p %buildroot/%_x11fontsdir/$f-unicode
    for i in `cat %buildroot/%_x11fontsdir/$f/fonts.dir|grep iso10646|awk '{print $1}'`; do
        %__mv %buildroot/%_x11fontsdir/$f/$i %buildroot/%_x11fontsdir/$f-unicode
    done
    LD_LIBRARY_PATH=%buildroot/%_x11libdir %buildroot/%_x11bindir/mkfontscale -b -s -l %buildroot/%_x11fontsdir/$f
    LD_LIBRARY_PATH=%buildroot/%_x11libdir %buildroot/%_x11bindir/mkfontscale -b -s -l %buildroot/%_x11fontsdir/$f-unicode
done

LD_LIBRARY_PATH=%buildroot/%_x11libdir %buildroot/%_x11bindir/mkfontscale %buildroot/%_x11fontsdir/TTF

# fix removed fonts.cache-1 files
for f in misc Type1 Speedo 75dpi 75dpi-unicode 100dpi 100dpi-unicode TTF; do
	touch %buildroot/%_x11fontsdir/$f/fonts.cache-1
done

# Fix conflicting files with  xterm
[ ! -f %buildroot%_sysconfdir/X11/app-defaults/XTerm ] || \
    %__rm -f %buildroot%_sysconfdir/X11/app-defaults/*XTerm*

# Menu support
%__mkdir_p %buildroot%_menudir %buildroot%_sysconfdir/menu-methods

#alt menu icons
%__install -d %buildroot%_iconsdir
%__tar -xjvf %SOURCE101 -C %buildroot%_iconsdir
%__tar -xjvf %SOURCE103 -C %buildroot%_iconsdir

cat > %buildroot%_menudir/%name-xapps << EOF
?package(%name-xapps): needs=x11 section=Applications/Sciences/Mathematics icon=xcalc.xpm longtitle="Calculator for X" title=XCalc command=xcalc
?package(%name-xapps): needs=x11 section=Applications/Editors icon=xedit.xpm longtitle="Simple text editor for X" title=Xedit command=xedit
?package(%name-xapps): needs=x11 section=Applications/Accessibility icon=xmag.xpm longtitle="Xmag: magnify parts of the X screen" title=Xmag command=xmag
?package(%name-xapps): needs=x11 section=Applications/Monitoring icon=xkill.xpm longtitle="Xkill: kill X clients" title=Xkill command=xkill
?package(%name-xapps): needs=x11 section=Applications/Monitoring icon=xrefresh.xpm longtitle="Xrefresh: redraw X screen" title=Xrefresh command=xrefresh
EOF

cat > %buildroot%_menudir/twm << EOF
?package(twm): needs=wm section=Session/Windowmanagers icon=twm.xpm longtitle="Twm: Tab Window Manager" title=Twm command=twm
EOF

# no need to be SUID
chmod 755 %buildroot%_x11bindir/xload

%__mkdir_p %buildroot%_sysconfdir/logrotate.d
cat << EOF > %buildroot%_sysconfdir/logrotate.d/xdm
/var/log/xdm-error.log {
    notifempty
    missingok
    nocompress
}
EOF

# ld.so.conf.d support
#%__mkdir_p %buildroot%_sysconfdir/ld.so.conf.d
#echo "%_x11libdir" > %buildroot%_sysconfdir/ld.so.conf.d/X11R6.conf

#stripping... strip the crap that's safe to strip
(
    set +x
    strip --strip-unneeded -R .comment %buildroot%_x11bindir/* || :
    strip -R .comment %buildroot%_x11libdir/*so* || :
)

# for compatibility with the Linux/OpenGL standard base
%__mkdir_p %buildroot%_includedir
%__ln_s -f ../X11R6/include/GL  %buildroot%_includedir
%__ln_s -f ../X11R6/include/X11  %buildroot%_includedir

# Fix startx script
%__install -p -m0755 %SOURCE12 %buildroot/%_x11bindir/startx

# quick fix
%__mkdir_p %buildroot/var/lib/xdm
cd %buildroot/etc/X11/xdm
%__rm -f authdir
%__ln_s -f ../../../var/lib/xdm authdir

# documentation relocation /%_x11datadir/X11/doc
%__mkdir_p %buildroot/%_docdir
%__mv %buildroot/%_x11datadir/X11/doc %buildroot/%_docdir/%name-server-%version
%__ln_s  %_docdir/%name-server-%version %buildroot/%_x11datadir/X11/doc
%__mkdir %buildroot/%_docdir/%name-xfs-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.fonts %buildroot/%_docdir/%name-xfs-%version/
%__mkdir %buildroot/%_docdir/%name-drv-input-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.rapidaccess %buildroot/%_docdir/%name-drv-input-%version/
%__mkdir %buildroot/%_docdir/%name-drv-tga-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.DECtga %buildroot/%_docdir/%name-drv-tga-%version/
%__mkdir %buildroot/%_docdir/%name-drv-ati-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.{ati,r128} %buildroot/%_docdir/%name-drv-ati-%version/
%__mkdir %buildroot/%_docdir/%name-drv-i128-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.I128 %buildroot/%_docdir/%name-drv-i128-%version/
%__mkdir %buildroot/%_docdir/%name-drv-sis-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.SiS %buildroot/%_docdir/%name-drv-sis-%version/
%__mkdir %buildroot/%_docdir/%name-drv-apm-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.apm %buildroot/%_docdir/%name-drv-apm-%version/
%__mkdir %buildroot/%_docdir/%name-drv-chips-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.chips %buildroot/%_docdir/%name-drv-chips-%version/
%__mkdir %buildroot/%_docdir/%name-drv-cyrix-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.cyrix %buildroot/%_docdir/%name-drv-cyrix-%version/
%__mkdir %buildroot/%_docdir/%name-drv-i740-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.i740 %buildroot/%_docdir/%name-drv-i740-%version/
%__mkdir %buildroot/%_docdir/%name-drv-i8xx-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.i810 %buildroot/%_docdir/%name-drv-i8xx-%version/
%__mkdir %buildroot/%_docdir/%name-drv-newport-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.newport %buildroot/%_docdir/%name-drv-newport-%version/
%__mkdir %buildroot/%_docdir/%name-drv-rendition-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.rendition %buildroot/%_docdir/%name-drv-rendition-%version/
%__mkdir %buildroot/%_docdir/%name-drv-s3virge-%version
%__mv %buildroot/%_docdir/%name-server-%version/README.s3virge %buildroot/%_docdir/%name-drv-s3virge-%version/
%__rm -fr %buildroot%_docdir/%name-server-%version/html
%__rm -fr %buildroot%_docdir/%name-server-%version/PDF
%__rm -fr %buildroot%_docdir/%name-server-%version/PostScript
%__rm -f %buildroot%_docdir/%name-server-%version/Xprint_FAQ.txt
%__rm -f %buildroot%_docdir/%name-server-%version/B*
%__rm -f %buildroot%_docdir/%name-server-%version/Install
%__rm -f %buildroot%_docdir/%name-server-%version/Versions
%__rm -f %buildroot%_docdir/%name-server-%version/OS2*
%__rm -f %buildroot%_docdir/%name-server-%version/README.{Darwin,LynxOS,NetBSD,OpenBSD,SCO,Solaris}
%__rm -f %buildroot/%_docdir/%name-server-%version/VideoBoard98

# replace rsh to ssh
%__subst "s,rsh,ssh," %buildroot/%_x11bindir/rstart
%__subst "s,=rsh,=ssh," %buildroot/%_x11bindir/xon

#install dmx configurations tools
%__install -pD -m755 %_builddir/%name-%version/xc/programs/Xserver/hw/dmx/config/{xdmxconfig,dmxtodmx,vdltodmx} \
    %buildroot%_x11bindir/

# moved libGL
%__mkdir_p %buildroot%_x11libdir/mesa_gl
%__mv %buildroot%_x11libdir/libGL.so.1.2 %buildroot%_x11libdir/mesa_gl/
%__ln_s -f mesa_gl/libGL.so.1.2 %buildroot%_x11libdir/
%__ln_s -f mesa_gl/libGL.so.1.2 %buildroot%_x11libdir/libGL.so.1

%__rm -f %buildroot%_sysconfdir/X11/app-defaults/Xman
%__ln_s -f ../../%_x11bindir/X %buildroot%_sysconfdir/X11/

%__mkdir -p %buildroot%_usrsrc/kernel/sources/
%__mv %_builddir/kernel-source-%kmodule_name-%src_version.tar.bz2 %buildroot%_usrsrc/kernel/sources/

%__rm -fr %buildroot%_x11fontsdir/OTF
%__rm -fr %buildroot%_x11fontsdir/cyrillic

# move pkgconfig to correct path
%ifarch x86_64
%__mv %buildroot%prefix/lib/pkgconfig %buildroot%_libdir/
%endif


%post xapps
%update_menus

%postun xapps
%clean_menus

%post -n twm
%update_menus

%postun -n twm
%clean_menus

%triggerin -- XFree86, xorg-x11 <= 6.8.1-alt7, fglrg-x11 <= 3.14.1
cd %_sysconfdir/X11
for d in xorg.conf XF86Config XF86Config-4; do
	if [ -r $d -a -w $d ]; then
		perl -pi -e 's/^.*Load.*"(pex5|xie|xtt).*\n$"//gi' $d
		perl -pi -e 's/Driver(.*)"keyboard"/Driver\1"kbd"/gi' $d
#		perl -pi -e 's/Driver(.*)"fglrx"/Driver\1"ati"/gi' $d
		perl -pi -e 's/Driver(.*)".*_gatos"/Driver\1"ati"/gi' $d
		perl -pi -e 's/^.*Option.*"XkbRules".*\n$//gi' $d
	fi
done
for d in XF86Config-4 XF86Config ; do
	if [ -r $d ]; then
		if [ -r xorg.conf ]; then
			mv -f $d $d.obsoleted
		else
			mv -f $d xorg.conf
		fi
	fi
done

%post ttf-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/TTF

%postun ttf-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/TTF
fi

%post mesaGL
cd %_x11libdir
[ -f libGL.so.1 ] || %__ln_s -f mesa_gl/libGL.so.1.2 libGL.so.1
/sbin/ldconfig

%triggerpostun mesaGL -- XFree86-libs, libGLwrapper, fglrx_glx <= 3.14.1
cd %_x11libdir
%__ln_s -f mesa_gl/libGL.so.1.2 libGL.so.1.2
%__ln_s -f mesa_gl/libGL.so.1.2 libGL.so.1
/sbin/ldconfig

%postun mesaGL
%postun_ldconfig

%post libs
grep -qs "^%_x11libdir$" /etc/ld.so.conf || echo "%_x11libdir" >> /etc/ld.so.conf
%post_ldconfig

%triggerpostun libs -- XFree86-libs
grep -qs "^%_x11libdir$" /etc/ld.so.conf || echo "%_x11libdir" >> /etc/ld.so.conf
/sbin/ldconfig

%postun libs
if [ "$1" = "0" ]; then
	if grep -qs '^%_x11libdir$' /etc/ld.so.conf; then
		%__subst "s,%_x11libdir,," /etc/ld.so.conf
	fi
fi
%postun_ldconfig

%post 75dpi-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/75dpi:unscaled

%triggerpostun 75dpi-fonts -- XFree86-75dpi-fonts
%_x11bindir/mkfontdir %_x11fontsdir/75dpi/
/usr/sbin/chkfontpath -q -a %_x11fontsdir/75dpi:unscaled

%postun 75dpi-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/75dpi:unscaled
fi

%post 75dpi-fonts-unicode
/usr/sbin/chkfontpath -q -a %_x11fontsdir/75dpi-unicode:unscaled

%triggerpostun 75dpi-fonts-unicode -- XFree86-75dpi-fonts-unicode
%_x11bindir/mkfontdir %_x11fontsdir/75dpi-unicode/
/usr/sbin/chkfontpath -q -a %_x11fontsdir/75dpi-unicode:unscaled

%postun 75dpi-fonts-unicode
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/75dpi-unicode:unscaled
fi

%post 100dpi-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/100dpi:unscaled

%triggerpostun 100dpi-fonts -- XFree86-100dpi-fonts
%_x11bindir/mkfontdir %_x11fontsdir/100dpi/
/usr/sbin/chkfontpath -q -a %_x11fontsdir/100dpi:unscaled

%postun 100dpi-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/100dpi:unscaled
fi

%post 100dpi-fonts-unicode
/usr/sbin/chkfontpath -q -a %_x11fontsdir/100dpi-unicode:unscaled

%triggerpostun 100dpi-fonts-unicode -- XFree86-100dpi-fonts-unicode
%_x11bindir/mkfontdir %_x11fontsdir/100dpi-unicode/
/usr/sbin/chkfontpath -q -a %_x11fontsdir/100dpi-unicode:unscaled

%postun 100dpi-fonts-unicode
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/100dpi-unicode:unscaled
fi

%pre xfs
/usr/sbin/groupadd -r -f xfs
/usr/sbin/useradd -r -g xfs -d /etc/X11/fs -s /dev/null -c "X Font Server" -n xfs >/dev/null 2>&1 ||:

%post xfs
%post_service xfs

%preun xfs
%preun_service xfs

%triggerin xfs -- XFree86-xfs
/sbin/service xfs status > /var/lock/xfs.status ||:

%triggerpostun xfs -- XFree86-xfs
/sbin/chkconfig --add xfs
[ "`cat /var/lock/xfs.status`" != "xfs is running" ] || /sbin/service xfs start
%__rm -f /var/lock/xfs.status

%post misc-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/misc:unscaled
/usr/bin/fc-cache %_x11fontsdir/misc/ ||:

%postun misc-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/misc:unscaled
fi

%post type1-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/Type1

%postun type1-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/Type1
fi

%post speedo-fonts
/usr/sbin/chkfontpath -q -a %_x11fontsdir/Speedo

%postun speedo-fonts
if [ "$1" = "0" ]; then
	/usr/sbin/chkfontpath -q -r %_x11fontsdir/Speedo
fi

%pre server
/usr/sbin/groupadd -r -f xgrp
%pre_control xorg-server

%post server
%post_control xorg-server

%files

%files distr

%files server-common
%dir %_x11fontsdir
%_sysconfdir/X11/xserver
%_x11mandir/man7/Xsecurity.7x*

%files server 
%doc %_x11datadir/X11/Cards
%doc %_x11datadir/X11/doc
%_docdir/%name-server-%version
%_x11bindir/Xorg
%_x11bindir/X
%config(noreplace) %_sysconfdir/pam.d/xserver
%config(missingok noreplace) %_sysconfdir/security/console.apps/xserver
%dir %_x11libdir/modules
%_x11libdir/modules/*.a
%exclude %_x11libdir/modules/libscanpci.a
%_x11libdir/modules/*.uc
%_x11libdir/modules/extensions
%exclude %_x11libdir/modules/extensions/libGLcore.a
%exclude %_x11libdir/modules/extensions/libglx.a
%dir %_x11libdir/modules/dri
%dir %_x11libdir/modules/drivers
%_x11libdir/modules/drivers/dummy_drv.o
%_x11libdir/modules/drivers/fbdev_drv.o
%_x11libdir/modules/drivers/vesa_drv.o
%_x11libdir/modules/drivers/vga_drv.o
%dir %_x11libdir/modules/input
%_x11libdir/modules/input/void_drv.o
%_x11libdir/modules/input/mouse_drv.o
%_x11libdir/modules/input/kbd_drv.o
%_x11libdir/modules/input/summa_drv.o
# 6.8.1.99
#%_x11libdir/modules/input/evdev_drv.o
#
%_x11libdir/modules/linux
%_x11libdir/modules/fonts
%_x11datadir/X11/xserver
%_x11bindir/startx
%_x11datadir/X11/xkb
%_x11datadir/X11/xinit
%_sysconfdir/X11/X
%_iconsdir/Bluecurve
%_iconsdir/default
%_localstatedir/xkb
%_x11mandir/man4/fbdev.4x*
%_x11mandir/man4/fbdevhw.4x*
%_x11mandir/man4/vga.4x*
%_x11mandir/man4/vesa.4x*
%_x11mandir/man4/void.4x*
%_x11mandir/man4/mouse.4x*
%_x11mandir/man4/kbd.4x*
%_x11mandir/man7/X.*7x*
%_x11mandir/man7/XConsortium.7x*
%_x11mandir/man7/XProjectTeam.7x*

%files drv-v4l
%_x11libdir/modules/drivers/linux
%_x11mandir/man4/v4l.4x*

%files drv-input
%_docdir/%name-drv-input-%version
%_x11libdir/modules/input/linux
%_x11libdir/modules/input/acecad_drv.o
%_x11libdir/modules/input/digitaledge_drv.o
%_x11libdir/modules/input/fpit_drv.o
%_x11libdir/modules/input/keyboard_drv.o
%_x11libdir/modules/input/spaceorb_drv.o
%_x11libdir/modules/input/wacom_drv.o
%_x11libdir/modules/input/aiptek_drv.o
%_x11libdir/modules/input/dmc_drv.o
%_x11libdir/modules/input/hyperpen_drv.o
%_x11libdir/modules/input/calcomp_drv.o
%_x11libdir/modules/input/dynapro_drv.o
%_x11libdir/modules/input/js_x_drv.o
%_x11libdir/modules/input/magellan_drv.o
%_x11libdir/modules/input/palmax_drv.o
%_x11libdir/modules/input/tek4957_drv.o
%_x11libdir/modules/input/citron_drv.o
%_x11libdir/modules/input/elographics_drv.o
%_x11libdir/modules/input/microtouch_drv.o
%_x11libdir/modules/input/penmount_drv.o
%_x11libdir/modules/input/mutouch_drv.o
%_x11mandir/man4/mutouch.4x*
%_x11mandir/man4/ur98.4x*
%_x11mandir/man4/fpit.4x*
%_x11mandir/man4/keyboard.4x*
%_x11mandir/man4/wacom.4x*
%_x11mandir/man4/aiptek.4x*
%_x11mandir/man4/dmc.4x*
%_x11mandir/man4/dynapro.4x*
%_x11mandir/man4/js_x.4x*
%_x11mandir/man4/palmax.4x*
%_x11mandir/man4/tek4957.4x*
%_x11mandir/man4/citron.4x*
%_x11mandir/man4/elographics.4x*
%_x11mandir/man4/microtouch.4x*
%_x11mandir/man4/penmount.4x*

%files drv-glint
%_x11libdir/modules/drivers/glint_drv.o
%_x11libdir/modules/dri/gamma_dri.so
%_x11mandir/man4/glint.4x*

%files drv-savage
%_x11libdir/modules/drivers/savage_drv.o
%ifnarch x86_64
%_x11libdir/modules/dri/savage_dri.so
%endif
%_x11mandir/man4/savage.4x*

%files drv-tdfx
%_x11libdir/modules/drivers/tdfx_drv.o
%ifnarch x86_64
%_x11libdir/modules/dri/tdfx_dri.so
%_x11libdir/modules/dri/ffb_dri.so
%endif
%_x11mandir/man4/tdfx.4x*

%files drv-ati
%_docdir/%name-drv-ati-%version
%_x11libdir/modules/dri/r128_dri.so
%_x11libdir/modules/dri/r200_dri.so
%_x11libdir/modules/dri/radeon_dri.so
%ifnarch x86_64
%_x11libdir/modules/dri/mach64_dri.so
%endif
%_x11libdir/modules/drivers/ati_drv.o
%_x11libdir/modules/drivers/atimisc_drv.o
%_x11libdir/modules/drivers/r128_drv.o
%_x11libdir/modules/drivers/radeon_drv.o
# 6.8.1.99
#%_x11libdir/modules/multimedia
#
%_x11mandir/man4/r128.4x*
%_x11mandir/man4/radeon.4x*

%files drv-nvidia
%_x11libdir/modules/drivers/nv_drv.o
%_x11libdir/modules/drivers/riva128.o
%_x11mandir/man4/nv.4x*

%files drv-i128
%_docdir/%name-drv-i128-%version
%_x11libdir/modules/drivers/i128_drv.o
%_x11mandir/man4/i128.4x*

%files drv-sis
%_docdir/%name-drv-sis-%version
%_x11libdir/modules/drivers/sis_drv.o
%ifnarch x86_64
%_x11libdir/modules/dri/sis_dri.so
%endif
%_x11mandir/man4/sis.4x*

%files drv-apm
%_docdir/%name-drv-apm-%version
%_x11libdir/modules/drivers/apm_drv.o
%_x11mandir/man4/apm.4x*

%files drv-chips
%_docdir/%name-drv-chips-%version
%_x11libdir/modules/drivers/chips_drv.o
%_x11mandir/man4/chips.4x*

%files drv-cyrix
%_docdir/%name-drv-cyrix-%version
%_x11libdir/modules/drivers/cyrix_drv.o
%_x11mandir/man4/cyrix.4x*

%ifnarch x86_64
%files drv-i740
%_docdir/%name-drv-i740-%version
%_x11libdir/modules/drivers/i740_drv.o
%_x11mandir/man4/i740.4x*
%endif

%files drv-i8xx
%_docdir/%name-drv-i8xx-%version
%_x11libdir/modules/drivers/i810_drv.o
%ifnarch x86_64
%_x11libdir/modules/dri/i810_dri.so
%_x11libdir/modules/dri/i915_dri.so
%endif
%_x11libdir/libI810XvMC.so.*
%_x11mandir/man4/i810.4x*

%ifnarch x86_64
%files drv-newport
%_docdir/%name-drv-newport-%version
%_x11libdir/modules/drivers/newport_drv.o
%_x11mandir/man4/newport.4x*
%endif

%files drv-rendition
%_docdir/%name-drv-rendition-%version
%_x11libdir/modules/drivers/rendition_drv.o
%_x11mandir/man4/rendition.4x*

%files drv-s3virge
%_docdir/%name-drv-s3virge-%version
%_x11libdir/modules/drivers/s3virge_drv.o
%_x11mandir/man4/s3virge.4x*

%files drv-ark
%_x11libdir/modules/drivers/ark_drv.o

%files drv-cirrus
%_x11libdir/modules/drivers/cirrus_*.o
%_x11mandir/man4/cirrus.4x*

%files drv-trident
%_x11libdir/modules/drivers/trident_*.o
%_x11mandir/man4/trident.4x*

%ifnarch x86_64
%files drv-imstt
%_x11libdir/modules/drivers/imstt_drv.o
%_x11mandir/man4/imstt.4x*
%endif

%files drv-mga
%_x11libdir/modules/drivers/mga_drv.o
%_x11libdir/modules/dri/mga_dri.so
%_x11mandir/man4/mga.4x*

%ifnarch x86_64
%files drv-via
%_x11libdir/modules/drivers/via_drv.o
%_x11libdir/modules/dri/unichrome_dri.so
# 6.8.1.99
#%_x11libdir/libviaXvMC.so.*
#
%_x11mandir/man4/via.4x*
%endif

%files drv-neomagic
%_x11libdir/modules/drivers/neomagic_drv.o
%_x11mandir/man4/neomagic.4x*

%ifnarch x86_64
%files drv-nsc
%_x11libdir/modules/drivers/nsc_drv.o
%_x11mandir/man4/nsc.4x*
%endif

%files drv-s3
%_x11libdir/modules/drivers/s3_drv.o

%files drv-siliconmotion
%_x11libdir/modules/drivers/siliconmotion_drv.o
%_x11mandir/man4/siliconmotion.4x*

%files drv-tga
%_docdir/%name-drv-tga-%version
%_x11libdir/modules/drivers/tga_drv.o

%files drv-tseng
%_x11libdir/modules/drivers/tseng_drv.o
%_x11mandir/man4/tseng.4x*

%ifnarch x86_64
%files drv-vmware
%_x11libdir/modules/drivers/vmware_drv.o
%_x11mandir/man4/vmware.4x*
%endif

%files rstart
%_sysconfdir/X11/rstart
%_x11datadir/X11/rstart
%config(noreplace) %_sysconfdir/X11/rstart/config
%_x11bindir/rstart
%_x11bindir/rstartd
%_x11bindir/xon
%_x11mandir/man1/rstart.1x*
%_x11mandir/man1/rstartd.1x*
%_x11mandir/man1/xon.1x*

%files xdm
%config(noreplace) %_sysconfdir/logrotate.d/xdm
%config(noreplace) %_sysconfdir/pam.d/xdm
%dir %_sysconfdir/X11/app-defaults
%config(noreplace) %_sysconfdir/X11/app-defaults/Chooser
%dir %_sysconfdir/X11/xdm
%dir %attr(0700,root,root) %_sysconfdir/X11/xdm/authdir
%_x11bindir/xdm
%_x11bindir/chooser
%_x11datadir/X11/xdm
%_x11mandir/man1/xdm.1x*
%dir %_localstatedir/xdm

%files xauth
%_x11bindir/xauth
%_x11mandir/man1/xauth.1*

%files bitmaps
%_x11includedir/X11/bitmaps

%files Xprt
%_x11bindir/Xprt
%_x11bindir/xphelloworld
%_x11bindir/xplsprinters
%_x11bindir/xprehashprinterlist
%_x11bindir/xpsimplehelloworld
%_x11bindir/xpxthelloworld
# 6.8.1.99
#%_x11bindir/xpr
#%_x11bindir/xdpr
#%_x11bindir/xdbedizzy
#%_x11bindir/pclcomp
#
%_x11bindir/xmore
%_x11mandir/man1/xphelloworld.1x*
%_x11mandir/man1/xplsprinters.1x*
# 6.8.1.99
#%_x11mandir/man1/xpr.1x*
#%_x11mandir/man1/xdbedizzy.1x*
#%_x11mandir/man1/pclcomp.1x*
#%_x11mandir/man1/xdpr.1x*
#
%_x11mandir/man1/Xprt.1x*
%_x11mandir/man1/xmore.1x*
%_x11mandir/man1/xprehashprinterlist.1x*
%_x11mandir/man1/xpsimplehelloworld.1x*
%_x11mandir/man1/xpxthelloworld.1x*
%_x11mandir/man7/Xprint.7x*
%_sysconfdir/X11/xprint

%files libs
%_x11datadir/X11/Options
%_x11datadir/X11/XErrorDB
%_x11datadir/X11/XKeysymDB
%_x11datadir/X11/rgb.txt
%_x11datadir/X11/Xcms.txt
%_x11libdir/*.so.*
%exclude %_x11libdir/libGL*.so.1*
%exclude %_x11libdir/libOSMesa.so.*
# 6.8.1.99
#%exclude %_x11libdir/libviaXvMC.so.*
#
%exclude %_x11libdir/libI810XvMC.so.*
#%_sysconfdir/ld.so.conf.d/X11R6.conf

%files mesaGL
%_x11bindir/glxinfo
%_x11bindir/xdriinfo
%_x11libdir/mesa_gl
%_x11libdir/libGL*.so.1*
%_x11libdir/libOSMesa.so.*
%dir %_x11libdir/modules
%dir %_x11libdir/modules/extensions
%_x11libdir/modules/extensions/libGLcore.a
%_x11libdir/modules/extensions/libglx.a
%ghost %_x11libdir/libGL.so.1
%_x11mandir/man1/xdriinfo.1x*
%_x11mandir/man1/glxinfo.1x*

%files utils
%_x11bindir/lbxproxy
%_x11bindir/proxymngr
%_x11bindir/xfindproxy
%_x11bindir/xfwp
%_x11bindir/lndir
%_x11bindir/luit
%_x11bindir/mkdirhier
%_x11bindir/appres
%_x11bindir/cleanlinks
%_x11bindir/dpsexec
%_x11bindir/dpsinfo
%_x11bindir/gtf
%_x11bindir/iceauth
%_x11bindir/showrgb
%_x11bindir/smproxy
%_x11bindir/x11perf
%_x11bindir/x11perfcomp
%_x11bindir/Xmark
%_x11bindir/xcutsel
%_x11bindir/xcmsdb
%_x11bindir/sessreg
%_x11bindir/xdpyinfo
%attr(0755,root,root) %_x11bindir/dga
%_x11bindir/xhost
%_x11bindir/xinit
%_x11bindir/setxkbmap
%_x11bindir/xkbcomp
%_x11bindir/xkbevd
%_x11bindir/xkbprint
%_x11bindir/xkbvleds
%_x11bindir/xkbwatch
%_x11bindir/xkbbell
%_x11bindir/xlsatoms
%_x11bindir/xlsclients
%_x11bindir/xlsfonts
%_x11bindir/xmessage
%_x11bindir/xmodmap
%_x11bindir/xprop
%_x11bindir/xrdb
%_x11bindir/xset
%_x11bindir/xrefresh
%_x11bindir/xsetmode
%_x11bindir/xsetpointer
%_x11bindir/xsetroot
%_x11bindir/xstdcmap
%_x11bindir/xev
%_x11bindir/xwd
%_x11bindir/xwininfo
%_x11bindir/xwud
%_x11bindir/xorgconfig
%_x11bindir/ico
%_x11bindir/listres
%_x11bindir/mkhtmlindex
%_x11bindir/oclock
%_x11bindir/pcitweak
%_x11bindir/pswrap
%_x11bindir/revpath
%_x11bindir/rman
%_x11bindir/showfont
%_x11bindir/xgamma
%_x11bindir/xvinfo
%_x11bindir/xrandr
%_x11bindir/inb
%_x11bindir/inl
%_x11bindir/inw
%_x11bindir/ioport
%_x11bindir/makepsres
%_x11bindir/makestrs
%_x11bindir/mmapr
%_x11bindir/mmapw
%_x11bindir/outb
%_x11bindir/outl
%_x11bindir/outw
%_x11bindir/xtrapchar
%_x11bindir/xtrapin
%_x11bindir/xtrapinfo
%_x11bindir/xtrapout
%_x11bindir/xtrapproto
%_x11bindir/xtrapreset
%_x11bindir/xtrapstats
%_x11bindir/cxpm
%_x11bindir/sxpm
%_x11bindir/getconfig
%_x11bindir/getconfig.pl
%_x11mandir/man1/getconfig.1x*
%_x11mandir/man1/cxpm.1x*
%_x11mandir/man1/sxpm.1x*
%_x11mandir/man1/xrandr.1x*
%_x11mandir/man1/xvinfo.1x*
%_x11mandir/man1/xgamma.1x*
%_x11mandir/man1/showfont.1x*
%_x11mandir/man1/rman.1x*
%_x11mandir/man1/revpath.1x*
%_x11mandir/man1/pswrap.1x*
%_x11mandir/man1/pcitweak.1x*
%_x11mandir/man1/oclock.1x*
%_x11mandir/man1/listres.1x*
%_x11mandir/man1/luit.1x*
%_x11mandir/man1/ico.1x*
%_x11mandir/man1/Xmark.1x*
%_x11mandir/man1/dpsexec.1x*
%_x11mandir/man1/dpsinfo.1x*
%_x11mandir/man1/lbxproxy.1x*
%_x11mandir/man1/proxymngr.1x*
%_x11mandir/man1/xfindproxy.1x*
%_x11mandir/man1/xfwp.1x*
%_x11mandir/man1/lndir.1x*
%_x11mandir/man1/makestrs.1x*
%_x11mandir/man1/mkdirhier.1x*
%_x11mandir/man1/appres.1x*
%_x11mandir/man1/iceauth.1x*
%_x11mandir/man1/showrgb.1x*
%_x11mandir/man1/smproxy.1x*
%_x11mandir/man1/x11perf.1x*
%_x11mandir/man1/x11perfcomp.1x*
%_x11mandir/man1/xcutsel.1x*
%_x11mandir/man1/xcmsdb.1x*
%_x11mandir/man1/sessreg.1x*
%_x11mandir/man1/xdpyinfo.1x*
%_x11mandir/man1/xev.1x*
%_x11mandir/man1/dga.1x*
%_x11mandir/man1/xhost.1x*
%_x11mandir/man1/xinit.1x*
%_x11mandir/man1/startx.1x*
%_x11mandir/man1/setxkbmap.1x*
%_x11mandir/man1/xkbcomp.1x*
%_x11mandir/man1/xkbevd.1x*
%_x11mandir/man1/xkbprint.1x*
%_x11mandir/man1/xlsatoms.1x*
%_x11mandir/man1/xlsclients.1x*
%_x11mandir/man1/xlsfonts.1x*
%_x11mandir/man1/xmessage.1x*
%_x11mandir/man1/xmodmap.1x*
%_x11mandir/man1/xprop.1x*
%_x11mandir/man1/xrdb.1x*
%_x11mandir/man1/xrefresh.1x*
%_x11mandir/man1/xset.1x*
%_x11mandir/man1/xsetmode.1x*
%_x11mandir/man1/xsetpointer.1x*
%_x11mandir/man1/xsetroot.1x*
%_x11mandir/man1/xstdcmap.1x*
%_x11mandir/man1/xwd.1x*
%_x11mandir/man1/xwininfo.1x*
%_x11mandir/man1/xwud.1x*
%_x11mandir/man1/Xserver.1x*
%_x11mandir/man1/Xorg.1x*
%_x11mandir/man1/cleanlinks.1x*
%_x11mandir/man1/gtf.1x*
%_x11mandir/man1/makepsres.1x*
%_x11mandir/man1/mkhtmlindex.1x*
%_x11mandir/man1/xtrap.1x*
%_x11mandir/man1/xtrapchar.1x*
%_x11mandir/man1/xtrapin.1x*
%_x11mandir/man1/xtrapinfo.1x*
%_x11mandir/man1/xtrapout.1x*
%_x11mandir/man1/xtrapproto.1x*
%_x11mandir/man1/xtrapreset.1x*
%_x11mandir/man1/xtrapstats.1x*
%_x11mandir/man1/xorgconfig.1x*
%_x11mandir/man1/dumpkeymap.1x*
%_x11mandir/man5/xorg.conf.5x*
%_x11mandir/man5/getconfig.5x*
%dir %_x11datadir/X11/etc
%_x11datadir/X11/etc/xmodmap.std
%_x11datadir/X11/x11perfcomp
%_x11datadir/X11/lbxproxy
%_x11datadir/X11/proxymngr
%_x11datadir/X11/getconfig
%dir %_sysconfdir/X11/lbxproxy
%dir %_sysconfdir/X11/proxymngr
%config(noreplace) %_sysconfdir/X11/lbxproxy/*
%config(noreplace) %_sysconfdir/X11/proxymngr/*

%files font-utils
%_x11bindir/bdftopcf
%_x11bindir/bdftruncate
%_x11bindir/mkfontdir
%_x11bindir/mkfontscale
%_x11bindir/mkcfm
%_x11bindir/ucs2any
%_x11fontsdir/util
%_x11fontsdir/encodings
%_x11mandir/man1/bdftopcf.1x*
%_x11mandir/man1/bdftruncate.1x*
%_x11mandir/man1/mkfontdir.1x*
%_x11mandir/man1/mkfontscale.1x*
%_x11mandir/man1/mkcfm.1x*
%_x11mandir/man1/ucs2any.1x*

%files devel
%_x11includedir/*
%exclude %_x11includedir/X11/bitmaps
%exclude %_x11includedir/X11/pixmaps
%_includedir/X11
%_includedir/GL
%_x11mandir/man3
%exclude %_x11mandir/man3/DMX*
%_x11datadir/X11/config
%_x11bindir/imake
%_x11bindir/makedepend
%_x11bindir/gccmakedep
%_x11bindir/ccmakedep
%_x11bindir/xmkmf
%_x11bindir/makeg
%_x11bindir/mergelib
%_x11bindir/xcursorgen
%_x11bindir/*-config
%_x11mandir/man1/makeg.1x*
%_x11mandir/man1/imake.1x*
%_x11mandir/man1/makedepend.1x*
%_x11mandir/man1/xmkmf.1x*
%_x11mandir/man1/xcursorgen.1x*
%_x11mandir/man1/mergelib.1x*
%_x11mandir/man1/ccmakedep.1x*
%_x11mandir/man1/gccmakedep.1x*
%_x11mandir/man7/XStandards.7x*
%_x11libdir/*.so
# 6.8.1.99
#%exclude %_x11libdir/libviaXvMC.so
#
%exclude %_x11libdir/libI810XvMC.so
%_libdir/pkgconfig/*

%files devel-static
%_x11libdir/*.a

%files sdk
%_x11libdir/Server

%files Xvfb
%_x11bindir/Xvfb
%_x11mandir/man1/Xvfb.1x*

%files Xnest
%_x11bindir/Xnest
%_x11mandir/man1/Xnest.1x*

%files Xdmx
%_x11bindir/Xdmx
%_x11bindir/xdmxconfig
%_x11bindir/dmxtodmx
%_x11bindir/vdltodmx
%_x11mandir/man1/Xdmx.1x*
%_x11mandir/man1/dmxtodmx.1x*
%_x11mandir/man1/vdltodmx.1x*
%_x11mandir/man1/xdmxconfig.1x*
%_x11mandir/man3/DMX*

%files doc
%doc xc/doc/hardcopy/*

%files 75dpi-fonts
%dir %_x11fontsdir/75dpi
%_x11fontsdir/75dpi/*.gz
%_x11fontsdir/75dpi/fonts.alias
%_x11fontsdir/75dpi/fonts.dir
%ghost %_x11fontsdir/75dpi/fonts.cache-1

%files 100dpi-fonts
%dir %_x11fontsdir/100dpi
%_x11fontsdir/100dpi/*.gz
%_x11fontsdir/100dpi/fonts.alias
%_x11fontsdir/100dpi/fonts.dir
%ghost %_x11fontsdir/100dpi/fonts.cache-1

%files 75dpi-fonts-unicode
%dir %_x11fontsdir/75dpi-unicode
%_x11fontsdir/75dpi-unicode/*.gz
%_x11fontsdir/75dpi-unicode/fonts.dir
%ghost %_x11fontsdir/75dpi-unicode/fonts.cache-1

%files 100dpi-fonts-unicode
%dir %_x11fontsdir/100dpi-unicode
%_x11fontsdir/100dpi-unicode/*.gz
%_x11fontsdir/100dpi-unicode/fonts.dir
%ghost %_x11fontsdir/100dpi-unicode/fonts.cache-1

%files ttf-fonts
%dir %_x11fontsdir/TTF
%_x11fontsdir/TTF/*.ttf
%_x11fontsdir/TTF/fonts.dir
%_x11fontsdir/TTF/fonts.scale
%ghost %_x11fontsdir/TTF/fonts.cache-1

%files misc-fonts
%dir %_x11fontsdir/misc
%_x11fontsdir/misc/*.gz
%_x11fontsdir/misc/fonts.alias
%_x11fontsdir/misc/fonts.dir
%ghost %_x11fontsdir/misc/fonts.cache-1

%files type1-fonts
%dir %_x11fontsdir/Type1
%_x11fontsdir/Type1/*.pfa
%_x11fontsdir/Type1/*.pfb
%_x11fontsdir/Type1/*.afm
%_x11fontsdir/Type1/fonts.scale
%_x11fontsdir/Type1/fonts.dir
%ghost %_x11fontsdir/Type1/fonts.cache-1

%files speedo-fonts
%dir %_x11fontsdir/Speedo
%_x11fontsdir/Speedo/*.spd
%_x11fontsdir/Speedo/fonts.dir
%_x11fontsdir/Speedo/fonts.scale
%ghost %_x11fontsdir/Speedo/fonts.cache-1

%files xfs
%_docdir/%name-xfs-%version
%config %_initdir/xfs
%config(noreplace) %_sysconfdir/sysconfig/xfs
%_x11datadir/X11/fs
%_x11bindir/xfsinfo
%_x11bindir/fslsfonts
%_x11bindir/fstobdf
%_x11bindir/xfs
%_x11mandir/man1/xfs.1x*
%_x11mandir/man1/xfsinfo.1x*
%_x11mandir/man1/fslsfonts.1x*
%_x11mandir/man1/fstobdf.1x*

%files locales
%_x11datadir/X11/locale

%files xapps
%dir %_sysconfdir/X11/app-defaults
%config(noreplace) %_sysconfdir/X11/app-defaults/*
%exclude %_sysconfdir/X11/app-defaults/Chooser
%dir %_sysconfdir/X11/xsm
%config(noreplace) %_sysconfdir/X11/xsm/system.xsm
%_x11datadir/X11/xsm
%_x11bindir/beforelight
%_x11bindir/bitmap
%_x11bindir/bmtoa
%_x11bindir/atobm
%_x11bindir/xclock
%_x11bindir/editres
%_x11bindir/viewres
%_x11bindir/xcalc
%_x11bindir/xfontsel
%_x11bindir/xedit
%_x11datadir/X11/xedit
%_x11bindir/xclipboard
%_x11bindir/xconsole
%_x11bindir/xload
%_x11bindir/xlogo
%_x11bindir/xkill
%_x11bindir/xsm
%_x11bindir/xditview
%_x11bindir/xeyes
%_x11bindir/xfd
%_x11bindir/xgc
%_x11bindir/xmag
%_x11bindir/xmh
%_x11bindir/xvidtune
%_x11bindir/xorgcfg
%_x11bindir/glxgears
%_x11bindir/texteroids
%_x11bindir/xbiff
%_x11mandir/man1/xvidtune.1x*
%_x11mandir/man1/xmh.1x*
%_x11mandir/man1/xmag.1x*
%_x11mandir/man1/xgc.1x*
%_x11mandir/man1/xfd.1x*
%_x11mandir/man1/xeyes.1x*
%_x11mandir/man1/xditview.1x*
%_x11mandir/man1/xsm.1x*
%_x11mandir/man1/xkill.1x*
%_x11mandir/man1/xlogo.1x*
%_x11mandir/man1/xload.1x*
%_x11mandir/man1/xconsole.1x*
%_x11mandir/man1/xclipboard.1x*
%_x11mandir/man1/xedit.1x*
%_x11mandir/man1/xfontsel.1x*
%_x11mandir/man1/xcalc.1x*
%_x11mandir/man1/viewres.1x*
%_x11mandir/man1/editres.1x*
%_x11mandir/man1/xclock.1x*
%_x11mandir/man1/bmtoa.1x*
%_x11mandir/man1/atobm.1x*
%_x11mandir/man1/bitmap.1x*
%_x11mandir/man1/beforelight.1x*
%_x11mandir/man1/xorgcfg.1x*
%_x11mandir/man1/glxgears.1x*
%_x11mandir/man1/texteroids.1x*
%_x11mandir/man1/xbiff.1x*
%_x11includedir/X11/pixmaps
%exclude %_miconsdir/twm.xpm
%exclude %_liconsdir/twm.xpm
%exclude %_iconsdir/twm.xpm
%_miconsdir/*.xpm
%_liconsdir/*.xpm
%_iconsdir/*.xpm
%_menudir/%name-xapps

%files -n twm
%dir %_sysconfdir/X11/twm
%config(noreplace) %_sysconfdir/X11/twm/system.twmrc
%_x11datadir/X11/twm
%_x11mandir/man1/twm.1x*
%_x11bindir/twm
%_menudir/twm
%_miconsdir/twm.xpm
%_liconsdir/twm.xpm
%_iconsdir/twm.xpm

%files -n kernel-source-%kmodule_name-%src_version
%_usrsrc/kernel/sources/kernel-source-%kmodule_name-%src_version.tar.bz2

%files -n kernel-doc-%kmodule_name-%src_version
%doc xc/extras/drm/linux/README.drm

%changelog
* Wed Jan 26 2005 Valery Inozemtsev <shrek@altlinux.ru> 6.8.2-alt2.RC3
- 6.8.2RC3

* Tue Jan 18 2005 Valery Inozemtsev <shrek@altlinux.ru> 6.8.2-alt2.RC2
- rebuild with libstdc++.so.6

* Wed Jan 12 2005 Valery Inozemtsev <shrek@altlinux.ru> 6.8.2-alt1.RC2
- 6.8.2RC2

* Mon Dec 20 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.2-alt1.RC1
- 6.8.2RC1

* Tue Dec 14 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1.99-alt2
- cvs snapshot 20041214
- fixed #5666, #5699
- Enable DRM support for any ATI R300

* Thu Dec 09 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1.99-alt1
- cvs snapshot 20041209
- remove fbdev driver in AutoConfig
- rename font name helvetica to fixed in xorgcfg
- build dynamic library xf86config
- add UseDeprecatedKeyboardDriver option

* Thu Nov 18 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt17
- More fixes for potential integer overflows,
  patch from Thomas Biege and Matthieu Herrb.
  
* Tue Nov 16 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt16
- disable i2c drivers for ATI RV280 and newer

* Fri Nov 12 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt15
- removed patch to support 3D for ATI RV300

* Wed Nov 10 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt14
- fixed pciids for ATI RV300
- support for new NVIDIA chips

* Tue Nov 09 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt13
- update r128 dualhead patch
- fixed #5470
- added patch to support 3D for ATI RV300
- moved Xprint config files to %%_sysconfdir/X11/xprint

* Wed Nov 03 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt12
- fixed significant bit in Xfont
- added CP866 locale

* Mon Oct 25 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt11
- update via drivers from cvs
- fixed #5368, #5306

* Tue Oct 19 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt10
- fixed requires
- fix removed fonts.cache-1 files with fonts packages

* Mon Oct 18 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt9
- first build for ALT Installer 1.0
- update default font path to %%_x11fontsdir/misc:unscaled
- fixed #5346
- build Multi-head X server to package xorg-x11-Xdmx
- fixed requires
- fixed paratype-CP154 patch
- build SDK to package xorg-x11-sdk

* Thu Oct 14 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt8
- moved Speedo fonts to package xorg-x11-speedo-fonts
- fixed rstart and moved to package xorg-x11-rstart
- moved graphical application to package xorg-x11-xapps
- update cvs patches
- added cvs patch for i810 driver
- added cvs patch for nv driver

* Mon Oct 11 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt7
- enabled Xv extension
- added conflicts to fglrx_glx <= 3.14.1
- added paratype-cp154 fonts
- fixed encodings files
- added new cvs patches
- added Genius KB-19e NB keyboard

* Fri Oct 08 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt6
- fixed #4583
- twm moved to package twm
- fixed imake
- added cvs patches

* Wed Oct 06 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt5
- linked libGL.so.1.2 to mesa_gl/libGL.so.1.2 unconditionally
- linked libGL.so.1 to mesa_gl/libGL.so.1.2 by default,
  third party libGL drivers may override it
- fixed update XFree86-libs to xorg-x11-libs
- fixed xfs %%triggerin
- package kernel-source-drm build from xorg-x11

* Sat Oct 02 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt4
- fixed provides glx
- Xprint moved to xorg-x11-Xprt
- removed Xman
- added dualhead patches

* Thu Sep 23 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt3
- enabled FSUseSyslog
- fixed platform autodetection
- removed xterm manpage
- packaged libXpm
- corrected update XFree86 to xorg-x11
- moved libGL.so.1.2 to mesa_gl/libGL.so.1.2
- patched apps configs
- fixed pkgconfig path
- removed buildreq substitution rules

* Fri Sep 17 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt2
- fix #3420
- Anton D. Kachalov <mouse@altlinux.org>: Build on x86_64
- Anton D. Kachalov <mouse@altlinux.org>: libGL build with PIC

* Thu Sep 16 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.1-alt1
- 6.8.1

* Sat Sep 11 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.8.0-alt1
- 6.8.0
- Spec cleanup
- default cursor themes removed
- Bluecurve cursors theme added
- patched neomagic driver

* Sat Aug 28 2004 Valery Inozemtsev <shrek@altlinux.ru> 6.7.0-alt2
- fix provides/obsoletes
- added buildreq substitution rules

* Tue Aug 24 2004 Alexei Takaseev <taf@altlinux.ru> 6.7.0-alt1
- X.Org
