# -*- rpm-spec -*-
# $Id: postgresql,v 1.13 2002/10/08 10:33:00 lioka Exp $

Name: postgresql
Version: 7.4.6
Release: alt1

%define PGSQL pgsql
%define ROOT %_localstatedir/%PGSQL-root

%define libpq_major    3
%define libecpg_major  4
%define libpgtcl_major 2

%define libpq_name    libpq%libpq_major
%define libecpg_name  libecpg%libecpg_major
%define libpgtcl_name libpgtcl%libpgtcl_major

Summary: PostgreSQL client programs and libraries.
License: BSD
Group: Databases
Url: http://www.%name.org/

Packager: Konstantin Timoshenko <kt@altlinux.ru>

Source: ftp://ftp.%name.org/pub/source/v%version/%name-%version.tar.bz2
Source1: %name.init
Source2: %name.chroot.lib
Source3: %name.chroot.conf
Source4: %name.chroot.all
Source5: %name.chroot.bin

Source8: pg-migration-scripts-7.2.tar.bz2
Source12: %name-dump.1
Source13: pg_options-7.2

Source30: http://jdbc.%name.org/download/pg73jdbc1.jar
Source31: http://jdbc.%name.org/download/pg73jdbc2.jar
Source32: http://jdbc.%name.org/download/pg73jdbc3.jar

Source40: upgrade_tips_7.3
Source41: ftp.postgresql.org:/pub/binary/v7.2/RPMS/README.rpm-dist
Source42: http://www.rbt.ca/postgresql/upgrade/upgrade.pl

Patch0: %name-7.2-include.patch
Patch1: %name-7.4-alt-chroot.patch
Patch2: %name-7.2.1-tinfo.patch
Patch3: %name-7.4-pgtcl.patch
Patch4: %name-7.4.6-alt-python64.patch

BuildPreReq: /usr/bin/mksock perl-DBD-Pg perl-DBI perl-Pg

Requires: %libpq_name = %version-%release

# Automatically added by buildreq on Wed Dec 22 2004
BuildRequires: OpenSP docbook-dtds docbook-style-dsssl flex hostinfo
BuildRequires: libpam-devel libreadline-devel libssl-devel openjade
BuildRequires: perl-SGMLSpm perl-devel pmake python-base python-dev
BuildRequires: python-modules-encodings sgml-common tcl-devel xml-common zlib-devel

%description
PostgreSQL is an advanced Object-Relational database management system
(DBMS) that supports almost all SQL constructs (including
transactions, subselects and user-defined types and functions). The
postgresql package includes the client programs and libraries that
you'll need to access a PostgreSQL DBMS server.  These PostgreSQL
client programs are programs that directly manipulate the internal
structure of PostgreSQL databases on a PostgreSQL server. These client
programs can be located on the same machine with the PostgreSQL
server, or may be on a remote machine which accesses a PostgreSQL
server over a network connection. This package contains the docs
in HTML for the whole package, as well as command-line utilities for
managing PostgreSQL databases on a PostgreSQL server.

If you want to manipulate a PostgreSQL database on a remote PostgreSQL
server, you need this package. You also need to install this package
if you're installing the postgresql-server package.

%package -n %libpq_name
Summary: The shared libraries required for any PostgreSQL clients.
Group: Databases

%description -n %libpq_name
C and C++ libraries to enable user programs to communicate with the
PostgreSQL database backend. The backend can be on another machine and
accessed through TCP/IP.

%package -n %libpq_name-devel
Summary: Development shared library for %libpq_name
Group: Development/Databases
Requires: %libpq_name = %version-%release

%description -n %libpq_name-devel
Development shared library for %libpq_name

%package -n %libpq_name-devel-static
Summary: Development static library for %libpq_name
Group: Development/Databases
Requires: %libpq_name-devel = %version-%release

%description -n %libpq_name-devel-static
Development static library for %libpq_name

%package -n %libecpg_name
Summary: Shared library %libecpg_name for PostgreSQL
Group: Databases

%description -n %libecpg_name
%libecpg_name is used by programs built with ecpg (Embedded PostgreSQL for C)
Use postgresql-dev to develop such programs.

%package -n %libecpg_name-devel
Summary: Development shared library to %libecpg_name
Group: Development/Databases
Requires: %libecpg_name = %version-%release
Conflicts: libecpg3-devel

%description -n %libecpg_name-devel
Development shared library for %libecpg_name and the ecpg Embedded C
Postgres preprocessor.

%package -n %libecpg_name-devel-static
Summary: Development static library to %libecpg_name
Group: Development/Databases
Requires: %libecpg_name-devel = %version-%release

%description -n %libecpg_name-devel-static
Development static library to %libecpg_name

%package -n %libpgtcl_name
Summary: Tcl/Tk library and front-end for PostgreSQL.
Group: Databases
Requires: tcl >= 8.4.0-alt1

%description -n %libpgtcl_name
The postgresql-tcl package contains the pg-enhanced pgtclsh and the library
to enable Tcl/Tk scripts to communicate with the PostgreSQL database backend.

%package docs
Summary: Extra documentation for PostgreSQL
Group: Databases

%description docs
The postgresql-docs package includes the SGML source for the documentation
as well as the documentation in other formats, and some extra documentation.
Install this package if you want to help with the PostgreSQL documentation
project, or if you want to generate printed documentation.

%package contrib
Summary: Contributed source and binaries distributed with PostgreSQL
Group: Databases
Requires: %name = %version-%release

%description contrib
The postgresql-contrib package includes the contrib tree distributed with
the PostgreSQL tarball.  Selected contrib modules are prebuilt.

%package server
Summary: The programs needed to create and run a PostgreSQL server.
Group: Databases
PreReq: shadow-utils, syslogd-daemon, grep, %__subst, chrooted
Requires: %name = %version-%release

%description server
The postgresql-server package includes the programs needed to create
and run a PostgreSQL server, which will in turn allow you to create
and maintain PostgreSQL databases.  PostgreSQL is an advanced
Object-Relational database management system (DBMS) that supports
almost all SQL constructs (including transactions, subselects and
user-defined types and functions). You should install
postgresql-server if you want to create and maintain your own
PostgreSQL databases and/or your own PostgreSQL server. You also need
to install the postgresql package.

%package devel
Summary: PostgreSQL development header files.
Group: Development/Databases
Requires: %libpq_name-devel = %version-%release, %libecpg_name-devel = %version-%release

%description devel
The postgresql-devel package contains the header files needed to compile applications
which will directly interact with a PostgreSQL database management server.
You need to install this package if you want to develop applications which will interact
with a PostgreSQL server.

%package tcl
Summary: The PL/Tcl procedural language for PostgreSQL.
Group: Databases
Requires: %name = %version-%release tcl >= 8.4.0-alt1

%description tcl
PostgreSQL is an advanced Object-Relational database management
system.  The postgresql-tcl package contains the PL/Tcl procedural language
for the backend.

%package perl
Summary: The PL/Perl procedural language for PostgreSQL.
Group: Databases
Requires: %name = %version-%release
AutoReqProv: yes, perl

%description perl
PostgreSQL is an advanced Object-Relational database management
system.  The postgresql-perl package contains the PL/Perl procedural
language for the backend.

%package python
Summary: Development module for Python code to access a PostgreSQL DB.
Group: Databases
Requires: %name = %version-%release, python >= %__python_version, egenix-mx-base >= 2.0.3

%description python
PostgreSQL is an advanced Object-Relational database management
system.  The postgresql-python package includes a module for
developers to use when writing Python code for accessing a PostgreSQL
database.

%package jdbc
Summary: Files needed for Java programs to access a PostgreSQL database.
Group: Databases
Requires: %name = %version-%release

%description jdbc
PostgreSQL is an advanced Object-Relational database management
system. The postgresql-jdbc package includes the .jar file needed for
Java programs to access a PostgreSQL database.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4

%build
autoreconf -fsiv
./configure %_target_platform \
	--prefix=%prefix \
	--mandir=%_mandir \
	--docdir=%_docdir \
	--includedir=%_includedir/%PGSQL \
	--sysconfdir=%_sysconfdir/%PGSQL \
	--datadir=%_datadir/%PGSQL \
	--localstatedir=%_localstatedir \
	--libdir=%_libdir \
	--enable-hba \
	--enable-recode \
	--enable-multibyte \
	--enable-nls \
	--without-tk \
	--with-pam \
	--with-openssl \
	--with-CXX \
	--with-perl \
	--with-x \
	--enable-odbc \
	--with-tcl --with-tclconfig=%_libdir \
	--with-readline \
	--with-python \
	--disable-rpath

%make_build pkglibdir=%_libdir/%PGSQL

pushd contrib
%make_build all libdir=%_datadir/%PGSQL/contrib
popd

%install
%make_build install DESTDIR=$RPM_BUILD_ROOT pkglibdir=%_libdir/%PGSQL
%make_build install-all-headers DESTDIR=$RPM_BUILD_ROOT pkglibdir=%_libdir/%PGSQL

# the postgresql-dump manpage.....
%__cp %SOURCE12 $RPM_BUILD_ROOT%_man1dir/

# copy over Makefile.global & Makefile.port to the include dir....
%__install -m644 src/Makefile.global $RPM_BUILD_ROOT%_includedir/%PGSQL
%__install -m644 src/Makefile.port $RPM_BUILD_ROOT%_includedir/%PGSQL

# Java/JDBC
# The user will have to set a CLASSPATH to find it here, but not sure where else to put it...
# JDBC jars
%__install -m 755 %SOURCE30 $RPM_BUILD_ROOT%_datadir/%PGSQL
%__install -m 755 %SOURCE31 $RPM_BUILD_ROOT%_datadir/%PGSQL
%__install -m 755 %SOURCE32 $RPM_BUILD_ROOT%_datadir/%PGSQL

%__install -m 755 %SOURCE42 $RPM_BUILD_ROOT%_datadir/%PGSQL/upgrade.pl

# The sysconfig directory
%__install -d -m 700 $RPM_BUILD_ROOT%_sysconfdir/%PGSQL

# The initscripts....
%__install -p -m755 -D %SOURCE1 $RPM_BUILD_ROOT%_initdir/%name
%__install -p -m750 -D %SOURCE2 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/%name.lib
%__install -p -m750 -D %SOURCE3 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/%name.conf
%__install -p -m750 -D %SOURCE4 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/%name.all
%__install -p -m750 -D %SOURCE5 $RPM_BUILD_ROOT%_sysconfdir/chroot.d/%name.bin

%__subst -p 's|CHROOTDIR|%ROOT|g' $RPM_BUILD_ROOT%_initdir/%name
pushd $RPM_BUILD_ROOT%_sysconfdir/chroot.d
for f in %name.*; do
 if [ -f "$f" ]; then
   %__subst -p 's|CHROOTDIR|%ROOT|g' $f
 fi
done
popd

# PGDATA needs removal of group and world permissions due to pg_pwd hole.
%__install -d -m700 $RPM_BUILD_ROOT%_localstatedir/%PGSQL/data

# backups of data go here...
%__install -d -m700 $RPM_BUILD_ROOT%_localstatedir/%PGSQL/backups

# Initial pg_options
%__install -p -m600 %SOURCE13 $RPM_BUILD_ROOT%_localstatedir/%PGSQL/data/pg_options

# Upgrade scripts.
%__tar xjf %SOURCE8 -C $RPM_BUILD_ROOT

# Fix a dangling symlink
%__mkdir_p $RPM_BUILD_ROOT%_includedir/%PGSQL/port
%__cp src/include/port/linux.h $RPM_BUILD_ROOT%_includedir/%PGSQL/port/
%__ln_s port/linux.h $RPM_BUILD_ROOT%_includedir/%PGSQL/os.h

# Chrooted environment
%__mkdir_p $RPM_BUILD_ROOT%ROOT/{bin,dev,lib,tmp,%_sysconfdir/%PGSQL,%_localstatedir,%_libdir/%PGSQL,%_libdir/locale}

mksock $RPM_BUILD_ROOT%ROOT/dev/log
%__mkdir_p -m700 $RPM_BUILD_ROOT%_sysconfdir/syslog.d
%__ln_s %ROOT/dev/log $RPM_BUILD_ROOT%_sysconfdir/syslog.d/%name

%__mv $RPM_BUILD_ROOT%_localstatedir/%PGSQL $RPM_BUILD_ROOT%ROOT/%_localstatedir/%PGSQL
%__ln_s %ROOT%_localstatedir/%PGSQL $RPM_BUILD_ROOT%_localstatedir/%PGSQL

%__cp -a contrib $RPM_BUILD_ROOT%_datadir/%PGSQL/
pushd $RPM_BUILD_ROOT%_datadir/%PGSQL/contrib
%__rm -rf start-scripts
%__rm -f */*.o */*.a

for p in *; do
 if [ -d "$p" ]; then
   pushd $p
    curdir=`pwd`
    filelist=`find $curdir -name "*.sql" -print`
     for f in $filelist; do
      if [ -f "$f" ]; then
	%__subst -p "s|\$libdir|/lib/$p|g" $f
      fi
     done
   popd
 fi
done
popd

%define docdir %_docdir/%name-%version
# Package docs
%__rm -rf $RPM_BUILD_ROOT%docdir
%__mkdir_p $RPM_BUILD_ROOT%docdir

%__cp -a COPYRIGHT README HISTORY %SOURCE40 %SOURCE41 \
	doc/{FAQ,KNOWN_BUGS,MISSING_FEATURES,TODO,FAQ_russian,bug.template} \
	$RPM_BUILD_ROOT%docdir/

%__install -p -m644 src/interfaces/jdbc/README  $RPM_BUILD_ROOT%docdir/README.jdbc

%__bzip2 $RPM_BUILD_ROOT%docdir/FAQ*
%__mv $RPM_BUILD_ROOT%_docdir/%name/html $RPM_BUILD_ROOT%_docdir/%name-docs-%version

%find_lang libpq
%find_lang pg_dump
%find_lang postgres
%find_lang psql
%find_lang pg_resetxlog
%find_lang pg_controldata
%find_lang pgscripts

%__cat psql.lang pg_dump.lang pgscripts.lang> main.lang
%__cat postgres.lang pg_resetxlog.lang pg_controldata.lang > server.lang

%__chmod a-x $RPM_BUILD_ROOT%_datadir/pgsql/contrib/oracle/*

%pre
# Need to make backups of some executables if an upgrade
# They will be needed to do a dump of the old version's database.
# All output redirected to /dev/null.
exec &>/dev/null
if [ $1 -gt 1 -a -d %_libdir/%PGSQL ]
then
    if [ ! -d %_libdir/%PGSQL/backup ]; then
	%__mkdir_p %_libdir/%PGSQL/backup
    fi
    cd %_bindir
    %__cp -fp pg_dump pg_dumpall psql %_libdir/%PGSQL/backup || :
fi

%pre server
exec &>/dev/null
/usr/sbin/groupadd -g 46 postgres || :
/usr/sbin/useradd -M -o -r -d %_localstatedir/%PGSQL -s /dev/null \
	-c "PostgreSQL Server" -u 46 postgres -g postgres || :

if [ $1 -gt 1 ]
then
   if [ ! -d %_libdir/%PGSQL/backup ]; then
       %__mkdir_p %_libdir/%PGSQL/backup
   fi
   cd %_bindir
   %__cp -fp postmaster postgres %_libdir/%PGSQL/backup
fi

%pre -n %libpq_name
exec &>/dev/null
if [ $1 -gt 1 -a -d %_libdir/%PGSQL ]
then
    if [ ! -d %_libdir/%PGSQL/backup ]; then
	%__mkdir_p %_libdir/%PGSQL/backup
    fi
    cd %_libdir > /dev/null
    %__cp -fp libpq.* %_libdir/%PGSQL/backup
fi

%post server
echo PGLIB=%_datadir/%PGSQL >> ~postgres/.bash_profile
echo PGDATA=%_localstatedir/%PGSQL/data >> ~postgres/.bash_profile
echo export PGLIB PGDATA >> ~postgres/.bash_profile
%__chown postgres:postgres ~postgres/.bash_profile

SYSLOGD_SCRIPT=/etc/init.d/syslogd
SYSLOGD_CONFIG=/etc/sysconfig/syslogd
if %__grep -qs '^SYSLOGD_OPTIONS=.*-a %ROOT/dev/log' "$SYSLOGD_CONFIG"; then
	%__subst 's|^\(SYSLOGD_OPTIONS=.*\) \?-a %ROOT/dev/log|\1|' "$SYSLOGD_CONFIG"
	if [ -x "$SYSLOGD_SCRIPT" ]; then
		"$SYSLOGD_SCRIPT" condreload ||:
	fi
fi

%_sysconfdir/chroot.d/%name.all force
%post_service %name

%preun server
%preun_service %name
%post -p %post_ldconfig     -n %libpq_name
%postun -p %postun_ldconfig -n %libpq_name

%post -p %post_ldconfig     -n %libecpg_name
%postun -p %postun_ldconfig -n %libecpg_name

%post -p %post_ldconfig     -n %libpgtcl_name
%postun -p %postun_ldconfig -n %libpgtcl_name

%files -f main.lang
%_bindir/clusterdb
%_bindir/createdb
%_bindir/createlang
%_bindir/createuser
%_bindir/dropdb
%_bindir/droplang
%_bindir/dropuser
%_bindir/pg_dump
%_bindir/pg_dumpall
%_bindir/pg_encoding
%_bindir/pg_id
%_bindir/pg_restore
%_bindir/psql
%_bindir/vacuumdb
%_man1dir/clusterdb.1*
%_man1dir/createdb.1*
%_man1dir/createlang.1*
%_man1dir/createuser.1*
%_man1dir/dropdb.1*
%_man1dir/droplang.1*
%_man1dir/dropuser.1*
%_man1dir/pg_dump.1*
%_man1dir/pg_restore.1*
%_man1dir/pg_dumpall.1*
%_man1dir/psql.1*
%_man1dir/vacuumdb.1*
%_man7dir/*
%dir %docdir
%docdir/FAQ.bz2
%docdir/KNOWN_BUGS
%docdir/MISSING_FEATURES
%docdir/TODO
%docdir/FAQ_russian.bz2
%docdir/COPYRIGHT
%docdir/README
%docdir/HISTORY
%docdir/bug.template
%docdir/README.rpm-dist
%docdir/upgrade_tips_7.3

%files docs
%dir %_docdir/%name-docs-%version
%_docdir/%name-docs-%version/*.html
%_docdir/%name-docs-%version/*.css

%files contrib
%_datadir/%PGSQL/contrib
%exclude %_datadir/%PGSQL/contrib/oracle

%files -f libpq.lang -n %libpq_name
%_libdir/libpq.so.%libpq_major
%_libdir/libpq.so.%libpq_major.*

%files -n %libecpg_name
%_libdir/libecpg.so.%libecpg_major
%_libdir/libecpg.so.%libecpg_major.*
%_libdir/libecpg_compat.so.*
%_libdir/libpgtypes.so.*

%files -n %libpgtcl_name
%_tcldatadir/pgtcl2.4
%_datadir/%PGSQL/unknown.pltcl
%_tcllibdir/libpgtcl.so.%libpgtcl_major
%_tcllibdir/libpgtcl.so.%libpgtcl_major.*
%_tcllibdir/libpgtcl.so

%files -f server.lang server
%config %_initdir/%name
%config %_sysconfdir/chroot.d/%name.*
%_bindir/initdb
%_bindir/initlocation
%_bindir/ipcclean
%_bindir/pg_controldata
%_bindir/pg_ctl
%_bindir/pg_resetxlog
%_bindir/postgres
%_bindir/postmaster
%_bindir/%name-dump

%_man1dir/initdb.1*
%_man1dir/initlocation.1*
%_man1dir/ipcclean.1*
%_man1dir/pg_controldata.1
%_man1dir/pg_resetxlog.1*
%_man1dir/pg_ctl.1*
%_man1dir/postgres.1*
%_man1dir/postmaster.1*
%_man1dir/%name-dump.1*
%dir %_sysconfdir/%PGSQL
%dir %_libdir/%PGSQL
%_libdir/%PGSQL/plpgsql.so
%_libdir/%PGSQL/*_and_*.so
%dir %_datadir/%PGSQL
%dir %_datadir/%PGSQL/backup
%_datadir/%PGSQL/postgres.bki
%_datadir/%PGSQL/postgres.description
%_datadir/%PGSQL/*.sample
%_datadir/%PGSQL/backup/pg_dumpall_new
%_datadir/%PGSQL/conversion_create.sql
%_datadir/%PGSQL/upgrade.pl
%_datadir/%PGSQL/information_schema.sql
%_datadir/%PGSQL/sql_features.txt
%_localstatedir/%PGSQL
%_sysconfdir/syslog.d/%name

%attr(751,root,root)  %dir %ROOT
%attr(751,root,root)  %dir %ROOT/bin
%attr(751,root,root)  %dir %ROOT/etc
%attr(751,root,root)  %dir %ROOT/etc/%PGSQL
%attr(751,root,root)  %dir %ROOT/dev
%attr(751,root,root)  %dir %ROOT/lib
%attr(1777,root,root) %dir %ROOT/tmp
%attr(751,root,root)  %dir %ROOT/usr
%attr(751,root,root)  %dir %ROOT/var
%attr(751,root,root)  %dir %ROOT%_libdir
%attr(751,root,root)  %dir %ROOT%_libdir/%PGSQL
%attr(751,root,root)  %dir %ROOT%_libdir/locale
%attr(751,root,root)  %dir %ROOT%_localstatedir
%attr(700,postgres,postgres)  %dir %ROOT%_localstatedir/%PGSQL
%attr(700,postgres,postgres)  %dir %ROOT%_localstatedir/%PGSQL/backups
%attr(700,postgres,postgres)  %dir %ROOT%_localstatedir/%PGSQL/data
%attr(666,root,root) %ghost %ROOT/dev/log

%files devel
%_includedir/%PGSQL
%_bindir/pg_config
%_man1dir/pg_config.*

%files -n %libpq_name-devel
%_libdir/libpq*.so

%files -n %libecpg_name-devel
%_bindir/ecpg
%_libdir/libecpg*.so
%_libdir/libpgtypes.so
%_man1dir/ecpg.*

%files -n %libpq_name-devel-static
%_libdir/libpq*.a

%files -n %libecpg_name-devel-static
%_libdir/libecpg*.a
%_libdir/libpgtypes.a

%files tcl
%_bindir/pltcl_delmod
%_bindir/pltcl_listmod
%_bindir/pltcl_loadmod
%_libdir/%PGSQL/pltcl.so

%files perl
%_libdir/%PGSQL/plperl.so

%files python
%dir %docdir
%_libdir/%PGSQL/plpython.so

%files jdbc
%dir %docdir
%docdir/README.jdbc
%_datadir/%PGSQL/pg73jdbc1.jar
%_datadir/%PGSQL/pg73jdbc2.jar
%_datadir/%PGSQL/pg73jdbc3.jar

%changelog
* Wed Dec 22 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.6-alt1
- 7.4.6

* Mon Aug 23 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.5-alt1
- 7.4.5

* Tue Aug 03 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.3-alt2
- fix broken depends.

* Wed Jul 14 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.3-alt1
- 7.4.3
- fix bugs id #4773

* Tue May 11 2004 ALT QA Team Robot <qa-robot@altlinux.org> 7.4.2-alt2.1
- Rebuilt with openssl-0.9.7d.

* Thu May 06 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.2-alt2
- rebuild with glibc-2.3
- fix bugs id #3866

* Mon Mar 15 2004 Konstantin Timoshenko <kt@altlinux.ru> 7.4.2-alt1
- 7.4.2

* Wed Dec 24 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.4.1-alt1
- 7.4.1

* Tue Dec 02 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.4-alt3
- fix broken depends.

* Fri Nov 28 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.4-alt2
- conflicts with libecpg3
- cleanup spec

* Thu Nov 20 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.4-alt1
- 7.4

* Wed Oct 22 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.4-alt4
- fix pre script.

* Fri Sep 26 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.4-alt3
- fix build requires.

* Thu Sep 04 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.4-alt2
- fix bugs id #0002818
- fix documentation directory
- fix start/stop script

* Mon Aug 04 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.4-alt1
- 7.3.4

* Wed Jul 02 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.3-alt2
- fix bugs id #0002646, #0002650

* Tue May 27 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.3-alt1
- 7.3.3
- Rewritten start/stop script to new rc scheme.

* Fri Apr 25 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.2-alt2
- Make use of syslogd-1.4.1-alt11 /etc/syslog.d/ feature (#0002062)

* Thu Feb 06 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.2-alt1
- 7.3.2

* Wed Jan 29 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.1-alt7
- Remove libpgtcl-devel and libpgtcl-devel-static packages.
- fix bug id 2089.

* Tue Jan 28 2003 Dmitry V. Levin <ldv@altlinux.org> 7.3.1-alt6
- Fixed few broken dependencies.

* Mon Jan 27 2003 Stanislav Ievlev <inger@altlinux.ru> 7.3.1-alt5
- Fixed a lot of broken dependencies.

* Thu Jan 23 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.1-alt3
- Use subst instead of perl in %%post script.

* Fri Jan 17 2003 Konstantin Timoshenko <kt@altlinux.ru> 7.3.1-alt2
- split postgresql-libs to the %libpq_name, %libecpg_name subpackages.
- split postgresql-tcl package to the postgresql-tcl and %libpgtcl_name subpackages.
- add upgrade.pl script.
- fix & cleanup spec file

* Fri Dec 27 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.3.1-alt1
- 7.3.1
- fix wrong description
- remove postgresql-tk package

* Wed Dec 18 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.3-alt2
- fix init & chroot update scripts

* Tue Dec 10 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.3-alt1
- 7.3
- Remove locale and multibyte explicit enables -- they are both defaults now.
- Remove pgaccess code; it's not a part of the main tarball anymore.
- Remove ODBC stuff -- it's also separate now.  Use unixODBC instead.
- Remove all perl client stuff.

* Tue Nov 12 2002 Stanislav Ievlev <inger@altlinux.ru> 7.2.3-alt4
- fix perl deps via exclude contrib/oracle

* Fri Nov 01 2002 AEN <aen@altlinux.ru> 7.2.3-alt3
- rebuild with new perl
- Installation for perl files fixed

* Tue Oct  8 2002 Sergey Bolshakov <s.bolshakov@belcaf.com> 7.2.3-alt2
- rebuilt with tcl 8.4

* Fri Oct 04 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2.3-alt1
- 7.2.3

* Wed Sep 25 2002 Yuri N. Sedunov <aris@altlinux.ru> 7.2.2-alt2
- rebuild with gcc-3.2

* Tue Aug 27 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2.2-alt1
- 7.2.2
- fixed remove old pid file.

* Fri Jul 12 2002 Sergey Bolshakov <s.bolshakov@belcaf.com> 7.2.1-alt4
- rebuilt with new tcl layout
- custom tcl shells removed, use package require Pgtcl instead

* Tue Jul 02 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2.1-alt3
- Patched to link with libtinfo.

* Mon Apr 15 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2.1-alt2
- fix %name.init script

* Fri Apr 05 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2.1-alt1
- 7.2.1
- Fixed requires in python subpackage.

* Fri Mar 29 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2-alt6
- Fixed requires in python subpackage.
- Fixed creating default database.

* Wed Mar 06 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2-alt5
- Fixed permissions on directory %ROOT/tmp
- Fixed include files in devel subpackage.

* Wed Feb 27 2002 Dmitry V. Levin <ldv@alt-linux.org> 7.2-alt4
- Fixed devel subpackage.
- Corrected %%ROOT tree permissions.

* Wed Feb 20 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2-alt3
- Update for new chroot dir %ROOT
- Fixed permissions on directories %ROOT/*
- Fixed any bug.

* Tue Feb 19 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2-alt2
- fix permission in devel package

* Fri Feb 15 2002 Konstantin Timoshenko <kt@altlinux.ru> 7.2-alt1
- 7.2
- new chrooted scheme

* Fri Dec 28 2001 Konstantin Timoshenko <kt@altlinux.ru> 7.1.3-alt2
- remove sgml docs.

* Tue Aug 21 2001 Kostya Timoshenko <kt@altlinux.ru> 7.1.3-alt1
- 7.1.3
- Corrected BuildRequires

* Thu Jul 26 2001 Dmitry V. Levin <ldv@altlinux.ru> 7.1.1-alt5
- Updated scripts to handle new syslogd.
- Corrected requires

* Thu Jul 26 2001 Stanislav Ievlev <inger@altlinux.ru> 7.1.1-alt4
- Rebuilt with new perl again

* Wed Jun 27 2001 Sergie Pugachev <fd_rag@altlinux.ru> 7.1.1-alt3
- Rebuilt with python-2.1

* Mon Jun 25 2001 Sergie Pugachev <fd_rag@altlinux.ru> 7.1.1-alt2
- Rebuild with perl-5.6.1

* Mon May  7 2001 Kostya Timoshenko <kt@altlinux.ru> 7.1.1-alt1
- 7.1.1
- Removed broken and confusing logrotate script.
- adding subpackage plperl & jdbc.
- clean spec file

* Fri Apr 27 2001 Kostya Timoshenko <kt@altlinux.ru> 7.1-alt3
- add path to fix cyrillic unicode-conversion from Victor Wagner <vitus@ice.ru>
- fix permission chroot/tmp dir

* Wed Apr 25 2001 Kostya Timoshenko <kt@altlinux.ru> 7.1-alt2
- fix chroot problems
- fix postgresql init script

* Tue Apr 24 2001 Kostya Timoshenko <kt@altlinux.ru> 7.1-alt1
- Ported to new chrooted scheme.
- Automatically added buildreq
- Moved static libraries to devel-static subpackage.
- fix perl requires
- fix run level in postgresql init script
- fix permission 0700 -> 0600 for /var/log/pgsql
- fix postgresql init script
- Build for ALT Linux

* Fri Apr 13 2001 Lamar Owen <lamar@postgresql.org> <lamar.owen@wgcr.org>
- 7.1 RELEASE
- 7.1-1 RPM RELEASE
- Change to COPTS -- strip out -ffastmath -- Considered Harmful.
- Back to old versioning scheme, kept teg's other fixes.
- README.rpm-dist updated.
- PGVERSION updated all-around (hopefully!)
- Couple of fixes from Peter E.
- Rearrange dependencies -- only the -libs subpackage is required for most stuff
- Removed broken and confusing logrotate script.

* Mon Apr  9 2001 Trond Eivind Glomsrd <teg@redhat.com>
- chown considered harmful - removed
- fix dangling symlimks (pg_crc.c)
- libpq.so changes for maximum compatiblity
- different versioning scheme, to avoid trouble later
- remove temporary perl file from the file list
- fix spelling error in tcl description
- mark odbcinst.ini as a config file
- use %%defattr on packages which didn't have it

* Sat Apr 07 2001 Lamar Owen <lamar@postgresql.org> <lamar.owen@wgcr.org>
- Integrated the PL/Perl stuff from Karl DeBisschop --conditional.
- Packaging reorg: added contrib and docs subpackages.
- Removed sgml source docs from main package --> docs subpackage.
- Removed contrib tree from main package --> contrib subpackage.
- Contrib tree is now prebuilt -- HOWEVER, very little install work is
-- currently done with this.

* Fri Apr 06 2001 Lamar Owen <lamar@postgresql.org> <lamar.owen@wgcr.org>
- Quickie RC3.  There will be a 7.1RC3-2 shortly with other stuff.

* Tue Apr 03 2001 Lamar Owen <lamar@postgresql.org> <lamar.owen@wgcr.org>
- RC2
- eliminate versioning information for ancilliary files in prep for CVS.
- Fix docs mixup.

* Tue Mar 27 2001 Lamar Owen <lamar@postgresql.org> <lamar.owen@wgcr.org>
- RC1 quickie.

* Tue Mar 20 2001 Lamar Owen <lamar@postgresql.org>
- Beta 6 initial build.
- Use make install-all-headers instead of cpio hack for devel headers.
- Split out the libs into the libs subpackage.
- Updated initscript to use pg_ctl to stop
- Updated initscript to initdb and start postmaster with LC_ALL=C to
-- prevent index corruption.

* Sun Jan 28 2001 Lamar Owen <lamar@postgresql.org>
- Beta4
- Return to 'pgsql' directories instead of 'postgresql'
- Better perl patches.

* Mon Jan 15 2001 Lamar Owen <lamar@postgresql.org>
- Edit patches to get rid of some cruft.
- Eliminate some more pre-7.1 specfile baggage that is no longer necessary.
- Moved pg_id to server
- added Makefile.global and pg_config to devel
- Corrected /usr/include/pgsql to /usr/include/postgresql
- Fixed some configure options.  Will be trying the configure macro next release
- Since it is terminally ill in this version pg_upgrade is _gone_.
- Thanks to Peter E for a good review.

* Sun Jan 14 2001 Lamar Owen <lamar@postgresql.org>
- Running regression. 1 on the release-o-meter.
- Minor patches to get regression running right.
- Initscript tweaking -- the old test for a database structure fails with 7.1's new structure.

* Sat Jan 13 2001 Lamar Owen <lamar@postgresql.org>
- Perl 5 needs to be built with PREFIX set on the Makefile, not GNUmakefile....
- The 7.1 build is different from the 7.0 build -- see the configure line.
- NOTE: many files that used to be in /usr/share/postgresql are now in /usr/share/postgresql!
- by request, conditional packages are now supported. See the top of the spec.
- Fixed the server postinstall problems.

* Mon Jan 08 2001 Lamar Owen <lamar@postgresql.org>
- First 7.1 beta test-build

* Wed Nov 15 2000 Lamar Owen <lamar@postgresql.org>
- Buggy dependency on /lib/cpp -- not a PreReq, but a BuildPreReq.

* Tue Nov 14 2000 Trond Eivind Glomsrd <teg@redhat.com>
- made a template for IA64 (symlink to i386)

* Mon Nov 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add patch for IA64 (I got one from Lamar and modified it)

* Mon Nov 13 2000 Lamar Owen <lamar@postgresql.org>
- RELEASE: 7.0.3-1
- Minor edits to initscript.
- PRE-RELEASE: 7.0.3-0.6 (final test)
- Final 7.0.3 tarball.
- Cross-dist changes to RedHat initscript for better portability.
- changed README.rpm name to README.rpm-dist (the .rpm extension confused
--some GUI file managers, as RealPlayer also uses that extension).
- Edited README.rpm-dist to reflect cross-distribution packaging.
- NOTE: SuSE cross-compatibility is not yet complete  SuSE RPM's for 7.0.3
--that are tailored for SuSE will be made available.
- Fixed stupid dependency -- the main .so's were in the devel package (Arggh)

* Sat Nov 11 2000 Lamar Owen <lamar@postgresql.org>
- PRE-RELEASE: 7.0.3-0.5
- Framework for better distribution-independent build
- Conditional around libtool conf stuff copy (For RedHat 6.1 and such).
- Conditional around RedHat-style initscript stuff.
- Comments at top of spec file now list copyright and license for spec file,
--as the license and copyright for the spec file itself has not previously
--been stated.
- Envvars for postgres home dir login in .bash_profile.
- initscript now checks for success and failure functions using:
--typeset -f|grep "declare -f function_name" construct.

* Fri Nov 10 2000 Lamar Owen <lamar@postgresql.org>
- PRE-RELEASE: 7.0.3-0.4
- Directory ownership on /usr/share/postgresql/test/regress was root.root.
- Patch Makefile.shlib to not use -soname for RPM's.
- Newer prerelease 7.0.3 tarball.

* Thu Nov 09 2000 Lamar Owen <lamar@postgresql.org>
- PRE-RELEASE: 7.0.3-0.3
- Don't bother copying the test stuff I'm not packaging.
- Fix group add/del stuff in server subpackage post and postun scriptlets.
- symlink /usr/lib/libpq.so.2.0 -> libpq.so.2.1

* Mon Nov 06 2000 Lamar Owen <lamar@postgresql.org>
- PRE-RELEASE: 7.0.3-0.2
- preliminary 7.0.3 distribution tarball -- reinstated man pages, etc.

* Sat Nov 04 2000 Lamar Owen <lamar@postgresql.org>
- PRE-RELEASE: 7.0.3-0.1.
- Improved test subpackage -- only package regression.
- Latest pre-7.0.3 snapshot.
- Split out SuSE and Caldera spec files.  Caldera COL eServer 2.3 requires
-- RPM 2.5.5-compatible spec files.  SuSE is just too different from the others
-- for the spec file to cope, for now.
- TODO: man pages and documentation.

* Mon Oct 30 2000 Lamar Owen <lamar@postgresql.org>
- pre-7.0.3

* Mon Oct 30 2000 Lamar Owen <lamar@postgresql.org>
- Reenabled the test subpackage for ftp.postgresql.org dist.
- Backported to RH 6.2 -- involved the Pg man page, doesn't appear to require
-- other stuff to be done.

* Sun Oct 22 2000 Trond Eivind Glomsrd <teg@redhat.com>
- make /etc/logrotate.d/postgres 0644 instead of 0700 (#19520)

* Thu Oct 19 2000 Trond Eivind Glomsrd <teg@redhat.com>
- rebuild with new glibc which has semaphore fixes for Alpha

* Tue Sep 05 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add documention for python interface (#17261)
- move the python interface tutorial to the %%doc section

* Thu Aug 24 2000 Trond Eivind Glomsrd <teg@redhat.com>
- the old dump script didn't work - added rh-pgdump.sh
  to handle this. Point docs at it, and tell how it is to be used.

* Mon Aug 21 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix the initscript so it points you at the 7.0.2 directory
  in /usr/share/doc, not 7.0  (#16163). Also, remove statement
  it was built on a 6.2 system.
- prereq /lib/cpp and initscripts
- fix backups of existing files (#16706)
- fix conditional restart

* Sat Aug 19 2000 Trond Eivind Glomsrd <teg@redhat.com>
- fix README.rpm to it points at /usr/share/doc, not /usr/doc
  (part of #16416)

* Wed Aug 16 2000 Trond Eivind Glomsrd <teg@redhat.com>
- don't build test package anymore, it's broken. These
  tests should be run by pgsql developers and not
  by db-developers, so it's not a big loss (#16165).
  Obsolete it in the main package, so it doesn't get left over

* Mon Aug 14 2000 Trond Eivind Glomsrd <teg@redhat.com>
- reference docs in /usr/share/doc, not /usr/doc (#16163)
- add python-devel, perl and tcl as build prereqs
- use /dev/null as STDIN for su commands in initscripts,
  to avoid error messages from not being able to read from
  tty

* Sat Aug 05 2000 Bill Nottingham <notting@redhat.com>
- condrestart fixes

* Mon Jul 31 2000 Trond Eivind Glomsrd <teg@redhat.com>
- remove all plperl references, to avoid confusing post install scripts
- cleanups

* Mon Jul 17 2000 Trond Eivind Glomsrd <teg@redhat.com>
- remove the symlink from libpq.so.2.0 to libpq.so.2.1
- remove some binaries from docs
- fix dangling symlink os.h
- use /sbin/service

* Thu Jul 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- don't strip manually
- fixes to init script so they look more like the rest
  (#13749, from giulioo@pobox.com)
- use /etc/rc.d/init.d again (sigh)

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Thu Jul 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- "Prereq:", not "Requires:" for /etc/init.d

* Thu Jul 06 2000 Trond Eivind Glomsrd <teg@redhat.com>
- require /etc/init.d

* Wed Jun 21 2000 Trond Eivind Glomsrd <teg@redhat.com>
- remove perl kludge as perl 5.6 is now fixed
- include the man page for the perl module
- fix the init script and spec file to handle conditional
  restart
- move the init file to /etc/init.d
- use License instead of Copyright

* Mon Jun 19 2000 Trond Eivind Glomsrd <teg@redhat.com>
- rebuild

* Tue Jun 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- use %%defattr on postgresql-perl
- use %%_tmppath
- Don't use release number in patch
- Don't build on ia64 yet

* Mon Jun 12 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0.2-2
- Corrected misreporting of version.
- Corrected for non-root build clean script.

* Mon Jun 05 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0.2
- Postgresql-dump manpage to man1, and to separate source file to facilitate
-- _mandir macro expansion correctness.
- NOTE: The PostScript documentation is no longer being included in the
-- PostgreSQL tarball.  If demand is such, I will pull together a
-- postgresql-ps-docs subpackage or pull in the PostScript docs into the
-- main package.
- RPM patchset has release number, now, to prevent patchfile confusion :-(.

* Sat Jun 03 2000 Lamar Owen <lamar.owen@wgcr.org>
- Incorporate most of Trond's changes (reenabled the alpha
-- patches, as it was a packaging error on my part).
- Trimmed changelog history to Version 7.0beta1 on. To see the
-- previous changelog, grab the 6.5.3 RPM from RedHat 6.2 and pull the spec.
- Rev to 7.0.1 (which incorporates the syslog patch, which has
-- been removed from rpm-pgsql-7.0.1-1.patch)

* Fri May 26 2000 Trond Eivind Glomsrd <teg@redhat.com>
- disable the alpha patch, as it doesn't apply cleanly
- removed distribution, packager, vendor
- renamed spec file
- don't build pl-perl
- use %%_mandir
- now includes vacuumdb.1*

* Thu May 25 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0-3
- Incorporated Tatsuo's syslog segmentation patches
- Incorporated some of Trond's changes (see below)
-- Fixed some Perl 5.6 oddness in Rawhide
- Incorporated some of Karl's changes (see below)
-- PL/Perl should now work.
- Fixed missing /usr/bin/pg_passwd.

* Mon May 22 2000 Karl DeBisschop <kdebisschop@infoplease.com>
- 7.0-2.1
- make plperl module (works for linux i386, your guess for other platforms)
- use "make COPT=" because postgreSQL configusre script ignores CFLAGS

* Sat May 20 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0-2
- pg_options default values changed.
- SPI headers (again!) fixed in a permanent manner  -- hopefully!
- Alpha patches!

* Wed May 17 2000 Trond Eivind Glomsrd <teg@redhat.com>
- changed bug in including man pages

* Tue May 16 2000 Trond Eivind Glomsrd <teg@redhat.com>
- changed buildroot, removed packager, vendor, distribution
-- [Left all but buildroot as-is for PostgreSQL.org RPMS. LRO]
- don't strip in package [strip in PostgreSQL.org RPMS]
- fix perl weirdnesses (man page in bad location, remove
  perllocal.pod from file list)

* Mon May 15 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0 final -1
- Man pages restructured
- Changed README.rpm notices about BETA
- incorporated minor changes from testing
- still no 7.0 final alpha patches -- for -2 or -3, I guess.
- 7.0 JDBC jars!

* Sat May 06 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0RC5-0.5
- UserID of 26 to conform to RedHat Standard, instead of 40.  This only
-- is for new installs -- upgrades will use what was already there.
- Waiting on built jar's of JDBC.  If none are forthcoming by release,
-- I'm going to have to bite the bullet and install the jdk....

* Mon May 01 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0RC2-0.5
- Fixed /usr/src/redhat/BUILD path to $RPM_BUILD_DIR for portability
-- and so that RPM's can be built by non-root.
- Minor update to README.rpm

* Tue Apr 18 2000 Lamar Owen <lamar.owen@wgcr.org>
- 0.6
- Fixed patchset: wasn't patching pgaccess or -i in postmaster.opts.default
- minor update to README.rpm

* Mon Apr 17 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0RC1-0.5 (release candidate 1.)
- Fixed SPI header directories' permisssions.
- Removed packaging of Alpha patches until Ryan releases RC1-tested set.

* Mon Apr 10 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0beta5-0.1 (released instead of the release candidate)

* Sat Apr 08 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0beta4-0.2 (pre-release-candidate CVS checkout)
- Alpha patches!
- pg_options.sample

* Fri Mar 24 2000 Lamar Owen <lamar.owen@wgcr.org>
- 7.0beta3-0.1

* Mon Feb 28 2000 Lamar Owen <lamar.owen@wgcr.org>
- Release 0.3
- Fixed stderr redir problem in init script
- Init script now uses pg_ctl to start postmaster
- Packaged inital pg_options for good logging
- built with timestamped logging.

* Tue Feb 22 2000 Lamar Owen <lamar.owen@wgcr.org>
- Initial 7.0beta1 build
- Moved PGDATA to /var/lib/pgsql/data
- First stab at logging and logrotate functionality -- test carefully!
- -tcl subpackage split -- tcl client and pltcl lang separated from
-- the Tk stuff.  PgAccess and the tk client are now in the -tk subpackage.
- No patches for Alpha as yet.

