(define (mktest odir)
  (load (path-append odir "data" "scripts" "extra_feats.scm"))
  (set! feat_names (load (path-append odir "data" "scripts" "label.feats") t))
  (set! text "Синтез речи - в широком смысле - восстановление формы речевого сигнала по его параметрам; в узком смысле - формирование речевого сигнала по печатному тексту.")
  (set! utt (SynthText text))
  (set! tmp_name (make_tmp_filename))
  (set! tmp_fd (fopen tmp_name "w"))
  (mapcar
   (lambda (x)
     (mapcar
      (lambda (y)
        (format tmp_fd "%s " y))
      x)
     (format tmp_fd "\n"))
   (utt.features utt 'Segment feat_names))
  (fclose tmp_fd)
  (set! awk_script (path-append odir "data" "scripts" "label-full.awk"))
  (set! ofile (path-append odir "data" "labels" "gen" "test.lab"))
  (system (format nil "awk -f %s %s|awk '{print $3}'>%s" awk_script tmp_name ofile))
  (delete-file tmp_name))
