
#include <qapplication.h>
#include <qaccessible.h>
#include <qaccessible2.h>
#include <qaccessiblebridge.h>
#include <qstringlist.h>
#include<QTextCodec>
#include "accessibleapplication.h"

static AccessibleApplication* avApp = NULL;

class AlterVoice: public QAccessibleBridge
{
public:
  void setRootObject(QAccessibleInterface*);
  void notifyAccessibilityUpdate(int, QAccessibleInterface*, int);
}; //class AlterVoice;

class AlterVoicePlugin: public QAccessibleBridgePlugin
{
  Q_OBJECT
  public:
  AlterVoicePlugin(QObject* parent = 0);

  QAccessibleBridge* create(const QString&);
  QStringList keys() const;
}; //class AlterVoicePlugin;

AlterVoicePlugin::AlterVoicePlugin(QObject* parent)
  : QAccessibleBridgePlugin(parent)
{
}

QAccessibleBridge* AlterVoicePlugin::create(const QString& name)
{
  if (name == "ALTERVOICE")
    return new AlterVoice();
  return 0;
}

QStringList AlterVoicePlugin::keys() const
{
  QStringList l;
  l << "ALTERVOICE";
  return l;
}

Q_EXPORT_PLUGIN(AlterVoicePlugin)

static void cleanupAccessibility()
{
  delete avApp;
  avApp = 0;
}

void AlterVoice::setRootObject(QAccessibleInterface* iface)
{
  if (!iface)
    return;
  Q_ASSERT(!avApp);
  qDebug("Initializing AlterVoice...");
  QTextCodec::setCodecForCStrings(QTextCodec::codecForLocale());//FIXME:
  avApp = new AccessibleApplication();
  avApp->initAccessibility();
  qAddPostRoutine(cleanupAccessibility);
}

void AlterVoice::notifyAccessibilityUpdate(int event, QAccessibleInterface* iface, int child)
{
}

#include "altervoice.moc"

