
#include<assert.h>
#include<stdio.h>
#include<stdlib.h>
#include<iostream>
#include<string>
#include<sstream>
#include<fstream>//KILLME:
#include<vector>
#include<list>
#include<set>
#include<map>
#include<iconv.h>
#include"vmclient.h"
#include"Transcoding.h"
#include"vmstrings.h"

#define IGNORABLE_COMMANDS "tts_sync_state tts_pause tts_set_punctuations tts_set_speech_rate"

/**\brief The structure to store information about one emacspeak command*/
struct ESPEAKLINE
{
  /**\brief The default constructor*/
  ESPEAKLINE(): brLevel(0) {}

  /**\brief The command name*/
  std::string cmd;

  /**\brief The vector of provided parameters*/
  std::vector<std::string> params;

  /**\brief The auxiliary field to control opened brackets level*/
  int brLevel;
}; //struct ESPEAKLINE;

enum {QUEUE_ITEM_TEXT = 0, QUEUE_ITEM_PITCH = 1};

/**\brief The speech queue item*/
struct QUEUEITEM 
{
  /**\brief The constructor with item type specification
   *
   * \param t The new item type
   */
  QUEUEITEM(int t): type(t) {}

  /**\brief The item type*/
  int type;

  /**\brief The string argument*/
  std::string stringArgument;

  /**\brief The integer argument*/
  int integerArgument;
}; //struct QUEUEITEM;

/**\brief The current connection to voicemand*/
static vm_connection_t con = VOICEMAN_BAD_CONNECTION;

/**\brief Incomplete emacspeak command to be processed*/
static ESPEAKLINE currentESpeakLine;

/**\brief The collected queue to send to voicemand*/
static std::list<QUEUEITEM> queueToSend;

static void printToLog(const std::string& str)//KILLME:
{
  /*
  std::ofstream f("/tmp/espeak.input", std::ios_base::out | std::ios_base::app);
  f << str << std::endl;
  */
}

/**\brief Sends the text to voicemand to speak
 *
 * This function checks the connection to voicemand.
 * If a connection was not established, it tries to connect. If new attempt 
 * fails, this function do nothing silently or transmits the text data otherwise.
 *
 * \param [in] t The text to send
 */
void text(const std::string& t)
{
  std::string s=encodeUTF8(IO2WString(t));
  if (con==VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_text(con, (char*)s.c_str());
}

/**\brief Sends a letter command to daemon
 *
 * This function checks the connection to voicemand.
 * If a connection was not established, it tries to connect. If new attempt 
 * fails, this function do nothing silently or transmits the text data otherwise.
 *( \param l The letter bytes
 */
void letter(const std::string& l)
{
  std::wstring t=IO2WString(l);
  if (t.length()>1)
    t.resize(1);
  std::string s=encodeUTF8(t);
  if (con == VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_letter(con, (char*)s.c_str());
}

/**\brief Stops any speech playback on speech server
 *
 * This function checks the connection like text() or letter() functions
 */
void stop()
{
  if (con == VOICEMAN_BAD_CONNECTION)
    con = vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_stop(con);
}


/**\brief Sens a tone command to voiceman daemon
 *
 * This function checks connection like text() or letter() functions.
 *
 * \param freq The desired frequency of a command to send
 * \param [in] lenthMs The desired length of a command to send
 */
void tone(int freq, int lengthMs)
{
  if (con == VOICEMAN_BAD_CONNECTION)
    con=vm_connect();
  if (con != VOICEMAN_BAD_CONNECTION)
    vm_tone(con, freq, lengthMs);
}

/**\brief Removes Dectalk codes from the string
 *
 * \param [in/out] str The string to process
 */
void removeDectalkCodes(std::string& str)
{
  unsigned int k = 0;
  std::string s;
  while(k < str.length())
    {
      if (str[k] == '[')
	{
	  k++;
	  while(k < str.length() && str[k] != ']') k++;
	  if ( k >= str.length())
	    {
	      str = s;
	      return;
	    }
	  k++;
	  continue;
	}
      s += str[k++];
    }
  str = s;
}

/**\brief Parses one line of emacspeak protocol
 *
 * \param [in] str The string to parse
 * \param [in] line The object to save extracted information
 */
void splitEspeakLine(const std::string& str, ESPEAKLINE& line)
{
  int &level = line.brLevel;
  std::string next;
  bool toParams;
  if (level)
    {
      if (line.params.size())
	{
	  next = line.params[line.params.size()-1];
	  line.params.pop_back();
	  toParams = 1;
	} else
	{
	  next = line.cmd;
	  line.params.clear();
	  line.cmd.erase();
	  toParams = 0;
	}
    } else
    {
      line.cmd.erase();
      line.params.clear();
      toParams = 0;
    }
  unsigned int i;
  int state;
  if (level)
    state = 4; else
    state = 2;
  for(i=0;i<str.length();i++)
    {
      if (str[i] == ' ')
	{
	  if (state == 2)
	    continue;
	  if (state == 1)
	    {
	      state = 2;
	      continue;
	    }
	  if (state == 4)
	    {
	      next+=' ';
	      continue;
	    }
	  if (state == 0 || state == 5)
	    {
	      if (toParams)
		line.params.push_back(next); else
		  line.cmd = next;
	      next.erase();
	      toParams=1;
	      state = 1;
	      continue;
	    }
	  assert(0);
	} // spaces;
      if (str[i]=='{')
	{
	  if (state==1 || state == 2)
	    {
	      next.erase();
	      state = 4;
	      level=1;
	      continue;
	    }
	  if (state == 4)
	    {
	      next+=str[i];
	      level++;
	      continue;
	    }
	  if (state == 0)
	    {
	      next+=str[i]; 
	      continue;
	    }
	  continue;
	} // opening bracket;
      if (str[i] == '}')
	{
	  if (state == 4)
	    {
	      if (level==1)
		{
		  state=5;
		  level=0;
		} else
		  if (level > 1)
		    {
		      next+=str[i]; 
		      level--;
		    } else
		      {
			assert(0);
		      }
	      continue;
	    }
	  if (state == 0)
	    {
	      next+=str[i];
	      continue;
	    }
	  continue;
	} // closing bracket;
      // any char;
      if (state==0 || state==4)
	{
	  next+=str[i]; 
	  continue;
	}
      if (state == 1 || state == 2)
	{
	  next = str[i]; 
	  state = 0;
	}
    } // for
  if (state == 0 || state == 4 || state== 5)
    {
      if (toParams)
	line.params.push_back(next); else
	  line.cmd = next;
    }
}

/**\brief Parses one speech parameter value
 *
 * \param [in] str The string to process
 * \param [out] name Extracted parameter name
 * \param [out] value Extracted parameter value
 *
 * \return Non-zero if the string was successfully parsed
 */
bool parseSpeechParam(const std::string& str, std::string& name, std::string& value)
{
  unsigned int i, k = 0, c = 0;
  for(i=0;i<str.length();i++)
    if (str[i] == '=')
      {
	k = i;
	c++;
      }
  if (c != 1)
    return 0;
  if (str.length() - k < 3)
    return 0;
  if (str[k+1] != '\"')
    return 0;
  if (str[str.length()-1] != '\"')
    return 0;
  name.erase();
  value.erase();
  for(i=0;i<k;i++)
    name += str[i];
  for(i=k+2;i<str.length()-1;i++)
    value += str[i];
  return 1;
}

/**\brief maps received pitch value to a valid voiceman parameter value
 *
 * \param [in] origValue The value to process
 */
int preparePitchValue(int origValue)
{
  if (origValue < 65)
    return origValue;
  return 65;
}

/**\brief Handles one speech parameter string
 *
 * \param [in] str The string to process
 */
void processSpeechParamString(const std::string& str)
{
  std::string name, value;
  if (!parseSpeechParam(str, name, value))
    return;
  if (toLower(trim(name)) == "prosody pitch")
    {
      int k;
      if (!checkTypeUnsignedInt(value))
	return;
      k = preparePitchValue(parseAsUnsignedInt(value));
      QUEUEITEM qItem(QUEUE_ITEM_PITCH);
      qItem.integerArgument = k;
      queueToSend.push_back(qItem);
      return;
    }
}

/**\brief Adds queue item to restore changed pitch value*/
void addRestoringItems()
{
  QUEUEITEM qItem(QUEUE_ITEM_PITCH);
  qItem.integerArgument = 50;//FIXME:
  queueToSend.push_back(qItem);
}

/**\brief Adds new text to unsent queue 
 *
 * This function processes the text, received as first 
 * argument of the `q' command from the emacspeak 
 * and adds corresponding items to unsent text queue.
 *
 * \param text The text to process
 */
void addToQueue(const std::string& text)
{
  bool wasParameterChanges = 0;
  std::string t = text, tt;
  removeDectalkCodes(t);
  for(unsigned int i=0;i<t.length();i++)
    {
      if (t[i] == '<')
	{
	  wasParameterChanges = 1;
	  if (!trim(tt).empty())
	    {
	      QUEUEITEM qItem(QUEUE_ITEM_TEXT);
	      qItem.stringArgument = tt;
	      queueToSend.push_back(qItem);
	      tt.erase();
	    }
	  std::string tmp;
	  i++;
	  while(i < t.length() && t[i] != '>')
	    tmp += t[i++];
	  processSpeechParamString(tmp);
	  continue;
	}
      tt += t[i];
    }
  if (!trim(tt).empty())
    {
      QUEUEITEM qItem(QUEUE_ITEM_TEXT);
      qItem.stringArgument = tt;
      queueToSend.push_back(qItem);
    }
  if (wasParameterChanges)
    addRestoringItems();
}

/**\brief Transmits current queue content to a server*/
void sendQueue()
{
  std::list<QUEUEITEM>::iterator it;
  for(it = queueToSend.begin();it!=queueToSend.end();it++)
    {
      switch(it->type)
	{
	case QUEUE_ITEM_TEXT:
	  text(it->stringArgument);
	  break;
	case QUEUE_ITEM_PITCH:
	  vm_pitch(con, it->integerArgument);
	  break;
	default:
	  assert(0);
	} //switch();
    } //for();
  queueToSend.clear();
}

/**\brief Processes parsed line of emacspeak protocol
 *
 * \param [in] line The line to process
 */
void handleEspeakLine(const ESPEAKLINE& line)
{
  if (line.cmd == "l")
    {
      if (line.params.size()==0)
	return;
      if (line.params[0].empty())
	return;
      letter(line.params[0]);
      return;
    }
  if (line.cmd == "q")
    {
      if (line.params.size() == 0)
	return;
      addToQueue(line.params[0]);
      return;
    }
  if (line.cmd == "s")
    {
      stop();
      queueToSend.clear();
      return;
    }
  if (line.cmd == "d")
    {
      sendQueue();
      return;
    }
  if (line.cmd == "tts_say")
    {
      if (line.params.size() == 0)
	return;
      std::string tt=line.params[0];
      removeDectalkCodes(tt);
      text(tt);
      return;
    }
  if (line.cmd == "t")
    {
      if (line.params.size() < 2)
	  return;
      if (!checkTypeUnsignedInt(line.params[0]))
	return;
      if (!checkTypeUnsignedInt(line.params[1]))
	return;
      tone(parseAsUnsignedInt(line.params[0]), parseAsUnsignedInt(line.params[1]));
      return;
    }
  //FIXME:punctuations;
}

/**\brief Processes received text line
 *
 * \param [in] line The line to process
 */
void handleLine(const std::string& line)
{
  if (line.empty())
    return;
  printToLog(line);//KILLME:
  splitEspeakLine(line, currentESpeakLine);
  if (currentESpeakLine.brLevel > 0)
    return;
  handleEspeakLine(currentESpeakLine);
}

/**\brief Reads protocol input
 **
 * \param [in] file The file handler to read data from
 */
void readInput(int file)
{
  std::string line;
  while(1)
    {
      char buf[2048];
      int readCount;
      readCount = read(file, buf, sizeof(buf));
      if (readCount < 0)
	{
	  perror("read()");
	  return;
	}
      if (readCount==0)
	return;
      int i;
      for(i=0;i<readCount;i++)
	{
	  if (buf[i]==10)
	    {
	      handleLine(line);
	      line.erase();
	      continue;
	    }
	  if (buf[i] == 13)
	    continue;
	  line+=buf[i];
	}
    }
}

/**\brief The main entry point*/
int main(int argc, char *argv[])
{
  for(int k=1;k<argc;k++)
    {
      std::string param=argv[k];
      if (trim(param)=="--help" || trim(param)=="-h")
	{
	  using namespace std;
	  cout << "VoiceMan client for Emacspeak." << endl;
	  cout << "Parameters:" << endl;
	  cout << "-h, --help - print this help screen;" << endl;
	  cout << "-t, --test - perform connection test." << endl;
	  return 0;
	}
      if (trim(param)=="--test" || trim(param)=="-t")
	{
	  std::cout << "Testing..." << std::endl;
	  tone(220, 150);
	  tone(220, 150);
	  tone(220, 150);
	  text("Performing client test...");
	  tone(220, 150);
	  tone(220, 150);
	  tone(220, 150);
	  return 0;
	}
    }
  readInput(0);
  vm_close(con);
  return 0;
}
