
#ifndef __VOICEMAN_CONFIG_FILE_SECTION_H__
#define __VOICEMAN_CONFIG_FILE_SECTION_H__

/**\brief The class to store complete information about configuration file section*/
class ConfigFileSection: public std::map<std::string, std::string>
{
public:
  /**\brief The default constructor*/
  ConfigFileSection() {}

  /**\brief The constructor with configuration file section name specification
   *
   * \param [in] name The name of new configuration file section
   */
  ConfigFileSection(const std::string& name)
    : m_name(name) {}

  /**\brief The destructor*/
  virtual ~ConfigFileSection() {}

  /**\brief Returns configuration file section name*/
  std::string getName() const 
  {
    return m_name;
  }

  /**\brief Sets new configuration file section name
   *
   * \param [in] name The name to set
   */
  void setName(const std::string& name)
  {
    m_name=name;
  }

  /**\brief Checks if the section has specified parameter
   *
   * \param [in] name The name of parameter to check
   */
  bool has(const std::string& name) const 
  {
    return find(name) != end();
  }

  /**\brief Adds new parameter and its value to the section
   *
   * \param [in] param The name of the parameter to add
   * \param [in] value The value of the parameter to add
   */
  void add(const std::string& param, const std::string& value)
  {
    insert(value_type(param, value));
  }

  /**\brief Returns parameter value
   *
   * \param [in] name The name of an existing parameter to get value of
   */
  std::string operator [](const std::string& name) const
  {
    const_iterator it=find(name);
    assert(it!=end());
    if (it == end())
      return "";
    return it->second;
  }

private:
  std::string m_name;
}; // class ConfigFileSection;

typedef std::vector<ConfigFileSection> ConfigFileSectionVector;
typedef std::list<ConfigFileSection> ConfigFileSectionList;

#endif //__VOICEMAN_CONFIG_FILE_SECTION_H__
