
#ifndef __VOICEMAN_DELIMITED_FILE_H__
#define __VOICEMAN_DELIMITED_FILE_H__

/**\brief The class to parse file with colon-delimited lines*/
class DelimitedFile
{
public:
  /**\brief Reads data from file and stores it
   *
   * \param [in] fileName The name of file to read data from
   */
  void read(const std::string& fileName);
  /**\brief The number of non-empty and non-commented lines read from source file*/
  size_t getLineCount() const;
  /**\brief Returns text file line without any translations
   *
   * \param [in] index The number of a line to return
   */
  std::string getRawLine(size_t index) const;

  /**\brief Returns the number of delimited items in specified line
   *
   * \param [in] index The number of a line to count items in
   */
  size_t getItemCountInLine(size_t line) const;

  /**\brief Returns the required delimited item in required line
   *
   * \param [in] line The number of desired line
   * \param [in] itemIndex The number of desired item in specified line
   */
  std::string getItem(size_t line, size_t itemIndex) const;

private:
  StringVector m_lines;
}; //class DelimitedFile;

#endif //__VOICEMAN_DELIMITED_FILE_H__
