/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_CMD_ARGS_PARSER_H__
#define __LOPSUS_CMD_ARGS_PARSER_H__

//Taken from voiceman at 2009-05-27;

struct CMDARG
{
  char shortName;
  const char* longName;
  const char* param;
  const char*descr;
}; //struct CMDARG;

class CmdArgsParser
{
public:
  CmdArgsParser(CMDARG* allParams);

  void printHelp() const;
  bool used(const std::string& name) const;
  const std::string operator [](const std::string& name) const;
  bool parse(int argc, char* argv[]);

public:
  const std::vector<std::string>& files;

private:
  struct USEDPARAM
  {
    USEDPARAM() 
      : hasValue(0) {}

    std::string name, value;
    bool hasValue;
  }; //struct USEDPARAM;

  typedef std::vector<USEDPARAM> UsedParamVector;

private:
  size_t identifyParam(char* p) const;

private:
  typedef std::vector<std::string> StringVector;

  StringVector m_files;
    UsedParamVector m_usedParams;
    CMDARG* m_availableParams;
  size_t m_availableParamCount;
}; // class Cmdargs;

#endif //__LOPSUS_CMD_ARGS_PARSER_H__
