/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#include"lopsus.h"
#include"CommandProcessors.h"

bool DefaultCommandProcessor::getCommandValue(const String& commandName, String& value) const
{
  if (commandName == _T("No"))
    {
      value = _T("&#x2116;");
      return 1;
    }
  if (commandName == _T("today"))
    {
      DateTime dateTime;//must be current by default;
      value = dateTime.dateToHtml();
      return 1;
    }
  if (commandName == _T("todayrus"))
    {
      DateTime dateTime;//must be current by defaultr;
      value = dateTime.dateToHtmlRus();
      return 1;
    }
  return 0;
}

bool DefaultCommandProcessor::getCommandPlainValue(const String& commandName, String& value) const
{
  if (commandName == _T("No"))
    {
      value = _T("&#x2116;");
      return 1;
    }
  if (commandName == _T("today"))
    {
      DateTime dateTime;//must be current by default;
      value = dateTime.dateToString();
      return 1;
    }
  if (commandName == _T("todayrus"))
    {
      DateTime dateTime;//must be current by defaultr;
      value = dateTime.dateToStringRus();
      return 1;
    }
  return 0;
}

bool DefaultCommandProcessor::isDirective(const String& value) const
{
  if (value == _T("lastnews"))
    return 1;
  if (value == _T("newslist"))
    return 1;
  if (value == _T("hr"))
    return 1;
  return 0;
}

