/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_COMMAND_PROCESSORS_H__
#define __LOPSUS_COMMAND_PROCESSORS_H__

class CommandProcessor
{
public:
  virtual ~CommandProcessor() {}

  virtual bool getCommandValue(const String& commandName, String& value) const = 0;
  virtual bool getCommandPlainValue(const String& commandName, String& value) const = 0;
  virtual bool isDirective(const String& value) const = 0;
}; //class CommandProcessor;

class DefaultCommandProcessor: public CommandProcessor
{
public:
  virtual ~DefaultCommandProcessor() {}

  bool getCommandValue(const String& commandName, String& value) const;
  bool getCommandPlainValue(const String& commandName, String& value) const;
  bool isDirective(const String& value) const;
}; //class DefaultCommandProcessor;

#endif //__LOPSUS_COMMAND_PROCESSORS_H__;
