/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_CONFIG_FILE_H__
#define __LOPSUS_CONFIG_FILE_H__

#define DEFAULT_LAST_NEWS_COUNT 5

#define INDENT_DEFAULT_BEFORE_TITLE 4
#define INDENT_DEFAULT_TITLE 6
#define INDENT_DEFAULT_BEFORE_HEADER 4
#define INDENT_DEFAULT_HEADER 6
#define INDENT_DEFAULT_BEFORE_MENU 4
#define INDENT_DEFAULT_MENU 12
#define INDENT_DEFAULT_BEFORE_CONTENT 6
#define INDENT_DEFAULT_CONTENT 8
#define INDENT_DEFAULT_BEFORE_FOOTER 4
#define INDENT_DEFAULT_FOOTER 6
#define INDENT_DEFAULT_FINAL 4

class ConfigFile
{
public:
  ConfigFile()
    : pagesDir(_T("pages")), outputDir(_T("output")), lastNewsCount(DEFAULT_LAST_NEWS_COUNT),
    indentBeforeTitle(INDENT_DEFAULT_BEFORE_TITLE), indentTitle(INDENT_DEFAULT_TITLE), indentBeforeHeader(INDENT_DEFAULT_BEFORE_HEADER), indentHeader(INDENT_DEFAULT_HEADER),
    indentBeforeMenu(INDENT_DEFAULT_BEFORE_MENU), indentMenu(INDENT_DEFAULT_MENU), indentBeforeContent(INDENT_DEFAULT_BEFORE_CONTENT), indentContent(INDENT_DEFAULT_CONTENT),
    indentBeforeFooter(INDENT_DEFAULT_BEFORE_FOOTER), indentFooter(INDENT_DEFAULT_FOOTER), indentFinal(INDENT_DEFAULT_FINAL) {}

  bool parse(const String& fileName, String& errorMessage);
  void print();

public:
  String pageTitlePrefix;
  String pagesDir;
  String outputDir;
  String headerFile;
  String footerFile;
  String menuFile;
  String addToHtmlHead;
  String newsSourceDir;
  String newsDir;
  size_t lastNewsCount;
  size_t indentBeforeTitle, indentTitle, indentBeforeHeader, indentHeader, indentBeforeMenu;
  size_t indentMenu, indentBeforeContent, indentContent, indentBeforeFooter, indentFooter, indentFinal;
}; //class ConfigFile;

#endif //__LOPSUS_CONFIG_FILE_H__
