/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#include"lopsus.h"
#include"ContentFile.h"

#define COMMENT_CHAR(x) ((x) == _T('#'))

class ContentFileIterator
{
public:
  ContentFileIterator(std::istream& stream)
    : m_stream(stream), m_line(0) {}

  size_t getLineNumber() const
  {
    return m_line;
  }

  bool next(StringList& values)
  {
    values.clear();
    std::string ss;
    for(m_line++;readNextLine(ss);m_line++)
      {
	String s = IO2String(ss);
	s = trim(s);
	if (s.empty())
	  continue;
	if (COMMENT_CHAR(s[0]))
	  continue;
	String value;
	for(std::string::size_type pos = 0;pos < s.length();pos++)
	  {
	    if (COMMENT_CHAR(s[pos]))
	      break;
	    if (s[pos] == _T('\\'))
	      {
		if (pos + 1 >= s.length())
		  value += '\\'; else
		  value += s[pos + 1];
		pos++;
		continue;
	      } //backslash;
	    if (s[pos] == _T(':'))
	      {
		values.push_back(value);
		value.erase();
		continue;
	      }
	  value += s[pos];
	  } //for();
	values.push_back(value);
	return 1;
      } //while();
    return 0;
  }

private:
  bool readNextLine(std::string& value)
  {
    char c;
    value.erase();
    while(m_stream.get(c))
      {
	if (c == '\r')
	  continue;
	if (c == '\n')
	  return 1;
	value += c;
      }
      return !value.empty();
  }

private:
  std::istream& m_stream;
  size_t m_line;
}; //class ConfigFileIterator;

bool readContentFile(const String& fileName, ContentFileRecordVector& records, String& errorMessage)
{
  std::ifstream is(String2IO(fileName).c_str());
  if (!is)
    {
      errorMessage = fileName + _T(":file is not accessible for reading");
      return 0;
    }
  ContentFileIterator it(is);
  StringList items;
  while(it.next(items))
    {
      if (items.size() != 4)
	{
	  OStringStream ss;
	  ss << fileName << _T("(") << it.getLineNumber() << _T("):invalid number of items in line (") << items.size() << _T(" != 4)");
	  errorMessage = ss.str();
	  return 0;
	}
      ContentFileRecord rec;
      rec.sourceFile = trim(items.front());
      items.pop_front();
      rec.targetFile = trim(items.front());
      items.pop_front();
      rec.shortTitle = trim(items.front());
      items.pop_front();
      rec.title = trim(items.front());
      items.pop_front();
      assert(items.empty());
      if (rec.sourceFile.empty())
	{
	  OStringStream ss;
	  ss << fileName << _T("(") << it.getLineNumber() << _T("):source file name is missed");
	  errorMessage = ss.str();
	  return 0;
	}
      if (rec.targetFile.empty())
	{
	  OStringStream ss;
	  ss << fileName << _T("(") << it.getLineNumber() << _T("):target file name is missed");
	  errorMessage = ss.str();
	  return 0;
	}
      records.push_back(rec);
    } //while(lines);
  return 1;
}
