/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_CONTENT_FILE_H__
#define __LOPSUS_CONTENT_FILE_H__

struct ContentFileRecord
{
  ContentFileRecord() {}

  ContentFileRecord(const String& sf, const String& tf, const String& st, const String& t)
    : sourceFile(sf), targetFile(tf), shortTitle(st), title(t) {}

  String sourceFile;
  String targetFile;
  String shortTitle;
  String title;
}; //struct ContentFileRecord;

typedef std::vector<ContentFileRecord> ContentFileRecordVector;
typedef std::list<ContentFileRecord> COntentFileRecordList;

bool readContentFile(const String& fileName, ContentFileRecordVector& records, String& errorMessage);

#endif //__LOPSUS_CONTENT_FILE_H__
