/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#include"lopsus.h"

#define RUS_MONTHES_FILE _T("rus_monthes")

static const char* engMonthes[] = {
  "January",
  "February",
  "March",
  "April",
  "May",
  "June",
  "July",
  "August",
  "September",
  "October",
  "November",
  "December"
};

StringVector rusMonthes;

bool DateTime::operator <(const DateTime& d) const
{
  if (year < d.year)
    return 1;
  if (year > d.year)
    return 0;
  if (month < d.month)
    return 1;
  if (month > d.month)
    return 0;
  if (day < d.day)
    return 1;
  if (day > d.day)
    return 0;
  if (hour < d.hour)
    return 1;
  if (hour > d.hour)
    return 0;
  if (min < d.min)
    return 1;
  if (min > d.min)
    return 0;
  if (sec < d.sec)
    return 1;
  return 0;
}

bool DateTime::operator >(const DateTime& d) const
{
  if (year < d.year)
    return 0;
  if (year > d.year)
    return 1;
  if (month < d.month)
    return 0;
  if (month > d.month)
    return 1;
  if (day < d.day)
    return 0;
  if (day > d.day)
    return 1;
  if (hour < d.hour)
    return 0;
  if (hour > d.hour)
    return 1;
  if (min < d.min)
    return 0;
  if (min > d.min)
    return 1;
  if (sec > d.sec)
    return 1;
  return 0;
}



String DateTime::dateToHtml() const
{
  std::ostringstream ss;
  assert(month >= 1 && month <= 12);
  ss << engMonthes[month - 1] << "&nbsp;" << day << ",&nbsp;" << year;
  return readUTF8(ss.str());
}

String DateTime::dateToHtmlRus() const
{
  OStringStream ss;
  assert(rusMonthes.size() == 13);
  assert(month >= 1 && month <= 12);
  ss << day << _T("&nbsp;") << rusMonthes[month] << _T("&nbsp;") << year << _T("&nbsp;г.");
  return ss.str();
}

String DateTime::dateToString() const
{
  std::ostringstream ss;
  assert(month >= 1 && month <= 12);
  ss << engMonthes[month - 1] << " " << day << ", " << year;
  return readUTF8(ss.str());
}

String DateTime::dateToStringRus() const
{
  OStringStream ss;
  assert(rusMonthes.size() == 13);
  assert(month >= 1 && month <= 12);
  ss << day << _T(" ") << rusMonthes[month] << _T(" ") << year << _T(" г.");
  return ss.str();
}

void DateTime::now()
{
  time_t t;
  time(&t);
  struct tm *br_time = localtime(&t);
  year = br_time->tm_year + 1900;
  month = br_time->tm_mon + 1;
  day = br_time->tm_mday;
  hour = br_time->tm_hour;
  min = br_time->tm_min;
  sec = br_time->tm_sec;
}

void loadRusMonthesConstants()
{
  const String fileName = concatUnixPath<String>(IO2String(LOPSUS_DATADIR), RUS_MONTHES_FILE);
  const std::string text = readTextFile(fileName);
  splitTextFileLines(readUTF8(text), rusMonthes, 1, 1);
  if (rusMonthes.size() != 13)
    LOPSUS_ERROR("Russian monthes constant file has an invalid content");
}
