/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_DATETIME_H__
#define __LOPSUS_DATETIME_H__

class DateTime
{
public:
  DateTime()
  {
    now();
  }

  size_t year, month, day, hour, min, sec;

public:
  bool operator <(const DateTime& d) const;
  bool operator >(const DateTime& d) const;
  String dateToHtml() const;
  String dateToHtmlRus() const;
  String dateToString() const;
  String dateToStringRus() const;
  void now();
}; //class DateTime;

void loadRusMonthesConstants();

#endif //__LOPSUS_DATETIME_H__
