/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_EXCEPTION_H__
#define __LOPSUS_EXCEPTION_H__

class LopsusException
{
public:
  LopsusException(const std::string& message)
    : m_message(message) {}

  virtual ~LopsusException() {}

  std::string getMessage() const
  {
    return m_message;
  }

private:
  const std::string m_message;
}; //class LopsusException;

#define LOPSUS_ERROR(x) throw LopsusException(x)

#endif //__LOPSUS_EXCEPTION_H__
