/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_PAGE_H__
#define __LOPSUS_PAGE_H__

#include"news.h"

class PageItem
{
public:
  enum {Text = 0, Header = 1, Enum = 2, OrderedEnum = 3};

  PageItem() 
    : type(Text), level(1) {}

  PageItem(int t)
    : type(t), level(1) {}

  PageItem(int t, const String& s)
    : type(t), text(s), level(1) {}

  int type;
  String text;
  size_t level;
}; //class PageItem;

typedef std::vector<PageItem> PageItemVector;
typedef std::list<PageItem> PageItemList;

class LopsusPage
{
public:
  LopsusPage(size_t lastNewsMaxCount = 5)
    : m_lastNewsMaxCount(lastNewsMaxCount) {}

  String translate(const String& source, const NewsVector& news, size_t desiredIndent = 0);

private:
  void splitItems(const StringVector& lines);
  void addEmptyLine();
  void addHeaderLine(const String& text);
  void addEnumLine(const String& text);
  void addOrderedEnumLine(const String& text);
  void addDefLine(const String& text);
  String generateLastNews(size_t indent, const NewsVector& news) const;
  String generateNewsList(size_t indent, const NewsVector& news) const;
  String formatNewsItem(const NewsItem& newsItem, bool withBriefContent, const String& linkUrl) const;
  bool processDirectives(String& text, const StringList& directives, size_t currentIndent, const NewsVector& newsV) const;

private:
  const size_t m_lastNewsMaxCount;
  bool m_wasEmptyLine;
  PageItemList m_pageItems;

}; //class LopsusPage;

#endif //__LOPSUS_PAGE_H__
