/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#include"lopsus.h"
#include"LopsusText.h"

#define MAX_LINE_LEN 85

void LopsusText::translate()
{
  m_output.clear();
  for(m_i = 0;m_i < m_source.length();m_i++)
    {
      const Char ch = m_source [m_i];
      if (BLANK_CHAR(ch))
	{
	  if (m_line.length() > MAX_LINE_LEN)
	    {
	      m_output.push_back(trim(m_line));
	      m_line.erase();
	      continue;
	    } //if m_line too long;
	  if (!m_line.empty() && !BLANK_CHAR(m_line[m_line.length() - 1]))
	    m_line += _T(' ');
	  continue;
	} //blank char;
      if (ch == _T('\\'))
	processEscapedSequence(0); else//0 means not plain;
      if (checkNow(_T("[[")))
	{
	  m_i++;
	  processLink(1);//1 means external link;
	} else
      if (ch == _T('['))
	processLink(0); else //0 means not external link;
      if (checkNow(_T("]]")))
	{
	  m_line += _T("</a>");
	  m_i++;
	} else
      if (ch == _T(']'))
	m_line += _T("</a>"); else
      if (ch == _T('`'))
	processPlainText(); else
      if (checkNow(_T("---")))
	{
	  m_line += _T("&mdash;");
	  m_i += 2;
	} else
      if (checkNow(_T("--")))
	{
	  m_line += _T("&ndash;");
	  m_i++;
	} else
      if (ch == _T('~'))
	  m_line += _T("&nbsp;"); else
      if (ch == _T('&'))
	  m_line += _T("&amp;"); else
      if (ch == _T('\"'))
	  m_line += _T("&quot;"); else
      if (ch == _T('\''))
	  m_line += _T("&apos;"); else
      if (ch == _T('<'))
	  m_line += _T("&lt;"); else
      if (ch == _T('>'))
	  m_line += _T("&gt;"); else
      if (checkNow(_T("{{")))
	{
	  m_line += _T("<i>");
	  m_i++;
	} else
      if (ch == _T('{'))
	  m_line += _T("<b>"); else
      if (checkNow(_T("}}")))
	{
	  m_line += _T("</i>");
	  m_i++;
	} else
      if (ch == _T('}'))
	  m_line += _T("</b>"); else
      m_line += ch;
    } //for();
  if (!trim(m_line).empty())
    m_output.push_back(trim(m_line));
}

void LopsusText::translatePlain()
{
  m_output.clear();
  for(m_i = 0;m_i < m_source.length();m_i++)
    {
      const Char ch = m_source [m_i];
      if (BLANK_CHAR(ch))
	{
	  if (m_line.length() > MAX_LINE_LEN)
	    {
	      m_output.push_back(trim(m_line));
	      m_line.erase();
	      continue;
	    } //if m_line too long;
	  if (!m_line.empty() && !BLANK_CHAR(m_line[m_line.length() - 1]))
	    m_line += _T(' ');
	  continue;
	} //blank char;
      if (ch == _T('\\'))
	processEscapedSequence(1); else//1 means plain;
      if (ch == _T('['))
	{
	  if (checkNow(_T("[[")))
	    m_i++;
	  m_i++;
	  //skipping spaces before address;
	  while(m_i < m_source.length() && BLANK_CHAR(m_source[m_i]))
	    m_i++;
	  if (m_i >= m_source.length())
	    continue;
	  //skipping link address;
	  while(m_i < m_source.length() && !BLANK_CHAR(m_source[m_i]))
	    m_i++;
	  if (m_i >= m_source.length())
	    continue;
	  //skipping spaces after address;
	  while(m_i < m_source.length() && BLANK_CHAR(m_source[m_i]))
	    m_i++;
	  if (m_i >= m_source.length())
	    continue;
	  m_i--;
	} else
      if (checkNow(_T("]]")))
	{
	  m_i++;
	  continue;
	} else
      if (ch == _T(']'))
	continue; else
      if (ch == _T('`'))
	processPlainText(); else
      if (checkNow(_T("---")))
	{
	  m_line += _T("-");
	  m_i += 2;
	} else
      if (checkNow(_T("--")))
	{
	  m_line += _T("-");
	  m_i++;
	} else
      if (ch == _T('~'))
	  m_line += _T(" "); else
      if (ch == _T('&'))
	  m_line += _T("&amp;"); else
      if (ch == _T('\"'))
	  m_line += _T("&quot;"); else
      if (ch == _T('\''))
	  m_line += _T("&apos;"); else
      if (ch == _T('<'))
	  m_line += _T("&lt;"); else
      if (ch == _T('>'))
	  m_line += _T("&gt;"); else
      if (checkNow(_T("{{")))
	{
	  m_i++;
	} else
      if (ch == _T('{'))
	  continue; else
      if (checkNow(_T("}}")))
	{
	  m_i++;
	} else
      if (ch == _T('}'))
	  continue; else
      m_line += ch;
    } //for();
  if (!trim(m_line).empty())
    m_output.push_back(trim(m_line));
}

String LopsusText::processCommand(const String& commandName, bool plain)
{
  String value;
  if (plain)
    {
      if (!m_commandProcessor.getCommandPlainValue(commandName, value))
	return _T("#UNKNOWN COMMAND: ") + commandName + _T("#");
    } else 
    {
      if (!m_commandProcessor.getCommandValue(commandName, value))
	return _T("#UNKNOWN COMMAND: ") + commandName + _T("#");
    }
  return value;
}

void LopsusText::processEscapedSequence(bool plain)
{
  if (noMoreChars())
    {
      m_line += _T('\\');
      return;
    }
  m_i++;
  const Char nextChar = m_source[m_i];
  if ((nextChar >= _T('a') && nextChar <= _T('z')) || (nextChar >= _T('A') && nextChar <= _T('Z')))
    {
      String name;
      while(m_i < m_source.length() && m_source[m_i] != _T(';'))
	name += m_source[m_i++];
      if (m_commandProcessor.isDirective(trim(name)))
	directives.push_back(trim(name)); else
	m_line += processCommand(trim(name), plain);
    } else
    m_line += nextChar;
}

void LopsusText::processLink(bool external)
{
  m_i++;
  while(m_i < m_source.length() && BLANK_CHAR(m_source[m_i]))
    m_i++;
  if (m_i >= m_source.length())
    return;
  String addr;
  while(m_i < m_source.length() && !BLANK_CHAR(m_source[m_i]))
    addr += m_source[m_i++];
  if (external)
    m_line += _T("<a target=\"_blank\" href=\""); else
    m_line += _T("<a href=\"");
  m_line += addr;
  m_line += _T("\">");
  while(m_i < m_source.length() && BLANK_CHAR(m_source[m_i]))
    m_i++;
  if (m_i >= m_source.length())
    return;
  m_i--;//because of loop increment;
}

void LopsusText::processPlainText()
{
  m_i++;
  while(m_i < m_source.length() && (m_source[m_i] != _T('`') || m_source[m_i - 1] == _T('\\')))
    {
      if (m_source[m_i] == _T('\\'))
	{
	  m_i++;
	  if (m_i < m_source.length())
	    m_line += m_source[m_i]; else
	    m_line += _T("\\");
	  m_i++;
	  continue;
	} //backslash;
      m_line += m_source[m_i];
      m_i++;
    }
}

bool LopsusText::noMoreChars() const
{
  return m_i >= m_source.length() - 1;
}

bool LopsusText::checkNow(const String& strToCheck) const
{
  if (strToCheck.length() + m_i > m_source.length())
    return 0;
  for(String::size_type i = 0;i < strToCheck.length();i++)
    if (m_source[m_i + i] != strToCheck[i])
      return 0;
  return 1;
}
