/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_TEXT_H__
#define __LOPSUS_TEXT_H__

#include"CommandProcessors.h"

class LopsusText 
{
public:
  LopsusText(const String& source, StringList& output, const CommandProcessor& commandProcessor)
    : m_source(source), m_output(output), m_i(0), m_commandProcessor(commandProcessor) {}

  void translate();
  void translatePlain();

public:
  StringList directives;

private:
  String processCommand(const String& commandName, bool plain);

  void processEscapedSequence(bool plain);
  void processLink(bool external);
  void processPlainText();

private:
  bool noMoreChars() const;
  bool checkNow(const String& strToCheck) const;

private:
  const String& m_source;
  StringList& m_output;
  String::size_type m_i;
  const CommandProcessor& m_commandProcessor;
  String m_line;
}; //class LopsusText;

#endif //__LOPSUS_TEXT_H__
