/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_SYSTEM_EXCEPTION_H__
#define __LOPSUS_SYSTEM_EXCEPTION_H__

class SystemException
{
public:
  SystemException(): m_code(errno) {}
  SystemException(const std::string& comment): m_code(errno), m_comment(comment) {}
  SystemException(int code): m_code(code) {}
  SystemException(int code, const std::string& comment): m_code(code), m_comment(comment) {}
  virtual ~SystemException() {}

  int getCode() const
  {
    return m_code;
  }

  std::string getDescr() const
  {
    return strerror(m_code);
  }

  std::string getComment() const
  {
    return m_comment;
  }

  std::string getMessage() const
  {
    return getComment()+":"+getDescr();
  }

private:
  int m_code;
  std::string m_comment;
}; //class SystemException;

#define LOPSUS_SYS(expr, msg) if (!(expr)) throw SystemException(msg)

#endif //__LOPSUS_SYSTEM_EXCEPTION_H__
