/*
	Copyright (c) 2000-2009 Michael Pozhidaev<msp@altlinux.org>
   This file is part of the Lopsus website generator.

   Lopsus website generator is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   Lopsus website generator is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
*/

#ifndef __LOPSUS_H__
#define __LOPSUS_H__

#include"system.h"
#include"SystemException.h"
#include"LopsusException.h"
#include"Transcoding.h"
#include"string-utils.h"
#include"CmdArgsParser.h"

using std::auto_ptr;

typedef std::wstring String;
typedef wchar_t Char ;
#define _T(x) L ## x

typedef std::wostringstream OStringStream;
typedef std::list<String> StringList;
typedef std::vector<String> StringVector;

typedef std::vector<bool> BoolVector;

#include"DateTime.h"

//some utils;

template<class TStr>
TStr htmlEscapeString(const TStr& text)
{
  TStr s;
  for(typename TStr::size_type i = 0;i < text.length();i++)
    {
      if (text[i] == '&')
	s += adjust<TStr>("&amp;"); else
      if (text[i] == '\'')
	s += adjust<TStr>("&apos;"); else
      if (text[i] == '\"')
	s += adjust<TStr>("&quot;"); else
      if (text[i] == '<')
	s += adjust<TStr>("&lt;"); else
      if (text[i] == '>')
	s += adjust<TStr>("&gt;"); else 
	s += text[i];
    } //for();
  return s;
}

template<class TStr>
TStr shiftString(const TStr& source, size_t offset)
{
  TStr s;
  for(size_t i = 0;i < offset;i++)
    s += ' ';
  for(typename TStr::size_type i = 0;i < source.length();i++)
    {
      s += source[i];
      if (source[i] == '\n')
	for(size_t j = 0;j < offset;j++)
	  s += ' ';
    } //for();
  typename TStr::size_type lastNonSpace = 0;
  for(typename TStr::size_type i = 0;i < s.length();i++)
    if (s[i] != ' ')
      lastNonSpace = i;
  s.resize(lastNonSpace + 1);
  return s;
}

template<class TStr>
bool stringEnds(const TStr& str, const TStr& end)
{
  if (end.length() > str.length())
    return 0;
  for(typename TStr::size_type i = 0;i < end.length();i++)
    if (end[i] != str[str.length() - end.length() + i])
      return 0;
  return 1;
}

template<class TStr, class TList>
void splitTextFileLines(const TStr& text, TList& lines, bool trimLines, bool skipEmpty)
{
  TStr s;
  lines.clear();
  for(typename TStr::size_type i = 0;i < text.length();i++)
    {
      if (text[i] == '\r')
	continue;
      if (text[i] == '\n')
	{
	  if (trimLines)
	    s = trim(s);
	  if (!skipEmpty || !s.empty())
	    lines.push_back(s);
	  s.erase();
	  continue;
	}
      s += text[i];
    } //for(text[i]);
  if (trimLines)
    s = trim(s);
  if (!skipEmpty && !s.empty())
    lines.push_back(s);
}

void lopsusWarning(const std::string&message);

std::string readTextFile(const String& fileName);
void saveText(const String& fileName, const std::string toSave);
void ensureDirExists(const String& fileName);
void copyDirContent(const String& fromDir, const String& toDir);
void getDirContent(const String& dirName, StringList& content, bool noDirs = 0);

#endif //__LOPSUS_H__
