/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __PTRS_H__
#define __PTRS_H__

class vm_class
{
public:
  vm_class() : m_refs(0) {};
  virtual ~vm_class() {};
  uint m_refs;
}; // class vm_class;

void intrusive_ptr_add_ref(vm_class *p);
void intrusive_ptr_release(vm_class *p);

#include<boost/intrusive_ptr.hpp>
#define vm_ptr boost::intrusive_ptr

#endif //__PTRS_H__
