/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VOICEMAN_VM_H__
#define __VOICEMAN_VM_H__

#ifdef __cplusplus 
#define EXTC extern "C"
#else
#define EXTC extern
#endif // __cplusplus

typedef int vm_connection_t;
#define VOICEMAN_BAD_CONNECTION -1

typedef int vm_result_t;
#define VOICEMAN_ERROR -1
#define VOICEMAN_OK 0
EXTC vm_connection_t vm_connect();
EXTC vm_connection_t vm_connect_unix(const char* path);
EXTC vm_connection_t vm_connect_inet(const char* host, int port);
EXTC void vm_close(vm_connection_t con);

EXTC vm_result_t vm_text(vm_connection_t con, const char* text); 
EXTC vm_result_t vm_stop(vm_connection_t con);
EXTC vm_result_t vm_letter(vm_connection_t con, const char* letter);
EXTC vm_result_t vm_tone(vm_connection_t con, int freq, int lengthms);
EXTC vm_result_t vm_pitch(vm_connection_t con, int value);
EXTC vm_result_t vm_rate(vm_connection_t con, int value);
EXTC vm_result_t vm_volume(vm_connection_t con, int value);


#endif //__VOICEMAN_VM_H__
