/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"

extern uint vm_all_param_count;
extern vm_cmd_arg vm_all_params[];

class vm_used_param
{
public:
  vm_used_param() : m_has_value(0) {};
  vm_string m_name, m_value;
  bool m_has_value;
};

static vector<vm_used_param> used_params;

void print_cmd_args_help()
{
  vector<vm_string> keys;
  uint i;

  for(i=0;i<vm_all_param_count;i++)
    {
      vm_string s;
      bool has_param = !vm_string(vm_all_params[i].param).empty();
      s = WSTR("  -");
      s += vm_all_params[i].short_name;
      if (has_param)
	{
	  s += WSTR(" ");
	  s += vm_all_params[i].param;
	}
      s += WSTR(", --");
      s += vm_all_params[i].long_name;
      if (has_param)
	{
	  s += WSTR(" ");
	  s += vm_all_params[i].param;
	}
      keys.push_back(s);
    }

  uint l=0;
  for(i=0;i<keys.size();i++)
    if (l < keys[i].length())
      l = keys[i].length();
  for(i=0;i<vm_all_param_count;i++)
    {
      uint j;
      using namespace std;
      vm_string descr = vm_all_params[i].descr;
      cout << keys[i];
      for(j=keys[i].length();j<l;j++)
	cout << " ";
      cout << " - " << descr << endl;
    }
}

bool is_used_cmd_param(const vm_string &name)
{
  uint i;
  for(i=0;i<used_params.size();i++)
    if (used_params[i].m_name == name)
      return 1;
  return 0;
}

vm_string get_cmd_param_value(const vm_string &name)
{
  uint i;
  for(i=0;i<used_params.size();i++)
    {
      if (used_params[i].m_name != name)
	continue;
      if (!used_params[i].m_has_value)
	VM_STOP("There is no value in requested command line argument.");
      return used_params[i].m_value;
    }
  VM_STOP("Requesting value of non-specified command line parameter.");
}

static int identify_param(char *p)
{
  vm_string s=io2vm_string(p);
  if (s.length() < 2)
    return -1;
  if (s[0] != WSTR('-'))
    return -1;
  if (s[1] != WSTR('-'))
    {
      if (s.length() != 2)
	return -1;
      uint i;
      for(i=0;i<vm_all_param_count;i++)
	if (s[1] == vm_all_params[i].short_name)
	  return i;
      return -1;
    }

  uint i;
  vm_string ss;
  for(i=2;i<s.length();i++)
    ss += s[i];
  for(i=0;i<vm_all_param_count;i++)
    {
      vm_string long_name=vm_all_params[i].long_name;
      if (ss == long_name)
	return i;
	}
  return -1;
}

bool parse_cmd_line(int argc, char *argv[])
{
  using namespace std;
  if (argc < 1)
    {
      cerr << "ERROR: Too few arguments in argv[] array." << endl;
      return 0;
    }
  uint i;
  for(i=1;i<argc;i++)
    {
      int p=identify_param(argv[i]);
      if (p < 0)
	{
	  cerr << "ERROR: There is an unexpected command line argument \"" << argv[i] << "\"." << endl;
	  return 0;
	}
      vm_used_param up;
      up.m_name=vm_all_params[p].long_name;
      if (vm_all_params[p].param[0])
	{
	  if (i+1 >= argc)
	    {
	      cerr << "ERROR: Argument \"" << argv[i] << "\" requires a value but it is last item in command line. Be careful." << endl;
	      return 0;
	    }
	  i++;
	  up.m_value=io2vm_string(argv[i]);
	  up.m_has_value=1;
	}

      used_params.push_back(up);
    }
  return 1;
}
