/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"clients.h"

int config_maxclients=0;

bool vm_client::accept(int s)
{
  if (m_opened)
    VM_STOP("Client is already opened.");

  int r=::accept(s, NULL, NULL);
  if (r==-1)
    return 0;
  m_sock=r;
  m_opened=1;
  return 1;
}

int vm_dispatch_loop::run(std::list<vm_socket::ptr> &to_listen)
{
  list<vm_client::ptr> clients;

  while(1)
    {
      fd_set fds;
      list<vm_socket::ptr>::iterator sock;
      list<vm_client::ptr>::iterator client;
      int max_fd = 0;
      FD_ZERO(&fds);

      for(sock=to_listen.begin();sock!=to_listen.end();sock++)
	{
	  int fd=(*sock)->get_fd();
	  if (fd > max_fd)
	    max_fd=fd;
	  FD_SET(fd, &fds);
	}

      for(client=clients.begin();client!=clients.end();client++)
	{
	  int fd=(*client)->get_fd();
	  if (fd > max_fd)
	    max_fd=fd;
	  FD_SET(fd, &fds);
	}

      VM_SYS(select(max_fd+1, &fds, NULL, NULL, NULL) != -1, "select()");
      bool was_new_clients=0;
      for(sock=to_listen.begin();sock!=to_listen.end();sock++)
	{
	  int fd=(*sock)->get_fd();
	  if (!FD_ISSET(fd, &fds))
	    continue;
	  was_new_clients=1;
	  vm_client::ptr c(new vm_client());
	  if (!c->accept(fd))
	    vmlog << vmerror << WSTR("There was new client but connection could not be accepted.") << vmendl; else
	      {
		if (config_maxclients == 0 || clients.size() < config_maxclients)
		  clients.push_back(c); else
		    vmlog << vmwarn << WSTR("Too many clients.  Rejecting new connection.") << vmendl;
	      }
	  vmlog << vminfo << WSTR("New client accepted.") << vmendl;
	}
      if (was_new_clients)
	continue;

      for(client=clients.begin();client!=clients.end();client++)
	{
	  int fd=(*client)->get_fd();
	  if (!FD_ISSET(fd, &fds))
	    continue;
	  string data;
	  if (!(*client)->read(data))
	    {
	      (*client)->close();
	      clients.erase(client);
	      vmlog << vminfo << WSTR("Closing connection.") << vmendl;
	      break;
	    } // closing connection

	  handle_data(decode_utf8(data), *client);
	} // for clients
    } // Endless loop for connections handling.
  return 0;
}
