/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __CLIENTS_H__
#define __CLIENTS_H__

extern int config_maxclients;

class vm_client : public vm_socket
{
public:
  typedef vm_ptr<vm_client> ptr;
  vm_client(): m_rejecting(0) {};
  virtual ~vm_client() {};
  bool accept(int s);
  vm_string m_chain;
  vm_param m_volume, m_pitch, m_rate;
  bool m_rejecting;
};

class vm_dispatch_loop
{
public:
  vm_dispatch_loop() {};
  virtual ~vm_dispatch_loop() {};
  virtual void handle_data(const vm_string &str, vm_client::ptr client) = 0;
  int run(std::list<vm_socket::ptr> &to_listen);
}; // class vm_dispatch_loop;

#endif // __CLIENTS_H__
