/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __COMMAND_H__
#define __COMMAND_H__

#include"confparse.h"
#include"player.h"

class vm_command_player : public vm_player
{
public:
  typedef vm_ptr<vm_command_player> ptr;
  vm_command_player() : m_volume_format(2), m_min_volume(0), m_max_volume(1), m_pitch_format(2), m_min_pitch(0), m_max_pitch(1), m_rate_format(2), m_min_rate(0), m_max_rate(1), m_pg(0) {};
  virtual ~vm_command_player() {stop();};
  virtual void play(const vm_string &text, vm_param volume, vm_param pitch, vm_param rate, const std::vector<bool> &cap_mask);
  virtual void stop();
  virtual bool processing() const;
  bool init(vm_conf_parser::section &s);
private:
  vm_string lower_case(const vm_string& s) const;
  vm_string upper_case(const vm_string& s) const;
  vm_string chars() const;
  vm_string prepare_cmd_line(vm_param volume, vm_param pitch, vm_param rate) const;
  vm_string prepare_value(vm_param value, uint format, float min, float max) const;
  void make_caps(vm_string &text, const std::vector<bool> &cap_mask) const;
  void init_cap_map(const vm_string& s);

private:
  hash_map<vm_char, vm_string> m_cap_map;
  vm_string m_cmd_line;
  double m_min_volume, m_max_volume, m_min_pitch, m_max_pitch, m_min_rate, m_max_rate;
  uint m_volume_format, m_pitch_format, m_rate_format;
  int m_pg;
};

#endif // __VMPLAYERS_H__
