/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"langs.h"
#include"conf.h"

class vm_file_reader 
{
 public:
  vm_file_reader() {};
  virtual ~vm_file_reader() {};
  int run(const vm_string &file_name)
    {
      string s;
      m_lines.clear();
      if (!read_text_file(vm_string2io(file_name), s))
	return -1;
      string ss;
      s+=10;
      int i, c=1;
      for(i=0;i<s.length();i++)
	{
	  if (s[i]==13)
	    continue;
	  if (s[i]==10)
	    {
	      vm_string ns;
	      if (!decode1_utf8(ss, ns))
		return c;
	      c++;
	      ns=ns.trim();
	      if (!ns.empty() && ns[0] != WSTR('#'))
		m_lines.push_back(ns);
	      ss.erase();
	      continue;
	    } // if 10;
	  ss+=s[i];
	} // for;
      return 0;
    };
  std::vector<vm_string> m_lines;
}; // class vm_file_reader;

bool vm_conf::load(const vm_string &file_name, vm_string &log)
{
  if (!vm_conf_parser::load(file_name, log))
    return 0;

  section& gl=get_global_section();
  if (!check(WSTR("datadir")))
    gl[WSTR("datadir")]=WSTR("./");
  if (gl[WSTR("datadir")].empty())
    gl[WSTR("datadir")]=WSTR("./");
  int len=gl[WSTR("datadir")].length();
  if (gl[WSTR("datadir")][len-1]!= WSTR('/'))
    gl[WSTR("datadir")]+=WSTR('/');
  const vm_string& datadir=gl[WSTR("datadir")];
 
  vm_string replacements_file=datadir+WSTR("replacements"), chars_file=datadir+WSTR("charstable"), caps_file=datadir+WSTR("caps");
  vm_file_reader reader;

  if (!caps_file.empty())
    {
      int r=reader.run(caps_file);
      if (r < 0)
	{
	  log += WSTR("Could not read \'") + caps_file + WSTR("\'.\n");
	  return 0;
	}
      if (r>0)
	{
	  vm_ostringstream os;
	  os << caps_file << WSTR("(") << r << WSTR("):illegal UTF-8 sequence.\n");
	  log += os.str();
	  return 0;
	}
      const std::vector<vm_string>& lines=reader.m_lines;
      for(int k=0;k<lines.size();k++)
	{
	  const vm_string& ss=lines[k];
	  int l, r;
	  if (ss[0]==WSTR('+'))
	    l=1; else
	      l=0;
	  if (ss[ss.length()-1]==WSTR('+'))
	    r=ss.length()-2; else
	      r=ss.length()-1;
	  if (r<l)
	    {
	      log += caps_file + WSTR(":\'") + ss + WSTR("\' is not a valid line.\n");
	      return 0;
	    }
	  vm_string value;
	  for(int t=l;t<=r;t++)
	    {
	      if (eng_lang.get_char_type(ss[t])==0)
		{
		  log += caps_file + WSTR(":\'") + ss + WSTR("\' is not a valid line.\n");
		  return 0;
		} // if not valid char;
	      value+=ss[t];
	    } // for valid chars;
	  eng_lang.add_cap_item(value, ss[0]==WSTR('+'), ss[ss.length()-1]==WSTR('+'));
	}  // for lines;
    } // caps;

  if (!replacements_file.empty())
    {
      int r=reader.run(replacements_file);
      if (r < 0)
	{
	  log += WSTR("Could not read \'") + replacements_file + WSTR("\'.\n");
	  return 0;
	}
      if (r>0)
	{
	  vm_ostringstream os;
	  os << replacements_file << WSTR("(") << r << WSTR("):illegal UTF-8 sequence.\n");
	  log += os.str();
	  return 0;
	}
      m_replacements=reader.m_lines;
    } // replacements;

  if (!chars_file.empty())
    {
      int r=reader.run(chars_file);
      if (r < 0)
	{
	  log += WSTR("Could not read \'") + chars_file + WSTR("\'.\n");
	  return 0;
	}
      if (r>0)
	{
	  vm_ostringstream os;
	  os << chars_file << WSTR("(") << r << WSTR("):illegal UTF-8 sequence.\n");
	  log += os.str();
	  return 0;
	}
      m_chars=reader.m_lines;
    } // chars;
  return 1;
}

int vm_conf::params(const vm_string &sect, const vm_string &param) const
{
// Globals:
  VMCONF_DECLARE_PARAM("global", "startingmessage");
  VMCONF_DECLARE_STRING_PARAM("global", "datadir");
  VMCONF_DECLARE_STRING_PARAM("global", "digits");
  VMCONF_DECLARE_BOOLEAN_PARAM("global", "capitalization");
  VMCONF_DECLARE_BOOLEAN_PARAM("global", "separation");
  VMCONF_DECLARE_BOOLEAN_PARAM("global", "tones");
  VMCONF_DECLARE_BOOLEAN_PARAM("global", "tonesinqueue");
  VMCONF_DECLARE_STRING_PARAM("global", "socket");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "port");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "loglevel");
  VMCONF_DECLARE_STRING_PARAM("global", "logfilename");
  VMCONF_DECLARE_BOOLEAN_PARAM("global", "logtostderr");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "maxqueue");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "loopdelay");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "maxinputline");
  VMCONF_DECLARE_UINTEGER_PARAM("global", "maxclients");
// Output:
  VMCONF_DECLARE_STRING_PARAM("output", "type");
  VMCONF_DECLARE_STRING_PARAM("output", "name");
  VMCONF_DECLARE_STRING_PARAM("output", "lang");
  VMCONF_DECLARE_STRING_PARAM("output", "command");
  VMCONF_DECLARE_STRING_PARAM("output", "pitch");
  VMCONF_DECLARE_STRING_PARAM("output", "rate");
  VMCONF_DECLARE_STRING_PARAM("output", "volume");
  VMCONF_DECLARE_STRING_PARAM("output", "caplist");
// Default:
  VMCONF_DECLARE_STRING_PARAM("default", "output");
  VMCONF_DECLARE_STRING_PARAM("default", "chars");
  return 0;
}

void vm_conf::get_replacement(uint index, vm_string &output, vm_string &old_str, vm_string &new_str) const
{
  assert(index < m_replacements.size());
  const vm_string &s=m_replacements[index];
  output=s.substr(0);
  old_str=s.substr(1);
  if (old_str==WSTR("cln"))
    old_str=WSTR(":");
  if (old_str==WSTR("hsh"))
    old_str=WSTR("#");
  new_str=s.substr(2);
}

void vm_conf::get_chars_table_item(uint index, vm_char &c, vm_string &s) const
{
  assert(index < m_chars.size());
  const vm_string &ss=m_chars[index];
  vm_string sss=ss.substr(0);
  if (sss.empty())
    c=0; else
      if (sss==WSTR("cln"))
	c =WSTR(':'); else
	  if (sss==WSTR("hsh"))
	    c =WSTR('#'); else
	      c=sss[0];
  s=ss.substr(1);
}
