/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __CONF_H__
#define __CONF_H__

#include"confparse.h"

class vm_conf : public vm_conf_parser
{
public:
  typedef vm_ptr<vm_conf> ptr;
  vm_conf() {};
  virtual ~vm_conf() {};
  bool load(const vm_string &file_name, vm_string &log);
  bool check(const vm_string &name) {return get_global_section().check(name);};
  vm_string get(const vm_string &name) {return get_global_section()[name];};
  void add_option(const vm_string &name, const vm_string &value){get_global_section()[name]=value;};
  uint get_chars_table_item_count() const{return m_chars.size();};
  void get_chars_table_item(uint index, vm_char &c, vm_string &s) const;
  vm_string get_default_output() {return find(WSTR("default"))[WSTR("output")];};
  vm_string get_default_chars() {return find(WSTR("default"))[WSTR("chars")];};
  uint get_replacement_count() const{return m_replacements.size();};
  void get_replacement(uint index, vm_string &output, vm_string &old_str, vm_string &new_str) const;
protected:
  section &get_global_section() {return find(WSTR("global"));};
  virtual int params(const vm_string &sect, const vm_string &param) const;
  std::vector<vm_string> m_replacements, m_chars;
}; // class vm_conf;

#endif // __CONF_H__
