/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"confparse.h"

bool vm_conf_parser::load(const vm_string &file_name, vm_string &log)
{
  log.erase();
  string s;
  if (!read_text_file(vm_string2io(file_name), s))
    {
      log += WSTR("Could not read file \'")+file_name+WSTR("\'.\n");
      return 0;
    }
  std::vector<vm_string> lines;
  uint i;
  string ss;
  vm_string vms;
  for(i=0;i<s.length();i++)
    {
      if (s[i]==13)
	continue;
      if (s[i]==10)
	{
	  if (!decode1_utf8(ss, vms))
	    {
	      vm_ostringstream os;
	      os << file_name << WSTR("(") << lines.size()+1 << WSTR("):could not decode UTF-8 sequence.\n");
	      log += os.str();
	      return 0;
	    }
	  lines.push_back(vms);
	  ss.erase();
	  continue;
	}
      ss += s[i];
    }
  if (!decode1_utf8(ss, vms))
    {
      vm_ostringstream os;
      os << file_name << WSTR("(") << lines.size()+1 << WSTR("):could not decode UTF-8 sequence.\n");
      log += os.str();
      return 0;
    }
  lines.push_back(vms);
  vmlog << vminfo << WSTR("Text of \'") << file_name << WSTR("\' was read and decoded successfully.") << vmendl;
  section sec;
  bool sec_init=0;
  for(i=0;i<lines.size();i++)
    {
      vm_string s1, s2;
      uint code, state;
      if (!process(lines[i], code, s1, s2, state))
	{
	  vm_ostringstream os;
	  os << file_name << WSTR("(") << i+1 << WSTR("):sintax error(") << state << WSTR(").\n");
	  log += os.str();
	  return 0;
	}
      if (code==0)
	continue;
      if (code==1)
	{
	  if (sec_init)
	    m_sections.push_back(sec);
	  sec_init=1;
	  sec.m_name=s1;
	  if (sec.m_name.empty())
	    {
	      vm_ostringstream os;
	      os << file_name << WSTR("(") << i+1 << WSTR("):section could not be without name.\n");
	      log += os.str();
	      return 0;
	    } // empty name of section
	  sec.clear();
	  continue;
	} // section
      if (code == 2)
	{
	  if (!sec_init)
	    {
	      vm_ostringstream os;
	      os << file_name << WSTR("(") << i+1 << WSTR("):parameter is outside of section.\n");
	      log += os.str();
	      return 0;
	    }
	  sec[s1]=s2;
	  continue;
	} // param
    } // for lines
  if (sec_init)
    m_sections.push_back(sec);
  vmlog << vminfo << WSTR("Checking params for \'") << file_name << WSTR("\'.") << vmendl;
  return check_params(log);
}

bool vm_conf_parser::process(const vm_string &line, uint &code, vm_string &str1, vm_string &str2, uint &state)
{
  vm_string loline=line.lower_case();
  uint i;
  state=0;
  str1.erase();
  str2.erase();
  code=0;
  for(i=0;i<line.length();i++)
    {
      if (state==0 && line[i]==WSTR(' '))
	continue;
      if (state==0 && line[i]==WSTR('\t'))
	continue;
      if (state==0 && line[i]==WSTR('#'))
	return 1;
      if (state==0 && line[i]==WSTR('['))
	{
	  code=1;
	  for(i++;i<line.length();i++)
	    {
	      if (line[i]==WSTR(' '))
		continue;
	      if (line[i]==WSTR(']'))
		return 1;
	      if (loline[i]>=WSTR('a') && loline[i]<=WSTR('z'))
		{
		  str1+=loline[i];
		  continue;
		}
	      return 0;
	    }  // for
	} // section
      if (state==0 && loline[i]>=WSTR('a') && loline[i]<=WSTR('z'))
	{
	  str1+=loline[i];
	  code=2;
	  state=1;
	  continue;
	}
      if (state==1 && (line[i]==WSTR(' ') || line[i]==WSTR('_')))
	continue;
      if (state==1 && loline[i]>=WSTR('a') && loline[i]<=WSTR('z'))
	{
	  str1+=loline[i];
	  continue;
	}
      if (state==1 && line[i]>=WSTR('0') && line[i]<=WSTR('9'))
	{
	  str1+=line[i];
	  continue;
	}
      if (state==1 && line[i]==WSTR('='))
	{
	  state=2;
	  continue;
	}
      if (state==2 && line[i]==WSTR(' '))
	continue;
      if (state == 2 && ((loline[i]>=WSTR('a') && loline[i] <= WSTR('z')) || (line[i]>=WSTR('0') && (line[i]<=WSTR('9')))))
	{
	  for(;i<line.length();i++)
	    {
	      if (line[i]==WSTR('_') || (line[i]>=WSTR('a') && line[i] <= WSTR('z')) || (line[i]>=WSTR('A') && line[i] <= WSTR('Z')) || (loline[i]>=WSTR('0') && line[i]<=WSTR('9')) )
		str2+=line[i]; else
		  break;
	    } // for
	  for(;i<line.length();i++)
	    {
	      if (line[i]==WSTR(' '))
		continue;
	      if (line[i]==WSTR('#'))
		return 1;
	      return 0;
	    }
	  return 1;
	} // no quotas;
      if (state==2 && line[i]==WSTR('\"'))
	{
	  state=3;
	  continue;
	}
      if (state==3 && line[i]!=WSTR('\"'))
	{
	  str2+=line[i];
	  continue;
	}
      if (state==3 && line[i]==WSTR('\"'))
	{
	  state=4;
	  continue;
	}
      if (state==4 && line[i]==WSTR('\"'))
	{
	  state=3;
	  str2+=WSTR('\"');
	  continue;
	}
      if (state==4 && line[i]!=WSTR('\"'))
	return 1;
      return 0;
    } // for
  if (state==4 || state==0)
    return 1;
  return 0;
}

int vm_conf_parser::params(const vm_string &sect, const vm_string &param) const
{
  return -1;
}

bool vm_conf_parser::check_params(vm_string &log) const
{
  int i;
  for(i=0;i<m_sections.size();i++)
    {
      const section &s=m_sections[i];
      for(section::const_iterator it=s.begin();it!=s.end();it++)
	{
	  int t=params(s.m_name, it->first);
	  const vm_string &v=it->second;
	  if (t<0)
	    continue;
	  if (t== 0)
	    {
	      log +=WSTR("Unknown parameter \'") + it->first + WSTR("\' in section \'")+s.m_name + WSTR("\'.\n");
	      return 0;
	    }// 0;
	  if (t==1 && !v.is<bool>())
	    {
	      log += WSTR("\'")+v+WSTR("\' is not a boolean (Section: \'")+s.m_name +WSTR("\', parameter: \'")+it->first+WSTR("\').\n");
	      return 0;
	    } // boolean;
	  if (t == 2 && v.empty())
	    {
	      log += WSTR("Parameter \'")+it->first+WSTR("\' could not have empty value (Section: \'")+s.m_name +WSTR("\').\n");	
	      return 0;
	    }  // string;
	  if (t == 3 && !v.is<int>())
	    {
	      log	 += WSTR("\'")+v+WSTR("\' is not a integer (Section: \'")+s.m_name +WSTR("\', parameter: \'")+it->first+WSTR("\').\n");
	      return 0;
	    } // integer;
	  if (t == 4 && !v.is<uint>())
	    {
		      log	 += WSTR("\'")+v+WSTR("\' is not a unsigned integer (Section: \'")+s.m_name +WSTR("\', parameter: \'")+it->first+WSTR("\').\n");
	      return 0;
	    }
	} // for params;
    } // for sections;
  return 1;
}
