/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __VM_CONF_PARSE_H__
#define __VM_CONF_PARSE_H__

#define VMCONF_DECLARE_PARAM(s,p) if (sect==WSTR(s) && param==WSTR(p)) return -1
#define VMCONF_DECLARE_BOOLEAN_PARAM(s,p) if (sect==WSTR(s) && param==WSTR(p)) return 1
#define VMCONF_DECLARE_STRING_PARAM(s,p) if (sect==WSTR(s) && param==WSTR(p)) return 2
#define VMCONF_DECLARE_INTEGER_PARAM(s,p) if (sect==WSTR(s) && param==WSTR(p)) return  3
#define VMCONF_DECLARE_UINTEGER_PARAM(s,p) if (sect==WSTR(s) && param==WSTR(p)) return 4

class vm_conf_parser : public vm_class
{
public:
  bool load(const vm_string &file_name, vm_string &log);
  
  class section: public map<vm_string, vm_string>
  {
  public:
    section() {}
    section(const vm_string &name) : m_name(name) {}
    vm_string m_name;

    bool check(const vm_string &name) const
    {
      const_iterator it=find(name);
      return it!=end();
    }
  }; // class section;

  section &find(const vm_string &name)
  {
    int i;
    for(i=0;i<m_sections.size();i++)
      if (m_sections[i].m_name.trim()==name.trim())
	return m_sections[i];
    m_sections.push_back(section(name));
    return m_sections.back();
  }

public:
  std::vector<section> m_sections;

protected:
  /*
    	The following function should return:
		-1 - if param is allowed in sect and can be any type;
		- 0 - if param is not allowed in sect;
		- 1 - if param is allowed in in sect should be boolean type;
		- 2 - if param is allowed in sect and should be a string;
		- 3 - if param is allowed in sect and should be an integer;
		- 4 - if param is allowed in sect and should be an unsigned integer.
*/
  virtual int params(const vm_string &sect, const vm_string &param) const;

private:
  bool process(const vm_string &line, uint &code, vm_string &str1, vm_string &str2, uint &state);
  bool check_params(vm_string &log)const;
};

#endif // __VM_CONF_PARSE_H__
