/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __DISPATCHER_H__
#define __DISPATCHER_H__

extern int config_maxline;
extern bool config_tones, config_tones_in_queue;

class vm_dispatcher: public vm_dispatch_loop, public vm_dp
{
public:
  vm_dispatcher() {};
  virtual ~vm_dispatcher() {};

  bool init(vm_conf::ptr conf);
  void handle_data(const vm_string &str, vm_client::ptr client);
  void text(vm_client::ptr client, const vm_string &t);
  void letter(vm_client::ptr client, vm_char c);
  void stop(vm_client::ptr client);
  void param(vm_client::ptr client, int param_type, const vm_param &p);
  void tone(vm_client::ptr client, int freq, int lengthms);

private:
  vm_string split_and_process(const vm_string &data, vm_client::ptr client);

private:
  vm_processor m_proc;
}; // class vm_dispatcher;

#endif //__DISPATCHER_H__
