/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#ifndef __PROC_H__
#define __PROC_H__

#include"langs.h"

extern int config_digits;
extern bool config_cap, config_sep;
extern std::map<vm_char, vm_string> vm_chars_table;

class vm_text_splitter : public vm_class
{
public:
  typedef vm_ptr<vm_text_splitter> ptr;
  vm_text_splitter() {};
  virtual ~vm_text_splitter() {};
  class text_item : public vm_class
  {
  public:
    text_item() {};
    text_item(const vm_string &output, const vm_string &text): m_output(output), m_text(text) {};
    vm_string m_output, m_text;
  };
  void set_map_items(const vm_string &output_name, const vm_string &items);
  void split_text(const vm_string &text, vector<text_item> &items) /*const*/;
  std::map<vm_char, vm_string> m_map;
  vm_string m_default_output;
};

class vm_text_replacer : public vm_class
{
public:
  typedef vm_ptr<vm_text_replacer> ptr;
  vm_text_replacer() {};
  virtual ~vm_text_replacer() {};
  class replacement
  {
  public:
    replacement() {};
    replacement(const vm_string &output, const vm_string old_str, const vm_string &new_str) : m_output(output), m_old_str(old_str), m_new_str(new_str) {};
    vm_string m_output, m_old_str, m_new_str;
  }; // class replacement
  void add_replacement(const vm_string &output, const vm_string &old_str, const vm_string &new_str);
  vm_string insert_replacements(const vm_string &str, const vm_string &output) const;
private:
  std::vector<replacement> m_replacements;
  bool get_replacement(const vm_string &str, uint pos, const vm_string &output, uint &result) const;
};

class vm_processor :public vm_class
{
public:
  typedef vm_ptr<vm_processor> ptr;
  vm_processor() {};
  virtual ~vm_processor() {};
  void set_text_splitter(vm_text_splitter::ptr splitter) {m_splitter = splitter;};
  void set_text_replacer(vm_text_replacer::ptr replacer) {m_replacer=replacer;};
  void line(const vm_string &text, vm_param volume, vm_param pitch, vm_param rate);
  void letter(vm_char c, vm_param volume, vm_param pitch, vm_param rate);
private:
  vm_text_splitter::ptr m_splitter;
  vm_text_replacer::ptr m_replacer;
  void text_out(const vm_string &output, const vm_string &text, const vector<bool> &mask, vm_param volume, vm_param pitch, vm_param rate) const;
};

#endif // __PROC_H__
