/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/

#include"voiceman.h"
#include"tone.h"

bool vm_tone::play(int fr, int lengthms)
{
  if (fr <= 0)
    {
      vmlog << vmerror << WSTR("could not play tone with frequency \'") << fr << WSTR("\'.") << vmendl;
      return 0;
    }
  if (lengthms <= 10)
    {
      vmlog << vmerror << WSTR("Could not play tone with length of ") << lengthms << WSTR(" ms.") << vmendl;
      return 0;
    }
  ao_device *device;
  ao_sample_format format;
  int default_driver;
  float freq=fr;
  ao_initialize();
  default_driver = ao_default_driver_id();
  format.bits = 16;
  format.channels = 2;
  format.rate = 44100;
  format.byte_format = AO_FMT_LITTLE;
  int samples_to_play = format.rate*lengthms/1000;
  //FIXME:    int samples_to_play=1000;
  device = ao_open_live(default_driver, &format, NULL);
  if (device == NULL) 
    {
      vmlog << vmerror << WSTR("Could not open libao default device.") << vmendl;
      return 0;
    }   
  int buf_size = format.bits/8 * format.channels * samples_to_play;
  char* buffer = (char*)calloc(buf_size, sizeof(char));
  if (buffer == NULL)
    {
      ao_close(device);
      //FIXME:Suse 10.1:      ao_shutdown();
      vmlog << vmerror << WSTR("Could not allocate buffer for tone playback.") << vmendl;
      return 0;
    }
  for (int i = 0; i < samples_to_play; i++) 
    {
      int sample = (int)(0.75 * 32768.0 *
			 sin(2 * M_PI * freq * ((float) i/format.rate)));
      buffer[4*i] = buffer[4*i+2] = sample & 0xff;
      buffer[4*i+1] = buffer[4*i+3] = (sample >> 8) & 0xff;
    }
  ao_play(device, buffer, buf_size);
  ao_close(device);
  ao_shutdown();
  return (1);
}
