/*
	Copyright (c) 2000-2006 Michael Pozhidaev<msp@altlinux.org>. 
   This file is part of the VOICEMAN speech system.

   VOICEMAN speech system is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   VOICEMAN speech system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
*/
#include<stdio.h>//FIXME:
#include<stdlib.h>
#include<string.h>
#include<sys/types.h>
#include<unistd.h>
#include<sys/stat.h>
#include<fcntl.h>
#include<sys/socket.h>
#include<sys/un.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<resolv.h>
#include"vmclient.h"
#include"vmconf.h"

#define INET_PREFIX "TCP/IP:"

static const char* check_inet_prefix(const char* p)
{
  if (strlen(p)<strlen(INET_PREFIX))
    return NULL;
  int k;
  const char* pr=INET_PREFIX;
  for(k=0;k<strlen(pr);k++)
    if (p[k]!=pr[k])
      return NULL;
  return &p[k];
}

static int parse_inet_str(const char* s, char* host, int *port)
{
  int k=0;
  const char* p=s;
  while(*p)
    {
      if (*p==':')
	k++;
      p++;
    }
  if (k==0)
    {
      strcpy(host, s);
      *port=VOICEMAN_DEFAULT_PORT;
      return 1;
    }
  if (k!=1)
    return 0;
  for(k=0;s[k]!=':';k++)
    host[k]=s[k];
  host[k]='\0';
  k++;
  *port=0;
  if (s[k]==':')
    {
      *port=VOICEMAN_DEFAULT_PORT;
      return 1;
    }
  for(;s[k]!='\0';k++)
    {
      if (s[k]<'0' || s[k]>'9')
	return 0;
      *port*=10;
      *port+=(s[k]-'0');
    }
  return 1;
}

vm_connection_t vm_connect()
{
  const char* vm=getenv("VOICEMAN");
  if (vm==NULL || vm[0]=='\0')
    return vm_connect_unix(VOICEMAN_DEFAULT_SOCKET);
  const char* inet=check_inet_prefix(vm);
  if (inet == NULL)
    return vm_connect_unix(vm);
  char* host=(char*)malloc(strlen(inet)+1);
  if (host==NULL)
    return VOICEMAN_BAD_CONNECTION;
  int port;
  if (!parse_inet_str(inet, host, &port))
    {
      free(host);
      return VOICEMAN_BAD_CONNECTION;
    }
  vm_connection_t con=vm_connect_inet(host, port);
  free(host);
  return con;
}

vm_connection_t vm_connect_unix(const char* path)
{
  struct sockaddr_un addr;
  int fd;
  fd = socket(AF_UNIX, SOCK_STREAM, 0);
  if (fd == -1)
    return VOICEMAN_BAD_CONNECTION;
  addr.sun_family = AF_UNIX;
  strncpy(addr.sun_path, path, sizeof(addr.sun_path));
  if (connect(fd, (struct sockaddr*)&addr, sizeof(struct sockaddr_un)) == -1)
    {
      close(fd);
      return VOICEMAN_BAD_CONNECTION;
    }
  return fd;
}

vm_connection_t vm_connect_inet(const char* host, int port)
{
  int fd;
  struct sockaddr_in saddr;
  fd=socket(AF_INET, SOCK_STREAM, 0);
  if (fd == -1)
    return VOICEMAN_BAD_CONNECTION;
  bzero(&saddr, sizeof(struct sockaddr_in));
  saddr.sin_family=AF_INET;
  saddr.sin_port=htons(port);
  struct hostent *host_addr=gethostbyname(host);
  if (host_addr==NULL)
    {
      close(fd);
      return VOICEMAN_BAD_CONNECTION;
    }
  memcpy(&saddr.sin_addr, host_addr->h_addr, 4);
  if (connect(fd, (struct sockaddr*)&saddr, sizeof(struct sockaddr_in)) == -1)
    {
      close(fd);
      return VOICEMAN_BAD_CONNECTION;
    }
  return fd;
}

void vm_close(vm_connection_t con)
{
  if (con == VOICEMAN_BAD_CONNECTION)
    return;
  close(con);
}

vm_result_t vm_text(vm_connection_t con, const char* text)
{
  if (text == NULL)
    return VOICEMAN_OK;
  int k = strlen(text);
  if (k==0)
    return VOICEMAN_OK;
  if (write(con, "T:", 2)==-1)
    return VOICEMAN_ERROR;
  do {
    char buf[2048];
    int sent_count;
    int i;
    if (k >= sizeof(buf))
      {
	for(i=0;i<sizeof(buf);i++)
	  buf[i] = text[strlen(text)-k+i];
	sent_count = write(con, buf, sizeof(buf));
	if (sent_count == -1)
	  return VOICEMAN_ERROR;
	k-=sent_count;
      } else
	{
	  for(i=0;i<k;i++)
	    buf[i]=text[strlen(text)-k+i];
	  sent_count = write(con, buf, k);
	  if (sent_count == -1)
	    return VOICEMAN_ERROR;
	  k -= sent_count;
	}
  } while(k);
  if (write(con , "\n", 1)==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_stop(vm_connection_t con)
{
  if (write(con, "S:\n", 3)==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_letter(vm_connection_t con, const char* letter)
{
  if (write(con, "L:", 2)==-1)
    return VOICEMAN_ERROR;
  if (write(con, letter, strlen(letter))==-1)
    return VOICEMAN_ERROR;
  if (write(con, "\n", 1)==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_tone(vm_connection_t con, int freq, int lengthms)
{
  char buf[30];
  sprintf(buf, "B:%d:%d\n", freq, lengthms);
  if (write(con, buf, strlen(buf))==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_pitch(vm_connection_t con, int value)
{
  char buf[30];
  sprintf(buf, "P:%d\n", value);
  if (write(con, buf, strlen(buf))==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_rate(vm_connection_t con, int value)
{
  char buf[30];
  sprintf(buf, "R:%d\n", value);
  if (write(con, buf, strlen(buf))==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

vm_result_t vm_volume(vm_connection_t con, int value)
{
  char buf[30];
  sprintf(buf, "V:%d\n", value);
  if (write(con, buf, strlen(buf))==-1)
    return VOICEMAN_ERROR;
  return VOICEMAN_OK;
}

